/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.jeview.JEViewPlugin;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class JavaElementProperties
implements IPropertySource {
    private static HashMap<String, Property> fgIdToProperty = new HashMap();
    private static LinkedHashMap<Class<?>, List<Property>> fgTypeToProperty = new LinkedHashMap();
    protected IJavaElement fJavaElement;

    static {
        JavaElementProperties.addJavaElementProperties();
        JavaElementProperties.addClassFileProperties();
        JavaElementProperties.addCompilationUnitProperties();
        JavaElementProperties.addImportDeclarationProperties();
        JavaElementProperties.addJavaProjectProperties();
        JavaElementProperties.addLocalVariableProperties();
        JavaElementProperties.addMemberProperties();
        JavaElementProperties.addFieldProperties();
        JavaElementProperties.addMethodProperties();
        JavaElementProperties.addTypeProperties();
        JavaElementProperties.addAnnotationProperties();
        JavaElementProperties.addPackageFragmentProperties();
        JavaElementProperties.addPackageFragmentRootProperties();
        JavaElementProperties.addParentProperties();
        JavaElementProperties.addSourceReferenceProperties();
        JavaElementProperties.addOpenableProperties();
    }

    private static void addJavaElementProperties() {
        JavaElementProperties.addProperty(new Property((Class)IJavaElement.class, "elementName"){

            @Override
            public Object compute(IJavaElement element) {
                return element.getElementName();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IJavaElement.class, "elementType"){

            @Override
            public Object compute(IJavaElement element) {
                return JavaElementProperties.getElementTypeString(element.getElementType());
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IJavaElement.class, "exists"){

            @Override
            public Object compute(IJavaElement element) {
                return element.exists();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IJavaElement.class, "isReadOnly"){

            @Override
            public Object compute(IJavaElement element) {
                return element.isReadOnly();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IJavaElement.class, "isStructureKnown"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return element.isStructureKnown();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IJavaElement.class, "handleIdentifier"){

            @Override
            public Object compute(IJavaElement element) {
                return element.getHandleIdentifier();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IJavaElement.class, "path"){

            @Override
            public Object compute(IJavaElement element) {
                return element.getPath();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IJavaElement.class, "schedulingRule"){

            @Override
            public Object compute(IJavaElement element) {
                return JavaElementProperties.getSchedulingRuleString(element.getSchedulingRule());
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IJavaElement.class, "| IJavaProject#isOnClasspath(this)"){

            @Override
            public Object compute(IJavaElement element) {
                IJavaProject javaProject = element.getJavaProject();
                return javaProject == null ? null : Boolean.valueOf(javaProject.isOnClasspath(element));
            }
        });
    }

    private static void addClassFileProperties() {
        JavaElementProperties.addProperty(new Property((Class)IClassFile.class, "isClass"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IClassFile)element).isClass();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IClassFile.class, "isInterface"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IClassFile)element).isInterface();
            }
        });
    }

    private static void addCompilationUnitProperties() {
        JavaElementProperties.addProperty(new Property((Class)ICompilationUnit.class, "hasResourceChanged"){

            @Override
            public Object compute(IJavaElement element) {
                return ((ICompilationUnit)element).hasResourceChanged();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)ICompilationUnit.class, "isWorkingCopy"){

            @Override
            public Object compute(IJavaElement element) {
                return ((ICompilationUnit)element).isWorkingCopy();
            }
        });
    }

    private static void addImportDeclarationProperties() {
        JavaElementProperties.addProperty(new Property((Class)IImportDeclaration.class, "flags"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return JavaElementProperties.getFlagsString(((IImportDeclaration)element).getFlags(), IImportDeclaration.class);
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IImportDeclaration.class, "isOnDemand"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IImportDeclaration)element).isOnDemand();
            }
        });
    }

    private static void addJavaProjectProperties() {
        JavaElementProperties.addProperty(new Property((Class)IJavaProject.class, "hasBuildState"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IJavaProject)element).hasBuildState();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IJavaProject.class, "getOutputLocation"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IJavaProject)element).getOutputLocation();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IJavaProject.class, "readOutputLocation"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IJavaProject)element).readOutputLocation();
            }
        });
    }

    private static void addLocalVariableProperties() {
        JavaElementProperties.addProperty(new Property((Class)ILocalVariable.class, "typeSignature"){

            @Override
            public Object compute(IJavaElement element) {
                return ((ILocalVariable)element).getTypeSignature();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)ILocalVariable.class, "flags"){

            @Override
            public Object compute(IJavaElement element) {
                return JavaElementProperties.getFlagsString(((ILocalVariable)element).getFlags(), element.getClass());
            }
        });
        JavaElementProperties.addProperty(new Property((Class)ILocalVariable.class, "isParameter"){

            @Override
            public Object compute(IJavaElement element) {
                return ((ILocalVariable)element).isParameter();
            }
        });
    }

    private static void addAnnotationProperties() {
        JavaElementProperties.addProperty(new Property((Class)IAnnotation.class, "occurrenceCount"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IAnnotation)element).getOccurrenceCount();
            }
        });
    }

    private static void addMemberProperties() {
        JavaElementProperties.addProperty(new Property((Class)IMember.class, "javadocRange"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return JavaElementProperties.getSourceRangeString(((IMember)element).getJavadocRange());
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IMember.class, "flags"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return JavaElementProperties.getFlagsString(((IMember)element).getFlags(), element.getClass());
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IMember.class, "isBinary"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IMember)element).isBinary();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IMember.class, "occurrenceCount"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IMember)element).getOccurrenceCount();
            }
        });
    }

    private static void addFieldProperties() {
        JavaElementProperties.addProperty(new Property((Class)IField.class, "isResolved"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IField)element).isResolved();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IField.class, "key"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IField)element).getKey();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IField.class, "typeSignature"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IField)element).getTypeSignature();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IField.class, "constant"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IField)element).getConstant();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IField.class, "isEnumConstant"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IField)element).isEnumConstant();
            }
        });
    }

    private static void addMethodProperties() {
        JavaElementProperties.addProperty(new Property((Class)IMethod.class, "isResolved"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IMethod)element).isResolved();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IMethod.class, "key"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IMethod)element).getKey();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IMethod.class, "key - signature"){

            @Override
            public Object compute(IJavaElement element) {
                String key = ((IMethod)element).getKey();
                if (key != null) {
                    return new BindingKey(key).toSignature();
                }
                return "<no key>";
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IMethod.class, "numberOfParameters"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IMethod)element).getNumberOfParameters();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IMethod.class, "signature"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IMethod)element).getSignature();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IMethod.class, "returnType"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IMethod)element).getReturnType();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IMethod.class, "isConstructor"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IMethod)element).isConstructor();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IMethod.class, "isMainMethod"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IMethod)element).isMainMethod();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IMethod.class, "isLambdaMethod"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IMethod)element).isLambdaMethod();
            }
        });
    }

    private static void addTypeProperties() {
        JavaElementProperties.addProperty(new Property((Class)IType.class, "isResolved"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IType)element).isResolved();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IType.class, "key"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IType)element).getKey();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IType.class, "fullyQualifiedName"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IType)element).getFullyQualifiedName();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IType.class, "fullyQualifiedName('*')"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IType)element).getFullyQualifiedName('*');
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IType.class, "fullyQualifiedParameterizedName"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IType)element).getFullyQualifiedParameterizedName();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IType.class, "typeQualifiedName"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IType)element).getTypeQualifiedName();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IType.class, "typeQualifiedName('*')"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IType)element).getTypeQualifiedName('*');
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IType.class, "isAnnotation"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IType)element).isAnnotation();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IType.class, "isClass"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IType)element).isClass();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IType.class, "isEnum"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IType)element).isEnum();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IType.class, "isInterface"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IType)element).isInterface();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IType.class, "isAnonymous"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IType)element).isAnonymous();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IType.class, "isLocal"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IType)element).isLocal();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IType.class, "isMember"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IType)element).isMember();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IType.class, "isLambda"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IType)element).isLambda();
            }
        });
    }

    private static void addPackageFragmentProperties() {
        JavaElementProperties.addProperty(new Property((Class)IPackageFragment.class, "containsJavaResources"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IPackageFragment)element).containsJavaResources();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IPackageFragment.class, "kind"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return JavaElementProperties.getPFRKindString(((IPackageFragment)element).getKind());
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IPackageFragment.class, "hasSubpackages"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IPackageFragment)element).hasSubpackages();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IPackageFragment.class, "isDefaultPackage"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IPackageFragment)element).isDefaultPackage();
            }
        });
    }

    private static void addPackageFragmentRootProperties() {
        JavaElementProperties.addProperty(new Property((Class)IPackageFragmentRoot.class, "kind"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return JavaElementProperties.getPFRKindString(((IPackageFragmentRoot)element).getKind());
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IPackageFragmentRoot.class, "sourceAttachmentPath"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IPackageFragmentRoot)element).getSourceAttachmentPath();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IPackageFragmentRoot.class, "sourceAttachmentRootPath"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IPackageFragmentRoot)element).getSourceAttachmentRootPath();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IPackageFragmentRoot.class, "isArchive"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IPackageFragmentRoot)element).isArchive();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IPackageFragmentRoot.class, "isExternal"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IPackageFragmentRoot)element).isExternal();
            }
        });
    }

    private static void addParentProperties() {
        JavaElementProperties.addProperty(new Property((Class)IParent.class, "hasChildren"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IParent)element).hasChildren();
            }
        });
    }

    private static void addSourceReferenceProperties() {
        JavaElementProperties.addProperty(new Property((Class)ISourceReference.class, "sourceRange"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return JavaElementProperties.getSourceRangeString(((ISourceReference)element).getSourceRange());
            }
        });
        JavaElementProperties.addProperty(new Property((Class)ISourceReference.class, "nameRange"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return JavaElementProperties.getSourceRangeString(((ISourceReference)element).getNameRange());
            }
        });
    }

    private static void addOpenableProperties() {
        JavaElementProperties.addProperty(new Property((Class)IOpenable.class, "hasUnsavedChanges"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IOpenable)element).hasUnsavedChanges();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IOpenable.class, "isConsistent"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                return ((IOpenable)element).isConsistent();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IOpenable.class, "isOpen"){

            @Override
            public Object compute(IJavaElement element) {
                return ((IOpenable)element).isOpen();
            }
        });
        JavaElementProperties.addProperty(new Property((Class)IOpenable.class, "findRecommendedLineSeparator"){

            @Override
            public Object compute(IJavaElement element) throws JavaModelException {
                String lineSeparator = ((IOpenable)element).findRecommendedLineSeparator();
                lineSeparator = lineSeparator.replace("\r", "\\r").replace("\n", "\\n");
                return lineSeparator;
            }
        });
    }

    private static void addProperty(Property property) {
        fgIdToProperty.put(property.getId(), property);
        List<Property> properties = fgTypeToProperty.get(property.getType());
        if (properties == null) {
            properties = new ArrayList<Property>();
            fgTypeToProperty.put(property.getType(), properties);
        }
        properties.add(property);
    }

    public JavaElementProperties(IJavaElement javaElement) {
        this.fJavaElement = javaElement;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        for (Map.Entry<Class<?>, List<Property>> entry : fgTypeToProperty.entrySet()) {
            if (!entry.getKey().isAssignableFrom(this.fJavaElement.getClass())) continue;
            for (Property property : entry.getValue()) {
                result.add(property.getDescriptor());
            }
        }
        return result.toArray(new IPropertyDescriptor[result.size()]);
    }

    public Object getPropertyValue(Object id) {
        Property property = fgIdToProperty.get(id);
        if (property == null) {
            return null;
        }
        try {
            return property.compute(this.fJavaElement);
        }
        catch (JavaModelException e) {
            if (e.isDoesNotExist()) {
                return "JavaModelException: " + e.getLocalizedMessage();
            }
            JEViewPlugin.log("error calculating property '" + property.getType().getSimpleName() + "#" + property.getName() + "'", e);
            return "Error: " + e.getLocalizedMessage();
        }
    }

    static String getElementTypeString(int elementType) {
        return elementType + " (" + (switch (elementType) {
            case 1 -> "IJavaModel";
            case 2 -> "IJavaProject";
            case 3 -> "IPackageFragmentRoot";
            case 4 -> "IPackageFragment";
            case 5 -> "ICompilationUnit";
            case 6 -> "IClassFile";
            case 7 -> "IType";
            case 8 -> "IField";
            case 9 -> "IMethod";
            case 10 -> "IInitializer";
            case 11 -> "IPackageDeclaration";
            case 12 -> "IImportContainer";
            case 13 -> "IImportDeclaration";
            case 14 -> "ILocalVariable";
            case 15 -> "ITypeParameter";
            case 16 -> "IAnnotation";
            default -> "UNKNOWN";
        }) + ")";
    }

    static String getSourceRangeString(ISourceRange range) {
        return range == null ? "null" : range.getOffset() + " + " + range.getLength();
    }

    static String getFlagsString(int flags, Class<? extends IJavaElement> clazz) {
        int len;
        StringBuffer sb = new StringBuffer().append("0x").append(Integer.toHexString(flags)).append(" (");
        int prologLen = sb.length();
        int rest = flags;
        rest &= ~JavaElementProperties.appendFlag(sb, flags, 1, "public ");
        rest &= ~JavaElementProperties.appendFlag(sb, flags, 2, "private ");
        rest &= ~JavaElementProperties.appendFlag(sb, flags, 4, "protected ");
        rest &= ~JavaElementProperties.appendFlag(sb, flags, 8, "static ");
        rest &= ~JavaElementProperties.appendFlag(sb, flags, 16, "final ");
        boolean isMethod = IMethod.class.isAssignableFrom(clazz);
        if (isMethod) {
            rest &= ~JavaElementProperties.appendFlag(sb, flags, 32, "synchronized ");
            rest &= ~JavaElementProperties.appendFlag(sb, flags, 64, "bridge ");
            rest &= ~JavaElementProperties.appendFlag(sb, flags, 128, "varargs ");
            rest &= ~JavaElementProperties.appendFlag(sb, flags, 65536, "default(method) ");
        } else {
            rest &= ~JavaElementProperties.appendFlag(sb, flags, 32, "super ");
            rest &= ~JavaElementProperties.appendFlag(sb, flags, 64, "volatile ");
            rest &= ~JavaElementProperties.appendFlag(sb, flags, 128, "transient ");
        }
        rest &= ~JavaElementProperties.appendFlag(sb, flags, 256, "native ");
        rest &= ~JavaElementProperties.appendFlag(sb, flags, 512, "interface ");
        rest &= ~JavaElementProperties.appendFlag(sb, flags, 1024, "abstract ");
        rest &= ~JavaElementProperties.appendFlag(sb, flags, 2048, "strictfp ");
        rest &= ~JavaElementProperties.appendFlag(sb, flags, 4096, "synthetic ");
        rest &= ~JavaElementProperties.appendFlag(sb, flags, 8192, "annotation ");
        rest &= ~JavaElementProperties.appendFlag(sb, flags, 16384, "enum ");
        rest &= ~JavaElementProperties.appendFlag(sb, flags, 0x100000, "deprecated ");
        if (isMethod) {
            rest &= ~JavaElementProperties.appendFlag(sb, flags, 131072, "default(annotation) ");
        }
        if (rest != 0) {
            sb.append("unknown:0x").append(Integer.toHexString(rest)).append(" ");
        }
        if ((len = sb.length()) != prologLen) {
            sb.setLength(len - 1);
        }
        sb.append(")");
        return sb.toString();
    }

    private static int appendFlag(StringBuffer sb, int flags, int flag, String name) {
        if ((flags & flag) != 0) {
            sb.append(name);
            return flag;
        }
        return 0;
    }

    static String getPFRKindString(int kind) {
        int len;
        StringBuffer sb = new StringBuffer().append("0x").append(Integer.toHexString(kind)).append(" (");
        int prologLen = sb.length();
        int rest = kind;
        rest &= ~JavaElementProperties.appendFlag(sb, kind, 2, "binary ");
        if ((rest &= ~JavaElementProperties.appendFlag(sb, kind, 1, "source ")) != 0) {
            sb.append("unknown:0x").append(Integer.toHexString(rest));
        }
        if ((len = sb.length()) != prologLen) {
            sb.setLength(len - 1);
        }
        sb.append(")");
        return sb.toString();
    }

    static String getSchedulingRuleString(ISchedulingRule schedulingRule) {
        if (schedulingRule == null) {
            return null;
        }
        return schedulingRule.getClass().getSimpleName() + ": " + schedulingRule.toString();
    }

    public void setPropertyValue(Object name, Object value) {
    }

    public Object getEditableValue() {
        return this;
    }

    public boolean isPropertySet(Object property) {
        return false;
    }

    public void resetPropertyValue(Object property) {
    }

    private static abstract class Property {
        private final Class<?> fType;
        private final String fName;
        private final String fId;
        private final PropertyDescriptor fDescriptor;

        public Property(Class<?> type, String name) {
            this.fType = type;
            this.fName = name;
            this.fId = "org.eclipse.jdt.jeview." + type.getSimpleName() + "." + name;
            this.fDescriptor = new PropertyDescriptor((Object)this.fId, this.fName);
            this.fDescriptor.setAlwaysIncompatible(true);
            this.fDescriptor.setCategory(type.getSimpleName());
        }

        public abstract Object compute(IJavaElement var1) throws JavaModelException;

        public Class<?> getType() {
            return this.fType;
        }

        public String getName() {
            return this.fName;
        }

        public String getId() {
            return this.fId;
        }

        public PropertyDescriptor getDescriptor() {
            return this.fDescriptor;
        }
    }
}

