/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.emf.cdo.internal.server.FileUserAuthenticator;
import org.eclipse.emf.cdo.server.IRepositoryProtector;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.spi.server.AbstractOperationAuthorizer;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.factory.ProductCreationException;

public abstract class FileOperationAuthorizer
extends AbstractOperationAuthorizer<ISession> {
    private final Set<String> values;

    public FileOperationAuthorizer(String operationID, Set<String> values) {
        super(operationID);
        this.values = values;
    }

    public final Set<String> getValues() {
        return this.values;
    }

    @Override
    protected String authorizeOperation(ISession session, Map<String, Object> parameters) {
        IRepositoryProtector protector = session.getManager().getRepository().getProtector();
        if (protector == null) {
            return "No repository protector";
        }
        String userID = session.getUserID();
        if (userID == null) {
            return "No user ID";
        }
        FileUserAuthenticator.FileUserInfo userInfo = (FileUserAuthenticator.FileUserInfo)protector.getUserInfo(userID);
        if (userInfo == null) {
            return "User " + userID + " is not authenticated";
        }
        if (this.authorizeOperation(userInfo, this.values)) {
            return null;
        }
        return "User " + userID + " is not authorized";
    }

    protected abstract boolean authorizeOperation(FileUserAuthenticator.FileUserInfo var1, Set<String> var2);

    public static abstract class Factory
    extends AbstractOperationAuthorizer.Factory<ISession> {
        public Factory(String type) {
            super(type);
        }

        protected FileOperationAuthorizer create(String operationID, String description) throws ProductCreationException {
            HashSet<String> values = new HashSet<String>();
            if (description != null) {
                String[] stringArray = description.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if ((value = value.trim()).length() != 0) {
                        values.add(value);
                    }
                    ++n2;
                }
            }
            return this.create(operationID, values);
        }

        protected abstract FileOperationAuthorizer create(String var1, Set<String> var2) throws ProductCreationException;
    }

    public static final class RequireAdmin
    extends FileOperationAuthorizer {
        private final boolean administrator;

        public RequireAdmin(String operationID, Set<String> values) {
            super(operationID, null);
            this.administrator = ObjectUtil.isEmpty(values) ? true : StringUtil.isTrue((String)values.iterator().next());
        }

        @Override
        protected boolean authorizeOperation(FileUserAuthenticator.FileUserInfo userInfo, Set<String> values) {
            return userInfo.administrator() == this.administrator;
        }

        public static final class Factory
        extends org.eclipse.emf.cdo.internal.server.FileOperationAuthorizer$Factory {
            public static final String TYPE = "fileRequireAdmin";

            public Factory() {
                super(TYPE);
            }

            @Override
            protected FileOperationAuthorizer create(String operationID, Set<String> values) throws ProductCreationException {
                return new RequireAdmin(operationID, values);
            }
        }
    }

    public static final class RequireGroup
    extends FileOperationAuthorizer {
        private static final String GROUPS_ATTRIBUTE = "groups";

        public RequireGroup(String operationID, Set<String> values) {
            super(operationID, values);
        }

        @Override
        protected boolean authorizeOperation(FileUserAuthenticator.FileUserInfo userInfo, Set<String> values) {
            String groupsAttribute = userInfo.attributes().get(GROUPS_ATTRIBUTE);
            if (!StringUtil.isEmpty((String)groupsAttribute)) {
                StringTokenizer tokenizer = new StringTokenizer(groupsAttribute, ",");
                while (tokenizer.hasMoreTokens()) {
                    String group = tokenizer.nextToken().trim();
                    if (!values.contains(group)) continue;
                    return true;
                }
            }
            return false;
        }

        public static final class Factory
        extends org.eclipse.emf.cdo.internal.server.FileOperationAuthorizer$Factory {
            public static final String TYPE = "fileRequireGroup";

            public Factory() {
                super(TYPE);
            }

            @Override
            protected FileOperationAuthorizer create(String operationID, Set<String> values) throws ProductCreationException {
                return new RequireGroup(operationID, values);
            }
        }
    }

    public static final class RequireUser
    extends FileOperationAuthorizer {
        public RequireUser(String operationID, Set<String> values) {
            super(operationID, values);
        }

        @Override
        protected boolean authorizeOperation(FileUserAuthenticator.FileUserInfo userInfo, Set<String> values) {
            String userID = userInfo.userID();
            return values.contains(userID);
        }

        public static final class Factory
        extends org.eclipse.emf.cdo.internal.server.FileOperationAuthorizer$Factory {
            public static final String TYPE = "fileRequireUser";

            public Factory() {
                super(TYPE);
            }

            @Override
            protected FileOperationAuthorizer create(String operationID, Set<String> values) throws ProductCreationException {
                return new RequireUser(operationID, values);
            }
        }
    }
}

