/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.state;

import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ContextState {
    private boolean dirty;
    private final IInteractionContext context;
    private String contextHandle;
    private final XMLMemento memento;

    public ContextState(IInteractionContext context, String contextHandle, XMLMemento memento) {
        Assert.isNotNull((Object)memento);
        Assert.isNotNull((Object)contextHandle);
        this.context = context;
        this.contextHandle = contextHandle;
        this.memento = memento;
    }

    void setContextHandle(String contextHandle) {
        this.contextHandle = contextHandle;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ContextState)) {
            return false;
        }
        return this.context.equals(((ContextState)obj).context);
    }

    public int hashCode() {
        return this.context.hashCode();
    }

    public String getContextHandle() {
        return this.contextHandle;
    }

    public IInteractionContext getContext() {
        return this.context;
    }

    XMLMemento getMemento() {
        return this.memento;
    }

    public IMemento getMemento(String type) {
        return this.memento.getChild(type);
    }

    public IMemento createMemento(String type) {
        this.dirty = true;
        return this.memento.createChild(type);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void removeMemento(String type) {
        this.memento.createChild(type);
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

