/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IPluginSourcePathLocator;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.BundleManifestSourceLocationManager;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEExtensionRegistry;
import org.eclipse.pde.internal.core.target.TargetPlatformService;
import org.osgi.framework.Version;
import org.osgi.resource.Resource;

public class SourceLocationManager
implements ICoreConstants {
    private SourceExtensions fExtensionLocations;
    private BundleManifestSourceLocationManager fBundleManifestLocator = null;

    public IPath findSourcePath(IPluginBase pluginBase, IPath sourceLibraryPath) {
        if (pluginBase.getId() == null || pluginBase.getVersion() == null) {
            return null;
        }
        IPath relativePath = this.getRelativePath(pluginBase, sourceLibraryPath);
        IPath result = this.searchUserSpecifiedLocations(relativePath);
        if (result == null && (result = this.searchBundleManifestLocations(pluginBase)) == null) {
            result = this.searchExtensionLocations(relativePath, pluginBase);
        }
        return result;
    }

    public URL findSourceFile(IPluginBase pluginBase, IPath filePath) {
        if (pluginBase.getId() == null || pluginBase.getVersion() == null) {
            return null;
        }
        IPath relativePath = this.getRelativePath(pluginBase, filePath);
        IPath result = this.searchUserSpecifiedLocations(relativePath);
        if (result == null) {
            result = this.searchBundleManifestLocations(pluginBase);
            if (result != null) {
                try {
                    URI encodedUri = URIUtil.toURI((URL)result.toFile().toURL());
                    URI jarUri = URIUtil.toJarURI((URI)encodedUri, (IPath)filePath);
                    return new URL(URIUtil.toUnencodedString((URI)jarUri));
                }
                catch (MalformedURLException | URISyntaxException e) {
                    PDECore.log(e);
                }
            }
            result = this.searchExtensionLocations(relativePath, pluginBase);
        }
        if (result != null) {
            try {
                return result.toFile().toURL();
            }
            catch (MalformedURLException e) {
                PDECore.log(e);
            }
        }
        return null;
    }

    public File findSourcePlugin(IPluginBase pluginBase) {
        if (pluginBase.getId() == null || pluginBase.getVersion() == null) {
            return null;
        }
        IPath path = this.findSourcePath(pluginBase, null);
        return path == null ? null : path.toFile();
    }

    public boolean hasBundleManifestLocation(IPluginBase plugin) {
        if (plugin.getId() == null || plugin.getVersion() == null) {
            return false;
        }
        return this.getBundleManifestLocator().hasValidSourceLocation(plugin.getId(), new Version(plugin.getVersion()));
    }

    public Set<String> findAllSourceRootsInSourceLocation(IPluginBase plugin) {
        if (plugin.getId() == null || plugin.getVersion() == null) {
            return Collections.emptySet();
        }
        return this.getBundleManifestLocator().getAllSourceRoots(plugin.getId(), new Version(plugin.getVersion()));
    }

    public Set<String> findSourceRoots(IPluginBase plugin) {
        if (plugin.getId() == null || plugin.getVersion() == null) {
            return Collections.emptySet();
        }
        return this.getBundleManifestLocator().getSourceRoots(plugin.getId(), new Version(plugin.getVersion()));
    }

    public void reset() {
        this.fExtensionLocations = null;
        this.fBundleManifestLocator = null;
    }

    public List<IPath> getUserLocations() {
        ArrayList<IPath> userLocations = new ArrayList<IPath>();
        String pref = PDECore.getDefault().getPreferencesManager().getString("source_locations");
        if (pref.length() > 0) {
            this.parseSavedSourceLocations(pref, userLocations);
        }
        return userLocations;
    }

    public Collection<IPath> getExtensionLocations() {
        return this.getExtensions().locations;
    }

    private SourceExtensions getExtensions() {
        if (this.fExtensionLocations == null) {
            this.fExtensionLocations = SourceLocationManager.processExtensions();
        }
        return this.fExtensionLocations;
    }

    public Collection<IPath> getBundleManifestLocations() {
        return this.getBundleManifestLocator().getSourceLocations();
    }

    private IPath getBundleManifestLocation(String pluginID, Version version) {
        return this.getBundleManifestLocator().getSourceLocation(pluginID, version);
    }

    private BundleManifestSourceLocationManager getBundleManifestLocator() {
        if (this.fBundleManifestLocator == null) {
            this.fBundleManifestLocator = this.initializeBundleManifestLocations();
        }
        return this.fBundleManifestLocator;
    }

    private IPath getRelativePath(IPluginBase pluginBase, IPath sourceFilePath) {
        Object pluginDir;
        block4: {
            try {
                pluginDir = pluginBase.getId();
                if (pluginDir != null) break block4;
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        String version = pluginBase.getVersion();
        if (version != null) {
            Version vid = new Version(version);
            pluginDir = (String)pluginDir + "_" + String.valueOf(vid);
        }
        IPath path = IPath.fromOSString((String)pluginDir);
        return sourceFilePath == null ? path : path.append(sourceFilePath);
    }

    private IPath searchUserSpecifiedLocations(IPath relativePath) {
        List<IPath> userLocations = this.getUserLocations();
        for (IPath location : userLocations) {
            IPath fullPath = location.append(relativePath);
            File file = fullPath.toFile();
            if (!file.exists()) continue;
            return fullPath;
        }
        return null;
    }

    private IPath searchExtensionLocations(IPath relativePath, IPluginBase plugin) {
        for (IPath location : this.getExtensionLocations()) {
            IPath fullPath = location.append(relativePath);
            File file = fullPath.toFile();
            if (!file.exists()) continue;
            return fullPath;
        }
        return this.getExtensions().locators.stream().map(locator -> {
            try {
                return locator.locator.locateSource(plugin);
            }
            catch (NoClassDefFoundError | RuntimeException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private IPath searchBundleManifestLocations(IPluginBase pluginBase) {
        IPath location = this.getBundleManifestLocation(pluginBase.getId(), new Version(pluginBase.getVersion()));
        if (location != null && location.toFile().exists()) {
            return location;
        }
        return null;
    }

    private void parseSavedSourceLocations(String text, List<IPath> entries) {
        text = text.replace(File.pathSeparatorChar, ';');
        StringTokenizer stok = new StringTokenizer(text, ";");
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            IPath location = this.parseSourceLocation(token);
            if (location == null) continue;
            entries.add(location);
        }
    }

    private IPath parseSourceLocation(String text) {
        String path;
        try {
            text = text.trim();
            int commaIndex = text.lastIndexOf(44);
            if (commaIndex == -1) {
                return IPath.fromOSString((String)text);
            }
            int atLoc = text.indexOf(64);
            path = atLoc == -1 ? text.substring(0, commaIndex) : text.substring(atLoc + 1, commaIndex);
        }
        catch (RuntimeException e) {
            return null;
        }
        return IPath.fromOSString((String)path);
    }

    private static SourceExtensions processExtensions() {
        IExtension[] extensions;
        SourceExtensions result = new SourceExtensions();
        PDEExtensionRegistry extensionsRegistry = PDECore.getDefault().getExtensionsRegistry();
        IExtension[] iExtensionArray = extensions = extensionsRegistry.findExtensions("org.eclipse.pde.core.source", false);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] children = extension.getConfigurationElements();
            RegistryContributor contributor = (RegistryContributor)extension.getContributor();
            long bundleId = Long.parseLong(contributor.getActualId());
            BundleDescription desc = PDECore.getDefault().getModelManager().getState().getState().getBundle(Long.parseLong(contributor.getActualId()));
            IPluginModelBase base = null;
            if (desc != null) {
                base = PluginRegistry.findModel((Resource)desc);
            } else {
                IPluginModelBase[] externalModels;
                ModelEntry entry = PluginRegistry.findEntry(contributor.getActualName());
                IPluginModelBase[] iPluginModelBaseArray = externalModels = entry.getExternalModels();
                int n3 = externalModels.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPluginModelBase externalModel = iPluginModelBaseArray[n4];
                    BundleDescription extDesc = externalModel.getBundleDescription();
                    if (extDesc != null && extDesc.getBundleId() == bundleId) {
                        base = externalModel;
                    }
                    ++n4;
                }
            }
            if (base != null) {
                IConfigurationElement[] iConfigurationElementArray = children;
                int n5 = children.length;
                int externalModels = 0;
                while (externalModels < n5) {
                    IConfigurationElement element = iConfigurationElementArray[externalModels];
                    if (element.getName().equals("location")) {
                        String pathValue = element.getAttribute("path");
                        IPath path = IPath.fromOSString((String)base.getInstallLocation()).append(pathValue);
                        if (path.toFile().exists()) {
                            result.locations.add(path);
                        }
                    }
                    ++externalModels;
                }
            }
            ++n2;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.pde.core", "dynamicSource");
        IExtension[] iExtensionArray2 = point.getExtensions();
        int n6 = iExtensionArray2.length;
        int n7 = 0;
        while (n7 < n6) {
            IExtension extension = iExtensionArray2[n7];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n8 = iConfigurationElementArray.length;
            int n9 = 0;
            while (n9 < n8) {
                IConfigurationElement element = iConfigurationElementArray[n9];
                if (element.getName().equals("locator")) {
                    try {
                        IPluginSourcePathLocator locator = (IPluginSourcePathLocator)element.createExecutableExtension("class");
                        LocatorComplexity complexity = SourceLocationManager.getComplexity(element);
                        result.locators.add(new OrderedPluginSourcePathLocator(locator, complexity));
                    }
                    catch (CoreException e) {
                        PDECore.log(e.getStatus());
                    }
                }
                ++n9;
            }
            ++n7;
        }
        Collections.sort(result.locators);
        return result;
    }

    private static LocatorComplexity getComplexity(IConfigurationElement element) {
        try {
            return LocatorComplexity.valueOf(element.getAttribute("complexity"));
        }
        catch (RuntimeException e) {
            return LocatorComplexity.unkown;
        }
    }

    protected BundleManifestSourceLocationManager initializeBundleManifestLocations() {
        BundleManifestSourceLocationManager manager = new BundleManifestSourceLocationManager();
        manager.setPlugins(PDECore.getDefault().getModelManager().getExternalModels());
        try {
            TargetBundle[] bundles;
            ITargetDefinition definition = TargetPlatformService.getDefault().getWorkspaceTargetDefinition();
            if (definition != null && definition.isResolved() && (bundles = definition.getAllBundles()) != null) {
                manager.setTargetBundles(bundles);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return manager;
    }

    private static enum LocatorComplexity {
        low,
        medium,
        high,
        unkown;

    }

    private static final class OrderedPluginSourcePathLocator
    implements Comparable<OrderedPluginSourcePathLocator> {
        private final IPluginSourcePathLocator locator;
        private final LocatorComplexity complexity;

        OrderedPluginSourcePathLocator(IPluginSourcePathLocator locator, LocatorComplexity complexity) {
            this.locator = locator;
            this.complexity = complexity;
        }

        @Override
        public int compareTo(OrderedPluginSourcePathLocator o) {
            return this.complexity.compareTo(o.complexity);
        }
    }

    private static final class SourceExtensions {
        final Collection<IPath> locations = new LinkedHashSet<IPath>();
        final List<OrderedPluginSourcePathLocator> locators = new ArrayList<OrderedPluginSourcePathLocator>();

        private SourceExtensions() {
        }
    }
}

