/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import java.util.Objects;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IRepositoryInfo;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RepositoryInfo
extends ProductObject
implements IRepositoryInfo {
    private static final long serialVersionUID = 1L;
    public static final String P_LOCATION = "location";
    public static final String P_NAME = "name";
    public static final String P_ENABLED = "enabled";
    private String fURL;
    private String fName;
    private boolean fEnabled = true;

    public RepositoryInfo(IProductModel model) {
        super(model);
    }

    @Override
    public void setURL(String url) {
        String old = this.fURL;
        this.fURL = url;
        if (this.isEditable()) {
            this.firePropertyChanged(P_LOCATION, old, this.fURL);
        }
    }

    @Override
    public String getURL() {
        return this.fURL;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public void setName(String name) {
        String old = this.fName;
        this.fName = name;
        if (this.isEditable()) {
            this.firePropertyChanged(P_NAME, old, this.fName);
        }
    }

    @Override
    public boolean getEnabled() {
        return this.fEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean old = this.fEnabled;
        this.fEnabled = enabled;
        if (this.isEditable() && old != this.fEnabled) {
            this.firePropertyChanged(P_ENABLED, old, this.fEnabled);
        }
    }

    @Override
    public void parse(Node node) {
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            this.fURL = element.getAttribute(P_LOCATION);
            this.fName = element.getAttribute(P_NAME);
            this.fEnabled = Boolean.parseBoolean(element.getAttribute(P_ENABLED));
        }
    }

    @Override
    public void write(String indent, PrintWriter writer) {
        if (this.isURLDefined()) {
            writer.print(indent + "<repository location=\"" + this.fURL + "\"");
            if (this.fName != null) {
                writer.print(" name=\"" + this.fName + "\"");
            }
            writer.print(" enabled=\"" + this.fEnabled + "\"");
            writer.println(" />");
        }
    }

    private boolean isURLDefined() {
        return this.fURL != null && this.fURL.length() > 0;
    }

    public int hashCode() {
        return Objects.hash(this.fURL);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        void other;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RepositoryInfo)) {
            return false;
        }
        RepositoryInfo repositoryInfo = (RepositoryInfo)obj;
        return Objects.equals(this.fURL, other.fURL) && Objects.equals(this.fName, other.fName);
    }
}

