/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.history;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;

final class DefaultRefactoringDescriptorProxy
extends RefactoringDescriptorProxy {
    private final String fDescription;
    private final String fProject;
    private final long fTimeStamp;

    public DefaultRefactoringDescriptorProxy(String description, String project, long stamp) {
        Assert.isTrue((project == null || !"".equals(project) ? 1 : 0) != 0);
        Assert.isTrue((description != null && !"".equals(description) ? 1 : 0) != 0);
        this.fDescription = description.intern();
        this.fProject = project != null ? project.intern() : null;
        this.fTimeStamp = stamp;
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public String getProject() {
        return this.fProject;
    }

    @Override
    public long getTimeStamp() {
        return this.fTimeStamp;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(this.getClass().getName());
        buffer.append("[stamp=");
        buffer.append(this.fTimeStamp);
        buffer.append(",project=");
        buffer.append(this.fProject);
        buffer.append(",description=");
        buffer.append(this.fDescription);
        buffer.append("]");
        return buffer.toString();
    }
}

