/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableEditPolicyEx;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;

public class BorderItemSelectionEditPolicy
extends NonResizableEditPolicyEx {
    @Override
    public void eraseSourceFeedback(Request request) {
        if ("move".equals(request.getType()) && this.isDragAllowed() || "clone".equals(request.getType()) || "add children".equals(request.getType()) || "drop".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    @Override
    public void showSourceFeedback(Request request) {
        if ("move".equals(request.getType()) && this.isDragAllowed() || "add children".equals(request.getType()) || "clone".equals(request.getType()) || "drop".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    @Override
    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
        IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
        if (borderItemLocator != null) {
            IFigure feedback = this.getDragSourceFeedbackFigure();
            PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
            this.getHostFigure().translateToAbsolute((Translatable)rect);
            rect.translate(request.getMoveDelta());
            rect.resize(request.getSizeDelta());
            this.getHostFigure().translateToRelative((Translatable)rect);
            Rectangle realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemEP.getFigure());
            this.getHostFigure().translateToAbsolute((Translatable)realLocation);
            feedback.translateToRelative((Translatable)realLocation);
            feedback.setBounds(realLocation);
        }
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        IBorderItemEditPart borderItemEP = (IBorderItemEditPart)this.getHost();
        IBorderItemLocator borderItemLocator = borderItemEP.getBorderItemLocator();
        if (borderItemLocator != null) {
            PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
            this.getHostFigure().translateToAbsolute((Translatable)rect);
            rect.translate(request.getMoveDelta());
            rect.resize(request.getSizeDelta());
            this.getHostFigure().translateToRelative((Translatable)rect);
            Rectangle realLocation = borderItemLocator.getValidLocation(rect.getCopy(), borderItemEP.getFigure());
            Point parentOrigin = borderItemEP.getFigure().getParent().getBounds().getTopLeft();
            Dimension d = realLocation.getTopLeft().getDifference(parentOrigin);
            Point location = new Point(d.width, d.height);
            SetBoundsCommand moveCommand = new SetBoundsCommand(borderItemEP.getEditingDomain(), DiagramUIMessages.Commands_MoveElement, (IAdaptable)new EObjectAdapter((EObject)((View)this.getHost().getModel())), location);
            return new ICommandProxy((ICommand)moveCommand);
        }
        return null;
    }

    protected Command getAlignCommand(AlignmentRequest request) {
        return null;
    }
}

