/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.analyzer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.util.CDOFetchRule;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.analyzer.CDOFetchFeatureInfo;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public final class CDOAnalyzerFeatureInfo {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, CDOAnalyzerFeatureInfo.class);
    private final Map<CDOFetchFeatureInfo, CDOFetchFeatureInfo> featureStats = new HashMap<CDOFetchFeatureInfo, CDOFetchFeatureInfo>();
    private final Map<EClass, CDOFetchRule> fetchRules = new HashMap<EClass, CDOFetchRule>();

    public Collection<CDOFetchRule> getFetchRules(EClass eClass, EStructuralFeature feature) {
        return this.fetchRules.values();
    }

    public synchronized CDOFetchFeatureInfo getFeatureInfo(EClass eClass, EStructuralFeature feature) {
        CDOFetchFeatureInfo search = new CDOFetchFeatureInfo(eClass, feature);
        CDOFetchFeatureInfo featureRule = this.featureStats.get(search);
        if (featureRule != null) {
            return featureRule;
        }
        this.featureStats.put(search, search);
        return search;
    }

    public synchronized boolean isActive(EClass eClass, EStructuralFeature feature) {
        CDOFetchFeatureInfo search = new CDOFetchFeatureInfo(eClass, feature);
        CDOFetchFeatureInfo featureRule = this.featureStats.get(search);
        return featureRule != null && featureRule.isActive();
    }

    public synchronized void activate(EClass eClass, EStructuralFeature feature) {
        CDOFetchFeatureInfo info = this.getFeatureInfo(eClass, feature);
        if (!info.isActive()) {
            info.setActive(true);
            this.addFetchRule(eClass, feature);
        }
    }

    public synchronized void deactivate(EClass eClass, EStructuralFeature feature) {
        CDOFetchFeatureInfo info = this.getFeatureInfo(eClass, feature);
        if (info.isActive()) {
            info.setActive(false);
            this.removeFetchRule(eClass, feature);
        }
    }

    private void addFetchRule(EClass eClass, EStructuralFeature feature) {
        if (TRACER.isEnabled()) {
            TRACER.format("Adding fetch rule: {0}.{1}", new Object[]{eClass.getName(), feature.getName()});
        }
        this.fetchRules.computeIfAbsent(eClass, CDOFetchRule::new).addFeature(feature);
    }

    private void removeFetchRule(EClass eClass, EStructuralFeature feature) {
        CDOFetchRule fetchRule;
        if (TRACER.isEnabled()) {
            TRACER.format("Removing fetch rule: {0}.{1}", new Object[]{eClass.getName(), feature.getName()});
        }
        if ((fetchRule = this.fetchRules.get(eClass)) != null) {
            fetchRule.removeFeature(feature);
        }
    }
}

