/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.team.ui.templates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;

public class TemplateHandlerContentProposalProvider
implements IContentProposalProvider {
    public IContentProposal[] getProposals(String contents, int position) {
        ProposalComputer proposalComputer = new ProposalComputer(contents, position);
        return proposalComputer.computeProposals();
    }

    protected static class ProposalComputer {
        private final String contents;
        private final int position;
        private final List<IContentProposal> result = new ArrayList<IContentProposal>();
        private String[] keywords;
        private String prefix;

        public ProposalComputer(String contents, int position) {
            this.contents = contents;
            this.position = position;
            this.initKeywords();
            this.initPrefix();
        }

        public IContentProposal[] computeProposals() {
            String[] stringArray = this.keywords;
            int n = this.keywords.length;
            int n2 = 0;
            while (n2 < n) {
                String keyword = stringArray[n2];
                String proposal = this.getMatch(keyword);
                if (proposal != null) {
                    this.addProposal(proposal, keyword);
                }
                ++n2;
            }
            return this.result.toArray(new IContentProposal[this.result.size()]);
        }

        private void initKeywords() {
            this.keywords = FocusedTeamUiPlugin.getDefault().getCommitTemplateManager().getRecognizedKeywords();
        }

        private void initPrefix() {
            this.prefix = "";
            String beforePosition = this.contents.substring(0, this.position);
            if (beforePosition.endsWith("$")) {
                this.prefix = "$";
            } else {
                int end;
                int start = beforePosition.lastIndexOf("${");
                if (start >= 0 && (end = this.contents.indexOf(125, start)) >= this.position) {
                    this.prefix = this.contents.substring(start, this.position);
                }
            }
        }

        private String getMatch(String keyword) {
            String wholeProposal = "${" + keyword + "}";
            if (wholeProposal.startsWith(this.prefix)) {
                return wholeProposal.substring(this.prefix.length());
            }
            return null;
        }

        private void addProposal(String proposal, String keyword) {
            String description = FocusedTeamUiPlugin.getDefault().getCommitTemplateManager().getHandlerDescription(keyword);
            this.result.add(new Proposal(proposal, keyword, description));
        }

        private static final class Proposal
        implements IContentProposal {
            private final String proposal;
            private final String keyword;
            private final String description;

            private Proposal(String proposal, String keyword, String description) {
                this.proposal = proposal;
                this.keyword = keyword;
                this.description = description;
            }

            public String getContent() {
                return this.proposal;
            }

            public int getCursorPosition() {
                return this.proposal.length();
            }

            public String getDescription() {
                return this.description;
            }

            public String getLabel() {
                return "${" + this.keyword + "}";
            }
        }
    }
}

