/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.workingsets;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDEActionFactory;

public abstract class OpenCloseWorkingSetAction
extends SelectionDispatchAction
implements IResourceChangeListener {
    private OpenCloseWorkingSetAction(IWorkbenchSite site, String label) {
        super(site);
        this.setText(label);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public static OpenCloseWorkingSetAction createCloseAction(IWorkbenchSite site) {
        return new CloseWorkingSetAction(site, WorkingSetMessages.OpenCloseWorkingSetAction_close_label);
    }

    public static OpenCloseWorkingSetAction createOpenAction(IWorkbenchSite site) {
        return new OpenWorkingSetAction(site, WorkingSetMessages.OpenCloseWorkingSetAction_open_label);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        List projects = this.getProjects(selection);
        IActionBars actionBars = this.getActionBars();
        if (projects != null && projects.size() > 0) {
            this.setEnabled(true);
            if (actionBars != null) {
                this.connectToActionBar(actionBars);
            }
        } else {
            this.setEnabled(false);
            if (actionBars != null) {
                this.disconnectFromActionBar(actionBars);
            }
        }
    }

    @Override
    public void run(IStructuredSelection selection) {
        List projects = this.getProjects(selection);
        if (projects != null && projects.size() > 0) {
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)new WorkbenchRunnableAdapter(monitor -> {
                    monitor.beginTask("", projects.size());
                    for (IProject project : projects) {
                        this.performOperation(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    monitor.done();
                }));
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getShell(), this.getErrorTitle(), this.getErrorMessage());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected abstract boolean validate(IProject var1);

    protected abstract void performOperation(IProject var1, IProgressMonitor var2) throws CoreException;

    protected abstract void connectToActionBar(IActionBars var1);

    protected abstract void disconnectFromActionBar(IActionBars var1);

    protected abstract String getErrorTitle();

    protected abstract String getErrorMessage();

    private List getProjects(IStructuredSelection selection) {
        ArrayList result = new ArrayList();
        List elements = selection.toList();
        for (Object element : elements) {
            if (!(element instanceof IWorkingSet)) {
                return null;
            }
            List projects = this.getProjects((IWorkingSet)element);
            if (projects == null) {
                return null;
            }
            result.addAll(projects);
        }
        return result;
    }

    private List getProjects(IWorkingSet set) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IAdaptable[] elements = set.getElements();
        int i = 0;
        while (i < elements.length) {
            IAdaptable element = elements[i];
            IProject project = null;
            if (element instanceof IProject) {
                project = (IProject)element;
            } else if (element instanceof IScriptProject) {
                project = ((IScriptProject)element).getProject();
            }
            if (project != null && this.validate(project)) {
                result.add(project);
            }
            ++i;
        }
        return result;
    }

    protected IActionBars getActionBars() {
        if (this.getSite() instanceof IViewSite) {
            return ((IViewSite)this.getSite()).getActionBars();
        }
        return null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
            int i = 0;
            while (i < projDeltas.length) {
                IResourceDelta projDelta = projDeltas[i];
                if ((projDelta.getFlags() & 0x4000) != 0) {
                    Shell shell = this.getShell();
                    if (!shell.isDisposed()) {
                        shell.getDisplay().asyncExec(() -> this.update(this.getSelection()));
                    }
                    return;
                }
                ++i;
            }
        }
    }

    private static final class CloseWorkingSetAction
    extends OpenCloseWorkingSetAction {
        private IAction fProjectAction;

        private CloseWorkingSetAction(IWorkbenchSite site, String label) {
            super(site, label);
            IActionBars actionBars = this.getActionBars();
            if (actionBars != null) {
                this.fProjectAction = actionBars.getGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId());
            }
        }

        @Override
        protected boolean validate(IProject project) {
            return project.isOpen();
        }

        @Override
        protected void performOperation(IProject project, IProgressMonitor monitor) throws CoreException {
            project.close(monitor);
        }

        @Override
        protected void connectToActionBar(IActionBars actionBars) {
            actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this);
            actionBars.updateActionBars();
        }

        @Override
        protected void disconnectFromActionBar(IActionBars actionBars) {
            actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), this.fProjectAction);
            actionBars.updateActionBars();
        }

        @Override
        protected String getErrorTitle() {
            return WorkingSetMessages.OpenCloseWorkingSetAction_close_error_title;
        }

        @Override
        protected String getErrorMessage() {
            return WorkingSetMessages.OpenCloseWorkingSetAction_close_error_message;
        }
    }

    private static final class OpenWorkingSetAction
    extends OpenCloseWorkingSetAction {
        private IAction fProjectAction;

        private OpenWorkingSetAction(IWorkbenchSite site, String label) {
            super(site, label);
            IActionBars actionBars = this.getActionBars();
            if (actionBars != null) {
                this.fProjectAction = actionBars.getGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId());
            }
        }

        @Override
        protected boolean validate(IProject project) {
            return !project.isOpen();
        }

        @Override
        protected void performOperation(IProject project, IProgressMonitor monitor) throws CoreException {
            project.open(monitor);
        }

        @Override
        protected void connectToActionBar(IActionBars actionBars) {
            actionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this);
            actionBars.updateActionBars();
        }

        @Override
        protected void disconnectFromActionBar(IActionBars actionBars) {
            actionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), this.fProjectAction);
            actionBars.updateActionBars();
        }

        @Override
        protected String getErrorTitle() {
            return WorkingSetMessages.OpenCloseWorkingSetAction_open_error_title;
        }

        @Override
        protected String getErrorMessage() {
            return WorkingSetMessages.OpenCloseWorkingSetAction_open_error_message;
        }
    }
}

