/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.repositories.http.core;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;

public class IdleConnectionMonitorThread
extends Thread {
    private final List<ClientConnectionManager> connectionManagers;
    private long pollingInterval;
    private volatile boolean shutdown;
    private long timeout;

    public IdleConnectionMonitorThread(long pollingInterval) {
        this.pollingInterval = pollingInterval;
        this.connectionManagers = new CopyOnWriteArrayList<ClientConnectionManager>();
        this.setDaemon(true);
    }

    public void addConnectionManager(ClientConnectionManager manager) {
        this.connectionManagers.add(manager);
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void removeConnectionManager(ClientConnectionManager manager) {
        this.connectionManagers.remove(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.shutdown) {
                for (ClientConnectionManager connectionManager : this.connectionManagers) {
                    connectionManager.closeExpiredConnections();
                    if (this.timeout <= 0L) continue;
                    connectionManager.closeIdleConnections(this.timeout, TimeUnit.MILLISECONDS);
                }
                IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                synchronized (idleConnectionMonitorThread) {
                    this.wait(this.pollingInterval);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setPollingInterval(long pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        IdleConnectionMonitorThread idleConnectionMonitorThread = this;
        synchronized (idleConnectionMonitorThread) {
            this.notifyAll();
        }
    }
}

