/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.osgi.framework.BundleContext;

public class DTDCorePlugin
extends Plugin {
    private static DTDCorePlugin instance;
    static final String ORG_ECLIPSE_WST_XML_CORE = "org.eclipse.wst.xml.core";
    static final String CATALOG_CONTRIBUTIONS = "catalogContributions";
    private Map<String, String[]> fKnownURIs;
    private IRegistryChangeListener registryChangeListener;

    public static synchronized DTDCorePlugin getInstance() {
        return instance;
    }

    public static DTDCorePlugin getPlugin() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registryChangeListener = new RegistryChangeListener();
        Platform.getExtensionRegistry().addRegistryChangeListener(this.registryChangeListener, ORG_ECLIPSE_WST_XML_CORE);
    }

    public DTDCorePlugin() {
        instance = this;
    }

    public void resetKnownURIs() {
        this.fKnownURIs = null;
    }

    public Map<String, String[]> getKnownURIs() {
        if (this.fKnownURIs == null) {
            this.fKnownURIs = new HashMap<String, String[]>();
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint(XMLCorePlugin.getDefault().getBundle().getSymbolicName(), CATALOG_CONTRIBUTIONS);
            IConfigurationElement[] configurationElements = extension.getConfigurationElements();
            HashMap<String, List> known = new HashMap<String, List>();
            int i = 0;
            while (i < configurationElements.length) {
                String contributor2 = configurationElements[i].getNamespaceIdentifier();
                if (!known.containsKey(contributor2)) {
                    known.put(contributor2, new ArrayList());
                }
                IConfigurationElement[] elements = configurationElements[i].getChildren();
                int j = 0;
                while (j < elements.length) {
                    String uri = elements[j].getAttribute("uri");
                    if (uri != null && uri.length() > 0) {
                        ((List)known.get(contributor2)).add(uri);
                    }
                    ++j;
                }
                ++i;
            }
            known.forEach((contributor, uris) -> this.fKnownURIs.put((String)contributor, uris.toArray(new String[uris.size()])));
        }
        return this.fKnownURIs;
    }

    public void stop(BundleContext context) throws Exception {
        Platform.getExtensionRegistry().removeRegistryChangeListener(this.registryChangeListener);
        super.stop(context);
    }

    class RegistryChangeListener
    implements IRegistryChangeListener {
        RegistryChangeListener() {
        }

        public void registryChanged(IRegistryChangeEvent event) {
            if (event.getExtensionDeltas(DTDCorePlugin.ORG_ECLIPSE_WST_XML_CORE, DTDCorePlugin.CATALOG_CONTRIBUTIONS).length > 0) {
                DTDCorePlugin.this.resetKnownURIs();
            }
        }
    }
}

