/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.breakpoints;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.debug.core.model.IScriptBreakpoint;
import org.eclipse.dltk.debug.ui.DLTKDebugUILanguageManager;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.IDLTKDebugUILanguageToolkit;
import org.eclipse.dltk.debug.ui.IDLTKDebugUILanguageToolkit2;
import org.eclipse.dltk.debug.ui.breakpoints.BreakpointMessages;
import org.eclipse.dltk.debug.ui.breakpoints.BreakpointUtils;
import org.eclipse.dltk.debug.ui.breakpoints.IScriptBreakpointPropertyPageExtension;
import org.eclipse.dltk.internal.ui.editor.ScriptSourceViewer;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.dltk.ui.text.ScriptSourceViewerConfiguration;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class ScriptBreakpointPropertyPage
extends PropertyPage {
    private static final int UPDATE_INITIAL = 0;
    private static final int UPDATE_EXPRESSION_ENABLE = 1;
    private static final int UPDATE_OTHER = 2;
    private Button enabledBreakpointButton;
    private Button hitCountCheckingButton;
    private Combo hitConditionCombo;
    private Text hitValueText;
    private IScriptBreakpointPropertyPageExtension.IScriptBreakpointPropertyPageExtensionEditor extraEditor;
    private ScriptSourceViewer expressionViewer;
    private Button enableExpressionButton;

    protected boolean getBreakointEnableState() {
        return this.enabledBreakpointButton.getSelection();
    }

    protected boolean getEnabledHitChecking() {
        return this.hitCountCheckingButton.getSelection();
    }

    protected void setEnabledHitChecking(boolean state) {
        this.hitCountCheckingButton.setSelection(state);
    }

    protected void setHitCondition(int condition) {
        if (!this.hasOnlyGreaterOrEqualsHitCount()) {
            this.hitConditionCombo.select(condition);
        }
    }

    protected int getHitCondition() {
        if (!this.hasOnlyGreaterOrEqualsHitCount()) {
            return this.getEnabledHitChecking() ? this.hitConditionCombo.getSelectionIndex() : -1;
        }
        return 0;
    }

    protected void setHitValue(int value) {
        this.hitValueText.setText(Integer.toString(value));
    }

    protected int getHitValue() {
        return this.getEnabledHitChecking() ? Integer.parseInt(this.hitValueText.getText()) : -1;
    }

    protected void setExpression(String expression) {
        this.expressionViewer.getDocument().set(expression);
    }

    protected String getExpression() {
        return this.expressionViewer.getDocument().get();
    }

    protected void setExpressionState(boolean state) {
        this.enableExpressionButton.setSelection(state);
    }

    protected boolean getExpressionState() {
        return this.enableExpressionButton.getSelection();
    }

    protected void createLabels(Composite parent) throws CoreException {
        IScriptBreakpoint breakpoint = this.getBreakpoint();
        Composite labelComposite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)2, (int)1, (int)768);
        SWTFactory.createLabel((Composite)labelComposite, (String)BreakpointMessages.LanguageLabel, (int)1);
        SWTFactory.createLabel((Composite)labelComposite, (String)BreakpointUtils.getLanguageToolkit(breakpoint).getLanguageName(), (int)1);
        this.createLocationLabels(labelComposite);
        SWTFactory.createLabel((Composite)labelComposite, (String)BreakpointMessages.InternalIdLabel, (int)1);
        String[] engineIds = breakpoint.getIdentifiers();
        String engineIdText = engineIds == null || engineIds.length == 0 ? BreakpointMessages.InternalIdNotAvailableMessage : TextUtils.join((String[])engineIds, (char)',');
        SWTFactory.createLabel((Composite)labelComposite, (String)engineIdText, (int)1);
        if (this.hasHitCountAttribute()) {
            SWTFactory.createLabel((Composite)labelComposite, (String)BreakpointMessages.HitCountLabel, (int)1);
            int hitCount = breakpoint.getHitCount();
            String hitCountText = hitCount == -1 ? BreakpointMessages.HitCountNotAvailableMessage : Integer.toString(hitCount);
            SWTFactory.createLabel((Composite)labelComposite, (String)hitCountText, (int)1);
        }
        this.createTypeSpecificLabels(labelComposite);
    }

    protected void createLocationLabels(Composite parent) throws CoreException {
        String resourceName = this.getBreakpointResourceName();
        if (resourceName != null && resourceName.length() > 0) {
            SWTFactory.createLabel((Composite)parent, (String)this.getBreakpointLocationLabel(), (int)1);
            SWTFactory.createLabel((Composite)parent, (String)resourceName, (int)1);
        }
    }

    protected String getBreakpointLocationLabel() {
        return BreakpointMessages.FileLabel;
    }

    protected String getBreakpointResourceName() throws CoreException {
        return this.getBreakpoint().getResourceName();
    }

    protected void createTypeSpecificLabels(Composite parent) throws CoreException {
    }

    protected void createButtons(Composite parent) throws CoreException {
        Composite buttonsComposite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)768);
        this.enabledBreakpointButton = SWTFactory.createCheckButton((Composite)buttonsComposite, (String)BreakpointMessages.EnabledLabel, null, (boolean)false, (int)1);
        this.createTypeSpecificButtons(buttonsComposite);
    }

    protected void createTypeSpecificButtons(Composite parent) {
    }

    protected void createHitCountEditor(Composite parent) {
        Composite hitCountComposite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)4, (int)1, (int)768);
        this.hitCountCheckingButton = SWTFactory.createCheckButton((Composite)hitCountComposite, (String)BreakpointMessages.BreakWhenHitCountLabel, null, (boolean)false, (int)1);
        this.hitCountCheckingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptBreakpointPropertyPage.this.updateControlsState(2);
            }
        });
        if (!this.hasOnlyGreaterOrEqualsHitCount()) {
            this.hitConditionCombo = new Combo(hitCountComposite, 8);
            this.hitConditionCombo.add(BreakpointMessages.HitConditionGreaterOrEqual, 0);
            this.hitConditionCombo.add(BreakpointMessages.HitConditionEqual, 1);
            this.hitConditionCombo.add(BreakpointMessages.HitConditionMultiple, 2);
            this.hitConditionCombo.select(0);
            this.hitConditionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ScriptBreakpointPropertyPage.this.updateControlsState(2);
                }
            });
            this.hitConditionCombo.setData((Object)new GridData());
        }
        this.hitValueText = new Text(hitCountComposite, 2048);
        this.hitValueText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hitValueText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ScriptBreakpointPropertyPage.this.updateControlsState(2);
            }
        });
        SWTFactory.createLabel((Composite)hitCountComposite, (String)BreakpointMessages.HitsLabel, (int)1);
    }

    protected void createExpressionEditor(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.enableExpressionButton = new Button((Composite)group, 32);
        this.enableExpressionButton.setText(BreakpointMessages.UseConditionLabel);
        this.enableExpressionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScriptBreakpointPropertyPage.this.updateControlsState(1);
            }
        });
        IDLTKUILanguageToolkit toolkit = BreakpointUtils.getUILanguageToolkit(this.getBreakpoint());
        this.expressionViewer = new ScriptSourceViewer((Composite)group, null, null, false, 2816, toolkit.getPreferenceStore());
        Document document = new Document();
        toolkit.getTextTools().setupDocumentPartitioner((IDocument)document, toolkit.getPartitioningId());
        ScriptSourceViewerConfiguration config = toolkit.createSourceViewerConfiguration();
        this.expressionViewer.configure((SourceViewerConfiguration)config);
        this.expressionViewer.setDocument((IDocument)document);
        this.expressionViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected IScriptBreakpoint getBreakpoint() {
        return (IScriptBreakpoint)this.getElement();
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
        try {
            IScriptBreakpointPropertyPageExtension extension;
            this.createLabels(composite);
            this.createButtons(composite);
            if (this.hasHitCountEditor()) {
                this.createHitCountEditor(composite);
            }
            if (this.hasExpressionEditor()) {
                this.createExpressionEditor(composite);
            }
            if ((extension = this.getBreakpointPropertyPageExtension()) != null) {
                this.extraEditor = extension.createExtraPropertyEditor(this.getBreakpoint());
            }
            this.loadValues();
            this.updateControlsState(0);
        }
        catch (CoreException e) {
            DLTKDebugUIPlugin.log(e);
        }
        return composite;
    }

    protected IScriptBreakpointPropertyPageExtension getBreakpointPropertyPageExtension() {
        IDLTKDebugUILanguageToolkit debugUILanguageToolkit;
        IProject project;
        IScriptProject scriptProject;
        IDLTKLanguageToolkit toolkit;
        IScriptBreakpoint breakpoint = this.getBreakpoint();
        IMarker marker = breakpoint.getMarker();
        if (marker != null && (toolkit = (scriptProject = DLTKCore.create((IProject)(project = marker.getResource().getProject()))).getLanguageToolkit()) != null && (debugUILanguageToolkit = DLTKDebugUILanguageManager.getLanguageToolkit(toolkit.getNatureId())) != null && debugUILanguageToolkit instanceof IDLTKDebugUILanguageToolkit2) {
            return ((IDLTKDebugUILanguageToolkit2)((Object)debugUILanguageToolkit)).getBreakpointPropertyPageExtension();
        }
        return null;
    }

    protected boolean hasHitCountAttribute() {
        return true;
    }

    protected boolean hasHitCountEditor() {
        IScriptBreakpointPropertyPageExtension extension = this.getBreakpointPropertyPageExtension();
        if (extension != null) {
            return extension.hasHitCountEditor(this.getBreakpoint());
        }
        return true;
    }

    protected boolean hasOnlyGreaterOrEqualsHitCount() {
        IScriptBreakpointPropertyPageExtension extension = this.getBreakpointPropertyPageExtension();
        if (extension != null) {
            return extension.hasOnlyGreaterOrEqualsHitCount(this.getBreakpoint());
        }
        return false;
    }

    protected boolean hasExpressionEditor() {
        IScriptBreakpointPropertyPageExtension extension = this.getBreakpointPropertyPageExtension();
        if (extension != null) {
            return extension.hasExpressionEditor(this.getBreakpoint());
        }
        return true;
    }

    protected void loadValues() throws CoreException {
        IScriptBreakpoint breakpoint = this.getBreakpoint();
        this.enabledBreakpointButton.setSelection(breakpoint.isEnabled());
        if (this.hasHitCountEditor()) {
            int hitValue = breakpoint.getHitValue();
            if (hitValue != -1) {
                this.setHitValue(hitValue);
                this.setHitCondition(breakpoint.getHitCondition());
                this.setEnabledHitChecking(true);
            } else {
                this.setEnabledHitChecking(false);
            }
        }
        if (this.hasExpressionEditor()) {
            this.setExpressionState(breakpoint.getExpressionState());
            this.setExpression(breakpoint.getExpression());
        }
        if (this.extraEditor != null) {
            this.extraEditor.loadContents(breakpoint);
        }
    }

    protected void saveValues() throws CoreException {
        IScriptBreakpoint breakpoint = this.getBreakpoint();
        breakpoint.setEnabled(this.getBreakointEnableState());
        if (this.hasHitCountEditor()) {
            breakpoint.setHitValue(this.getHitValue());
            breakpoint.setHitCondition(this.getHitCondition());
        }
        if (this.hasExpressionEditor()) {
            breakpoint.setExpression(this.getExpression());
            breakpoint.setExpressionState(this.getExpressionState());
        }
        if (this.extraEditor != null) {
            this.extraEditor.saveContents(breakpoint);
        }
    }

    protected void updateControlsState(int mode) {
        if (this.hasHitCountEditor()) {
            boolean hitChecking = this.hitCountCheckingButton.getSelection();
            if (!this.hasOnlyGreaterOrEqualsHitCount()) {
                this.hitConditionCombo.setEnabled(hitChecking);
            }
            this.hitValueText.setEnabled(hitChecking);
        }
        if (this.hasExpressionEditor()) {
            boolean expressionEnabled = this.enableExpressionButton.getSelection();
            Control control = this.expressionViewer.getControl();
            control.setEnabled(expressionEnabled);
            if (expressionEnabled) {
                this.expressionViewer.initializeViewerColors();
                if (mode == 1) {
                    this.expressionViewer.getTextWidget().setFocus();
                }
            } else {
                Color color = this.expressionViewer.getControl().getDisplay().getSystemColor(22);
                this.expressionViewer.getTextWidget().setBackground(color);
            }
        }
        this.validateValues();
    }

    protected void validateValues() {
        boolean valid = true;
        String errorMessage = null;
        if (this.hasHitCountEditor() && this.getEnabledHitChecking()) {
            try {
                this.getHitValue();
            }
            catch (NumberFormatException e) {
                valid = false;
                errorMessage = BreakpointMessages.InvalidNumberOfHits;
            }
        }
        this.setValid(valid);
        this.setErrorMessage(errorMessage);
    }

    public boolean performOk() {
        try {
            ResourcesPlugin.getWorkspace().run(monitor -> {
                this.saveValues();
                DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged((IBreakpoint)this.getBreakpoint());
            }, null, 0, null);
        }
        catch (CoreException e) {
            DebugPlugin.log((Throwable)e);
        }
        return super.performOk();
    }
}

