/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models.advisors;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.recommenders.models.Coordinates;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.DependencyType;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.advisors.AbstractProjectCoordinateAdvisor;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Versions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class MavenPomXmlAdvisor
extends AbstractProjectCoordinateAdvisor {
    private Logger log = LoggerFactory.getLogger(MavenPomXmlAdvisor.class);

    @Override
    protected Optional<ProjectCoordinate> doSuggest(DependencyInfo dependencyInfo) {
        try {
            File pomfile = new File(dependencyInfo.getFile(), "pom.xml");
            if (!pomfile.exists()) {
                return Optional.absent();
            }
            Document model = this.readModelFromFile(pomfile);
            return this.extractProjectCoordinateFromModel(model);
        }
        catch (Exception e) {
            this.log.error("Could not read pom.xml file of dependency :" + dependencyInfo, (Throwable)e);
            return Optional.absent();
        }
    }

    private Document readModelFromFile(File pomfile) throws IOException, ParserConfigurationException, SAXException {
        Document document;
        FileInputStream pomInputStream = null;
        try {
            pomInputStream = new FileInputStream(pomfile);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBldr = docBuilderFactory.newDocumentBuilder();
            document = docBldr.parse(pomInputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pomInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)pomInputStream);
        return document;
    }

    private Optional<ProjectCoordinate> extractProjectCoordinateFromModel(Document model) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        String groupId = factory.newXPath().evaluate("/project/groupId/text()", model);
        String artifactId = factory.newXPath().evaluate("/project/artifactId/text()", model);
        String version = factory.newXPath().evaluate("/project/version/text()", model);
        if (Strings.isNullOrEmpty((String)groupId)) {
            groupId = factory.newXPath().evaluate("/project/parent/groupId/text()", model);
        }
        if (Strings.isNullOrEmpty((String)version)) {
            version = factory.newXPath().evaluate("/project/parent/version/text()", model);
        }
        if (Strings.isNullOrEmpty((String)groupId) || Strings.isNullOrEmpty((String)artifactId) || Strings.isNullOrEmpty((String)version)) {
            return Optional.absent();
        }
        if (this.containsPropertyReference(groupId) || this.containsPropertyReference(artifactId) || this.containsPropertyReference(version)) {
            return Optional.absent();
        }
        int indexOf = version.indexOf(45);
        version = version.substring(0, indexOf == -1 ? version.length() : indexOf);
        return Coordinates.tryNewProjectCoordinate(groupId, artifactId, Versions.canonicalizeVersion((String)version));
    }

    private boolean containsPropertyReference(String string) {
        return string.contains("$");
    }

    @Override
    public boolean isApplicable(DependencyType type) {
        return DependencyType.PROJECT == type;
    }
}

