/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.calls.rcp;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.recommenders.apidocs.rcp.ApidocProvider;
import org.eclipse.recommenders.apidocs.rcp.JavaSelectionSubscriber;
import org.eclipse.recommenders.calls.ICallModel;
import org.eclipse.recommenders.calls.ICallModelProvider;
import org.eclipse.recommenders.internal.apidocs.rcp.ApidocsViewUtils;
import org.eclipse.recommenders.internal.calls.rcp.AstDefUseFinder;
import org.eclipse.recommenders.internal.calls.rcp.Messages;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.rcp.JavaElementSelectionEvent;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Recommendations;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.Names;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

@Beta
public final class CallsApidocProvider
extends ApidocProvider {
    private final ICallModelProvider modelProvider;
    private final IProjectCoordinateProvider pcProvider;
    private final JavaElementResolver jdtResolver;
    private final EventBus workspaceBus;
    private IType receiverType;
    private ICallModel model;
    private UniqueTypeName baseName;

    @Inject
    public CallsApidocProvider(ICallModelProvider modelProvider, IProjectCoordinateProvider pcProvider, JavaElementResolver jdtResolver, EventBus workspaceBus) {
        this.modelProvider = modelProvider;
        this.pcProvider = pcProvider;
        this.jdtResolver = jdtResolver;
        this.workspaceBus = workspaceBus;
    }

    @JavaSelectionSubscriber
    public void onVariableSelection(ILocalVariable var, JavaElementSelectionEvent event, Composite parent) {
        this.handle((IJavaElement)var, var.getElementName(), var.getTypeSignature(), event, parent);
    }

    @JavaSelectionSubscriber(value={JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_BODY})
    public void onFieldSelection(IField var, JavaElementSelectionEvent event, Composite parent) throws JavaModelException {
        this.handle((IJavaElement)var, var.getElementName(), var.getTypeSignature(), event, parent);
    }

    private void handle(IJavaElement variable, String elementName, String typeSignature, JavaElementSelectionEvent event, Composite parent) {
        Optional opt = event.getSelectedNode();
        if (!opt.isPresent()) {
            return;
        }
        Optional<IType> varType = this.findVariableType(typeSignature, variable);
        if (!varType.isPresent()) {
            return;
        }
        this.receiverType = (IType)varType.get();
        this.baseName = (UniqueTypeName)this.pcProvider.toUniqueName(this.receiverType).orNull();
        if (this.baseName == null || !this.acquireModel()) {
            return;
        }
        try {
            ASTNode node = (ASTNode)opt.get();
            Optional<MethodDeclaration> optAstMethod = this.findEnclosingMethod(node);
            Optional optJdtMethod = JdtUtils.resolveMethod((MethodDeclaration)((MethodDeclaration)optAstMethod.orNull()));
            if (!optJdtMethod.isPresent()) {
                return;
            }
            AstDefUseFinder defUse = new AstDefUseFinder(variable.getElementName(), (MethodDeclaration)optAstMethod.orNull());
            IMethod findFirstDeclaration = JdtUtils.findFirstDeclaration((IMethod)((IMethod)optJdtMethod.get()));
            IMethodName overrideContext = (IMethodName)this.jdtResolver.toRecMethod(findFirstDeclaration).or((Object)VmMethodName.NULL);
            HashSet calls = Sets.newHashSet(defUse.getCalls());
            IMethodName definingMethod = (IMethodName)defUse.getDefiningMethod().orNull();
            ICallModel.DefinitionKind kind = defUse.getDefinitionKind();
            if (ICallModel.DefinitionKind.PARAM == kind) {
                definingMethod = overrideContext;
            }
            if (kind == ICallModel.DefinitionKind.UNKNOWN) {
                kind = definingMethod == null ? ICallModel.DefinitionKind.FIELD : (definingMethod.isInit() ? ICallModel.DefinitionKind.NEW : ICallModel.DefinitionKind.RETURN);
            }
            this.model.setObservedOverrideContext(overrideContext);
            this.model.setObservedDefiningMethod(definingMethod);
            this.model.setObservedCalls((Set)calls);
            this.model.setObservedDefinitionKind(kind);
            List methodCalls = Recommendations.sortByRelevance((Iterable)Recommendations.filterRelevance((Iterable)this.model.recommendCalls(), (double)1.0E-4));
            this.runSyncInUiThread(new CallRecommendationsRenderer(overrideContext, methodCalls, calls, variable.getElementName(), definingMethod, kind, parent));
        }
        finally {
            this.releaseModel();
        }
    }

    private Optional<IType> findVariableType(String typeSignature, IJavaElement parent) {
        return JdtUtils.findTypeFromSignature((String)typeSignature, (IJavaElement)parent);
    }

    private Optional<MethodDeclaration> findEnclosingMethod(ASTNode node) {
        MethodDeclaration declaringNode = null;
        ASTNode p = node;
        while (p != null) {
            if (p instanceof MethodDeclaration) {
                declaringNode = (MethodDeclaration)p;
                break;
            }
            p = p.getParent();
        }
        return Optional.fromNullable(declaringNode);
    }

    private boolean acquireModel() {
        this.model = (ICallModel)this.modelProvider.acquireModel((IUniqueName)this.baseName).orNull();
        return this.model != null;
    }

    private void releaseModel() {
        if (this.model != null) {
            this.modelProvider.releaseModel((Object)this.model);
            this.model = null;
        }
    }

    private class CallRecommendationsRenderer
    implements Runnable {
        private final IMethodName ctx;
        private final Iterable<Recommendation<IMethodName>> methodCalls;
        private final Set<IMethodName> calls;
        private final String varName;
        private final IMethodName def;
        private final ICallModel.DefinitionKind kind;
        private final Composite parent;

        private CallRecommendationsRenderer(IMethodName ctx, Iterable<Recommendation<IMethodName>> methodCalls, Set<IMethodName> calls, String varName, IMethodName def, ICallModel.DefinitionKind kind, Composite parent) {
            this.ctx = ctx;
            this.methodCalls = methodCalls;
            this.calls = calls;
            this.varName = varName;
            this.def = def;
            this.kind = kind;
            this.parent = parent;
        }

        @Override
        public void run() {
            Composite container = ApidocsViewUtils.createComposite((Composite)this.parent, (int)4);
            Label preamble2 = new Label(container, 0);
            ApidocsViewUtils.setInfoForegroundColor((Control)preamble2);
            ApidocsViewUtils.setInfoBackgroundColor((Control)preamble2);
            preamble2.setLayoutData((Object)GridDataFactory.swtDefaults().span(4, 1).indent(0, 0).create());
            if (Iterables.isEmpty(this.methodCalls)) {
                preamble2.setText(MessageFormat.format(Messages.PROVIDER_INTRO_NO_RECOMMENDATIONS, CallsApidocProvider.this.receiverType.getElementName(), this.varName));
            } else {
                preamble2.setText(MessageFormat.format(Messages.PROVIDER_INTRO_RECOMMENDATIONS, CallsApidocProvider.this.receiverType.getElementName(), this.varName));
            }
            new Label(container, 0).setLayoutData((Object)GridDataFactory.swtDefaults().span(4, 1).indent(0, 0).hint(-1, 1).create());
            for (Recommendation<IMethodName> rec : this.methodCalls) {
                ApidocsViewUtils.createLabel((Composite)container, (String)ApidocsViewUtils.percentageToRecommendationPhrase((int)Recommendations.asPercentage(rec)), (boolean)true, (boolean)false, (int)28, (boolean)false);
                ApidocsViewUtils.createLabel((Composite)container, (String)(String.valueOf(Messages.TABLE_CELL_RELATION_CALL) + " "), (boolean)false);
                ApidocsViewUtils.createMethodLink((Composite)container, (IMethodName)((IMethodName)rec.getProposal()), (JavaElementResolver)CallsApidocProvider.this.jdtResolver, (EventBus)CallsApidocProvider.this.workspaceBus);
                double relevance = rec.getRelevance();
                String format = relevance < 0.01 ? Messages.TABLE_CELL_SUFFIX_PROMILLE : Messages.TABLE_CELL_SUFFIX_PERCENTAGE;
                ApidocsViewUtils.createLabel((Composite)container, (String)(" - " + MessageFormat.format(format, relevance)), (boolean)false);
            }
            new Label(container, 258);
            ApidocsViewUtils.createLabel((Composite)container, (String)"", (boolean)false);
            ApidocsViewUtils.createLabel((Composite)container, (String)"", (boolean)false);
            ApidocsViewUtils.createLabel((Composite)container, (String)"", (boolean)false);
            Label preamble = new Label(container, 0);
            preamble.setLayoutData((Object)GridDataFactory.swtDefaults().span(4, 1).indent(0, 5).create());
            ApidocsViewUtils.setInfoForegroundColor((Control)preamble);
            ApidocsViewUtils.setInfoBackgroundColor((Control)preamble);
            String text = this.ctx == VmMethodName.NULL ? MessageFormat.format(Messages.PROVIDER_INFO_UNTRAINED_CONTEXT, CallsApidocProvider.this.receiverType.getElementName()) : MessageFormat.format(Messages.PROVIDER_INFO_LOCAL_VAR_CONTEXT, CallsApidocProvider.this.receiverType.getElementName(), String.valueOf(Names.vm2srcSimpleTypeName((ITypeName)this.ctx.getDeclaringType())) + "." + Names.vm2srcSimpleMethod((IMethodName)this.ctx));
            preamble.setText(text);
            new Label(container, 0).setLayoutData((Object)GridDataFactory.swtDefaults().span(4, 1).indent(0, 5).hint(-1, 1).create());
            if (this.def != null) {
                ApidocsViewUtils.createLabel((Composite)container, (String)Messages.TABLE_CELL_RELATION_DEFINED_BY, (boolean)true, (boolean)false, (int)16, (boolean)false);
                ApidocsViewUtils.createLabel((Composite)container, (String)"", (boolean)false, (boolean)false, (int)16, (boolean)false);
                if (this.def == VmMethodName.NULL) {
                    ApidocsViewUtils.createLabel((Composite)container, (String)Messages.TABLE_CELL_DEFINITION_UNTRAINED, (boolean)false, (boolean)false, (int)16, (boolean)false);
                } else {
                    ApidocsViewUtils.createMethodLink((Composite)container, (IMethodName)this.def, (JavaElementResolver)CallsApidocProvider.this.jdtResolver, (EventBus)CallsApidocProvider.this.workspaceBus);
                }
                ApidocsViewUtils.createLabel((Composite)container, (String)("- " + this.kind.toString().toLowerCase()), (boolean)true, (boolean)false, (int)16, (boolean)false);
            }
            for (IMethodName observedCall : this.calls) {
                ApidocsViewUtils.createLabel((Composite)container, (String)Messages.TABLE_CELL_RELATION_OBSERVED, (boolean)true, (boolean)false, (int)16, (boolean)false);
                ApidocsViewUtils.createLabel((Composite)container, (String)(String.valueOf(Messages.TABLE_CELL_RELATION_CALL) + " "), (boolean)false, (boolean)false, (int)16, (boolean)false);
                ApidocsViewUtils.createMethodLink((Composite)container, (IMethodName)observedCall, (JavaElementResolver)CallsApidocProvider.this.jdtResolver, (EventBus)CallsApidocProvider.this.workspaceBus);
                ApidocsViewUtils.createLabel((Composite)container, (String)"", (boolean)true, (boolean)false, (int)16, (boolean)false);
            }
        }
    }
}

