/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.calls.rcp.templates;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.commons.lang3.CharUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedNameReference;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.recommenders.calls.ICallModel;
import org.eclipse.recommenders.calls.ICallModelProvider;
import org.eclipse.recommenders.completion.rcp.CompletionContextKey;
import org.eclipse.recommenders.completion.rcp.DisableContentAssistCategoryJob;
import org.eclipse.recommenders.completion.rcp.ICompletionContextFunction;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.RecommendersCompletionContext;
import org.eclipse.recommenders.internal.calls.rcp.CallCompletionContextFunctions;
import org.eclipse.recommenders.internal.calls.rcp.templates.PatternRecommendation;
import org.eclipse.recommenders.internal.calls.rcp.templates.ProposalBuilder;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.ProjectCoordinate;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.rcp.IAstProvider;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.utils.Constants;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Recommendations;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplatesCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final IProjectCoordinateProvider pcProvider;
    private final ICallModelProvider store;
    private final IAstProvider astProvider;
    private final JavaElementResolver elementResolver;
    private final Map<CompletionContextKey, ICompletionContextFunction> functions;
    private IRecommendersCompletionContext rCtx;
    private IMethod enclosingMethod;
    private Set<IType> candidates;
    private String variableName;
    private boolean requiresConstructor;
    private String methodPrefix;
    private CompletionMode mode;
    private Image icon;
    private ICallModel model;

    @Inject
    public TemplatesCompletionProposalComputer(IProjectCoordinateProvider pcProvider, ICallModelProvider store, IAstProvider astProvider, JavaElementResolver elementResolver, Map<CompletionContextKey, ICompletionContextFunction> functions) {
        this.pcProvider = pcProvider;
        this.store = store;
        this.astProvider = astProvider;
        this.elementResolver = elementResolver;
        this.functions = functions;
        this.loadImage();
    }

    private void loadImage() {
        Bundle bundle = FrameworkUtil.getBundle(TemplatesCompletionProposalComputer.class);
        this.icon = null;
        if (bundle != null) {
            ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)bundle.getSymbolicName(), (String)"icons/view16/templates-dots.gif");
            this.icon = desc.createImage();
        }
    }

    @VisibleForTesting
    public CompletionMode getCompletionMode() {
        return this.mode;
    }

    @VisibleForTesting
    public String getVariableName() {
        return this.variableName;
    }

    @VisibleForTesting
    public String getMethodPrefix() {
        return this.methodPrefix;
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!this.shouldMakeProposals()) {
            return Collections.EMPTY_LIST;
        }
        this.rCtx = new RecommendersCompletionContext((JavaContentAssistInvocationContext)context, this.astProvider, this.functions);
        if (!this.findEnclosingMethod()) {
            return Collections.emptyList();
        }
        if (!this.findCompletionMode()) {
            return Collections.emptyList();
        }
        if (!this.findPotentialTypes()) {
            return Collections.emptyList();
        }
        ProposalBuilder proposalBuilder = new ProposalBuilder(this.icon, this.rCtx, this.elementResolver, this.variableName);
        for (IType t : this.candidates) {
            this.addPatternsForType(t, proposalBuilder);
        }
        return proposalBuilder.createProposals();
    }

    @VisibleForTesting
    protected boolean shouldMakeProposals() {
        Object[] excluded = PreferenceConstants.getExcludedCompletionProposalCategories();
        HashSet ex = Sets.newHashSet((Object[])excluded);
        if (!ex.contains("org.eclipse.recommenders.calls.rcp.proposalCategory.templates")) {
            new DisableContentAssistCategoryJob("org.eclipse.recommenders.calls.rcp.proposalCategory.templates").schedule();
            return false;
        }
        return true;
    }

    private void addPatternsForType(IType t, ProposalBuilder proposalBuilder) {
        ProjectCoordinate pc = (ProjectCoordinate)this.pcProvider.resolve(t).or((Object)ProjectCoordinate.UNKNOWN);
        UniqueTypeName name = new UniqueTypeName(pc, this.elementResolver.toRecType(t));
        this.model = (ICallModel)this.store.acquireModel((IUniqueName)name).orNull();
        try {
            if (this.model == null) {
                return;
            }
            this.model.setObservedCalls((Set)Sets.newHashSet());
            if (this.mode == CompletionMode.TYPE_NAME) {
                this.handleTypeNameCompletionRequest(proposalBuilder);
            } else {
                this.handleVariableCompletionRequest(proposalBuilder);
            }
        }
        finally {
            this.store.releaseModel((Object)this.model);
        }
    }

    private void handleVariableCompletionRequest(ProposalBuilder proposalBuilder) {
        IMethod overrides = (IMethod)this.rCtx.get(CompletionContextKey.ENCLOSING_METHOD_FIRST_DECLARATION, null);
        if (overrides != null) {
            IMethodName crOverrides = (IMethodName)this.elementResolver.toRecMethod(overrides).or((Object)Constants.UNKNOWN_METHOD);
            this.model.setObservedOverrideContext(crOverrides);
        }
        this.model.setObservedDefinitionKind((ICallModel.DefinitionKind)this.rCtx.get(CallCompletionContextFunctions.RECEIVER_DEF_TYPE, null));
        this.model.setObservedDefiningMethod((IMethodName)this.rCtx.get(CallCompletionContextFunctions.RECEIVER_DEF_BY, null));
        this.model.setObservedCalls((Set)Sets.newHashSet((Iterable)((Iterable)this.rCtx.get(CallCompletionContextFunctions.RECEIVER_CALLS, Collections.emptyList()))));
        List<Recommendation<String>> callgroups = this.getMostLikelyPatternsSortedByProbability(this.model);
        for (Recommendation<String> p : callgroups) {
            String patternId = (String)p.getProposal();
            this.model.setObservedPattern(patternId);
            TreeSet calls = Sets.newTreeSet();
            for (Recommendation r : Recommendations.top((Iterable)this.model.recommendCalls(), (int)100, (double)0.1)) {
                calls.add((IMethodName)r.getProposal());
            }
            if (calls.size() < 2) continue;
            PatternRecommendation pattern = new PatternRecommendation(patternId, this.model.getReceiverType(), (ImmutableSet<IMethodName>)ImmutableSet.copyOf((Collection)calls), p.getRelevance());
            proposalBuilder.addPattern(pattern);
        }
    }

    private void handleTypeNameCompletionRequest(ProposalBuilder proposalBuilder) {
        IMethod overrides = (IMethod)this.rCtx.get(CompletionContextKey.ENCLOSING_METHOD_FIRST_DECLARATION, null);
        this.model.setObservedDefinitionKind(ICallModel.DefinitionKind.NEW);
        if (overrides != null) {
            IMethodName crOverrides = (IMethodName)this.elementResolver.toRecMethod(overrides).or((Object)Constants.UNKNOWN_METHOD);
            this.model.setObservedOverrideContext(crOverrides);
        }
        List<Recommendation<String>> callgroups = this.getMostLikelyPatternsSortedByProbability(this.model);
        for (Recommendation<String> p : callgroups) {
            String patternId = (String)p.getProposal();
            this.model.setObservedPattern(patternId);
            for (Recommendation def : Recommendations.top((Iterable)this.model.recommendDefinitions(), (int)100, (double)0.01)) {
                IMethodName constructor = (IMethodName)def.getProposal();
                if (!constructor.isInit() || constructor.getDeclaringType() != this.model.getReceiverType()) continue;
                Collection<IMethodName> calls = this.getCallsForDefinition(this.model, constructor);
                calls.add(constructor);
                if (calls.size() < 2) continue;
                PatternRecommendation pattern = new PatternRecommendation(patternId, this.model.getReceiverType(), (ImmutableSet<IMethodName>)ImmutableSet.copyOf(calls), p.getRelevance());
                proposalBuilder.addPattern(pattern);
            }
        }
    }

    private Collection<IMethodName> getCallsForDefinition(ICallModel model, IMethodName definition) {
        boolean constructorAdded = false;
        TreeSet calls = Sets.newTreeSet();
        List rec = Recommendations.top((Iterable)model.recommendCalls(), (int)100, (double)0.1);
        if (rec.isEmpty()) {
            return Lists.newLinkedList();
        }
        if (this.requiresConstructor && definition.isInit()) {
            calls.add(definition);
            constructorAdded = true;
        }
        if (this.requiresConstructor && !constructorAdded) {
            return Lists.newLinkedList();
        }
        for (Recommendation pair : rec) {
            calls.add((IMethodName)pair.getProposal());
        }
        if (!this.containsCallWithMethodPrefix(calls)) {
            return Lists.newLinkedList();
        }
        return calls;
    }

    private boolean containsCallWithMethodPrefix(TreeSet<IMethodName> calls) {
        for (IMethodName call : calls) {
            if (!call.getName().startsWith(this.methodPrefix)) continue;
            return true;
        }
        return false;
    }

    private List<Recommendation<String>> getMostLikelyPatternsSortedByProbability(ICallModel net) {
        return Recommendations.top((Iterable)net.recommendPatterns(), (int)10, (double)0.03);
    }

    private boolean findCompletionMode() {
        this.variableName = "";
        this.methodPrefix = "";
        this.mode = null;
        ASTNode n = (ASTNode)this.rCtx.getCompletionNode().orNull();
        if (n instanceof CompletionOnSingleNameReference) {
            if (this.isPotentialClassName((CompletionOnSingleNameReference)n)) {
                this.mode = CompletionMode.TYPE_NAME;
            } else {
                this.mode = CompletionMode.THIS;
                this.methodPrefix = this.rCtx.getReceiverName();
            }
        } else if (n instanceof CompletionOnQualifiedNameReference) {
            if (this.isPotentialClassName((CompletionOnQualifiedNameReference)n)) {
                this.mode = CompletionMode.TYPE_NAME;
            } else {
                this.mode = CompletionMode.MEMBER_ACCESS;
                this.variableName = this.rCtx.getReceiverName();
                this.methodPrefix = this.rCtx.getPrefix();
            }
        } else if (n instanceof CompletionOnMemberAccess) {
            Expression ma = ((CompletionOnMemberAccess)n).receiver;
            this.mode = ma.isImplicitThis() || ma.isSuper() || ma.isThis() ? CompletionMode.THIS : CompletionMode.MEMBER_ACCESS;
        }
        return this.mode != null;
    }

    private boolean findPotentialTypes() {
        if (this.mode == CompletionMode.TYPE_NAME) {
            ASTNode n = (ASTNode)this.rCtx.getCompletionNode().orNull();
            CompletionOnSingleNameReference c = null;
            if (n instanceof CompletionOnSingleNameReference) {
                c = (CompletionOnSingleNameReference)n;
                this.candidates = this.findTypesBySimpleName(c.token);
            }
        } else if (this.mode == CompletionMode.THIS) {
            this.createCandidatesFromOptional(this.getSupertypeOfThis());
        } else {
            this.createCandidatesFromOptional((Optional<IType>)this.rCtx.getReceiverType());
        }
        return this.candidates != null;
    }

    private Optional<IType> getSupertypeOfThis() {
        try {
            IMethod m = (IMethod)this.rCtx.getEnclosingMethod().orNull();
            if (m == null || JdtFlags.isStatic((IMember)m)) {
                return Optional.absent();
            }
            IType type = m.getDeclaringType();
            ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)type);
            return Optional.of((Object)hierarchy.getSuperclass(type));
        }
        catch (Exception e) {
            this.log.error("Failed to resolve super type of " + this.rCtx.getEnclosingElement(), (Throwable)e);
            return Optional.absent();
        }
    }

    private void createCandidatesFromOptional(Optional<IType> optType) {
        if (optType.isPresent()) {
            this.candidates = Sets.newHashSet((Object[])new IType[]{(IType)optType.get()});
        }
    }

    private boolean isPotentialClassName(CompletionOnQualifiedNameReference c) {
        char[] name = c.completionIdentifier;
        return name != null && name.length > 0 && CharUtils.isAsciiAlphaUpper((char)name[0]);
    }

    private boolean isPotentialClassName(CompletionOnSingleNameReference c) {
        return c.token != null && c.token.length > 0 && CharUtils.isAsciiAlphaUpper((char)c.token[0]);
    }

    private boolean findEnclosingMethod() {
        this.enclosingMethod = (IMethod)this.rCtx.getEnclosingMethod().orNull();
        return this.enclosingMethod != null;
    }

    public void sessionStarted() {
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    public Set<IType> findTypesBySimpleName(char[] simpleTypeName) {
        final HashSet result = Sets.newHashSet();
        try {
            final JavaProject project = (JavaProject)this.rCtx.getProject();
            SearchableEnvironment environment = project.newSearchableNameEnvironment((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
            environment.findExactTypes(simpleTypeName, false, 0, new ISearchRequestor(){

                public void acceptConstructor(int modifiers, char[] simpleTypeName, int parameterCount, char[] signature, char[][] parameterTypes, char[][] parameterNames, int typeModifiers, char[] packageName, int extraFlags, String path, AccessRestriction access) {
                }

                public void acceptType(char[] packageName, char[] typeName, char[][] enclosingTypeNames, int modifiers, AccessRestriction accessRestriction) {
                    try {
                        IType res = project.findType(String.valueOf(packageName), String.valueOf(typeName));
                        if (res != null) {
                            result.add(res);
                        }
                    }
                    catch (JavaModelException e) {
                        TemplatesCompletionProposalComputer.this.log.error("Received an error while searching.", (Throwable)e);
                    }
                }

                public void acceptPackage(char[] packageName) {
                }
            });
        }
        catch (JavaModelException e) {
            Throws.throwUnhandledException((Exception)((Object)e));
        }
        return result;
    }

    public static enum CompletionMode {
        TYPE_NAME,
        MEMBER_ACCESS,
        THIS;

    }
}

