/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.chain.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMessageSend;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedAllocationExpression;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedNameReference;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.recommenders.completion.rcp.CompletionContextKey;
import org.eclipse.recommenders.completion.rcp.DisableContentAssistCategoryJob;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.RecommendersCompletionContext;
import org.eclipse.recommenders.internal.chain.rcp.Chain;
import org.eclipse.recommenders.internal.chain.rcp.ChainCompletionProposal;
import org.eclipse.recommenders.internal.chain.rcp.ChainElement;
import org.eclipse.recommenders.internal.chain.rcp.ChainFinder;
import org.eclipse.recommenders.internal.chain.rcp.ChainRcpModule;
import org.eclipse.recommenders.internal.chain.rcp.CompletionTemplateBuilder;
import org.eclipse.recommenders.internal.chain.rcp.ScopeAccessWorkaround;
import org.eclipse.recommenders.internal.chain.rcp.TypeBindingAnalyzer;
import org.eclipse.recommenders.rcp.IAstProvider;
import org.eclipse.recommenders.utils.Checks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    public static final String CATEGORY_ID = "org.eclipse.recommenders.chain.rcp.proposalCategory.chain";
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private IRecommendersCompletionContext ctx;
    private List<ChainElement> entrypoints;
    private String error;
    private final IPreferenceStore prefStore;
    private Scope scope;
    private InvocationSite invocationSite;
    private IAstProvider astProvider;

    @Inject
    public ChainCompletionProposalComputer(IAstProvider astProvider, @ChainRcpModule.ChainCompletion IPreferenceStore preferenceStore) {
        this.astProvider = astProvider;
        this.prefStore = preferenceStore;
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!this.shouldMakeProposals()) {
            return Collections.emptyList();
        }
        if (!this.initializeRequiredContext(context)) {
            return Collections.emptyList();
        }
        if (!this.shouldPerformCompletionOnExpectedType()) {
            return Collections.emptyList();
        }
        if (!this.findEntrypoints()) {
            return Collections.emptyList();
        }
        return this.executeCallChainSearch();
    }

    @VisibleForTesting
    protected boolean shouldMakeProposals() {
        HashSet excluded = Sets.newHashSet((Object[])PreferenceConstants.getExcludedCompletionProposalCategories());
        if (excluded.contains(CATEGORY_ID)) {
            return true;
        }
        new DisableContentAssistCategoryJob(CATEGORY_ID).schedule(300L);
        return false;
    }

    private boolean initializeRequiredContext(ContentAssistInvocationContext context) {
        JavaContentAssistInvocationContext jdtCtx = (JavaContentAssistInvocationContext)Checks.castOrNull((Object)context);
        if (jdtCtx == null) {
            return false;
        }
        this.ctx = new RecommendersCompletionContext(jdtCtx, this.astProvider);
        Optional<Scope> optionalScope = ScopeAccessWorkaround.resolveScope(this.ctx);
        if (!optionalScope.isPresent()) {
            return false;
        }
        this.scope = (Scope)optionalScope.get();
        return true;
    }

    private boolean shouldPerformCompletionOnExpectedType() {
        Optional expected = this.ctx.getExpectedType();
        return expected.isPresent() || !this.ctx.getExpectedTypeNames().isEmpty();
    }

    private boolean findEntrypoints() {
        this.entrypoints = new LinkedList<ChainElement>();
        ASTNode node = (ASTNode)this.ctx.getCompletionNode().orNull();
        if (node instanceof CompletionOnQualifiedNameReference) {
            this.invocationSite = (CompletionOnQualifiedNameReference)node;
            this.findEntrypointsForCompletionOnQualifiedName((CompletionOnQualifiedNameReference)node);
        } else if (node instanceof CompletionOnMemberAccess) {
            this.invocationSite = (CompletionOnMemberAccess)node;
            this.findEntrypointsForCompletionOnMemberAccess((CompletionOnMemberAccess)node);
        } else if (node instanceof CompletionOnSingleNameReference || node instanceof CompletionOnQualifiedAllocationExpression || node instanceof CompletionOnMessageSend) {
            this.invocationSite = (InvocationSite)node;
            this.findEntrypointsForCompletionOnSingleName();
        }
        return !this.entrypoints.isEmpty();
    }

    private void findEntrypointsForCompletionOnQualifiedName(CompletionOnQualifiedNameReference node) {
        Binding b = node.binding;
        if (b == null) {
            return;
        }
        switch (b.kind()) {
            case 4: {
                this.addPublicStaticMembersToEntrypoints((TypeBinding)b);
                break;
            }
            case 1: {
                this.addPublicInstanceMembersToEntrypoints(((FieldBinding)b).type);
                break;
            }
            case 2: {
                this.addPublicInstanceMembersToEntrypoints(((VariableBinding)b).type);
                break;
            }
            default: {
                this.log.warn("Can't handle %s as source for finding entrypoints.", (Object)b);
            }
        }
    }

    private void addPublicStaticMembersToEntrypoints(TypeBinding type) {
        for (Binding m : TypeBindingAnalyzer.findAllPublicStaticFieldsAndNonVoidNonPrimitiveStaticMethods(type, this.invocationSite, this.scope)) {
            if (!this.matchesExpectedPrefix(m)) continue;
            this.entrypoints.add(new ChainElement(m, false));
        }
    }

    private void addPublicInstanceMembersToEntrypoints(TypeBinding type) {
        for (Binding m : TypeBindingAnalyzer.findVisibleInstanceFieldsAndRelevantInstanceMethods(type, this.invocationSite, this.scope)) {
            if (!this.matchesExpectedPrefix(m)) continue;
            this.entrypoints.add(new ChainElement(m, false));
        }
    }

    private boolean matchesExpectedPrefix(Binding binding) {
        return String.valueOf(binding.readableName()).startsWith(this.ctx.getPrefix());
    }

    private void findEntrypointsForCompletionOnMemberAccess(CompletionOnMemberAccess node) {
        TypeBinding b = node.actualReceiverType;
        if (b == null) {
            return;
        }
        this.addPublicInstanceMembersToEntrypoints(b);
    }

    private void findEntrypointsForCompletionOnSingleName() {
        InternalCompletionContext context = (InternalCompletionContext)this.ctx.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
        ObjectVector visibleLocalVariables = context.getVisibleLocalVariables();
        Set<String> localVariableNames = ChainCompletionProposalComputer.getLocalVariableNames(visibleLocalVariables);
        this.resolveEntrypoints(visibleLocalVariables, localVariableNames);
        this.resolveEntrypoints(context.getVisibleFields(), localVariableNames);
        this.resolveEntrypoints(context.getVisibleMethods(), localVariableNames);
    }

    private static Set<String> getLocalVariableNames(ObjectVector visibleLocalVariables) {
        HashSet names = Sets.newHashSet();
        int i = visibleLocalVariables.size();
        while (i-- > 0) {
            LocalVariableBinding decl = (LocalVariableBinding)visibleLocalVariables.elementAt(i);
            names.add(Arrays.toString(decl.name));
        }
        return names;
    }

    private void resolveEntrypoints(ObjectVector elements, Set<String> localVariableNames) {
        int i = elements.size();
        while (i-- > 0) {
            ChainElement e;
            String key;
            Binding decl = (Binding)elements.elementAt(i);
            if (!this.matchesPrefixToken(decl) || (key = String.valueOf(decl.computeUniqueKey())).startsWith("Ljava/lang/Object;")) continue;
            boolean requiresThis = false;
            if (decl instanceof FieldBinding) {
                requiresThis = localVariableNames.contains(Arrays.toString(((FieldBinding)decl).name));
            }
            if ((e = new ChainElement(decl, requiresThis)).getReturnType() == null) continue;
            this.entrypoints.add(e);
        }
    }

    private boolean matchesPrefixToken(Binding decl) {
        return String.valueOf(decl.readableName()).startsWith(this.ctx.getPrefix());
    }

    private List<ICompletionProposal> executeCallChainSearch() {
        final int maxChains = this.prefStore.getInt("recommenders.chain.max_chains");
        final int minDepth = this.prefStore.getInt("recommenders.chain.min_chain_length");
        final int maxDepth = this.prefStore.getInt("recommenders.chain.max_chain_length");
        Object[] excludedTypes = this.prefStore.getString("recommenders.chain.ignore_types").split("\\|");
        int i = 0;
        while (i < excludedTypes.length) {
            excludedTypes[i] = "L" + excludedTypes[i].replace('.', '/');
            ++i;
        }
        List<Optional<TypeBinding>> expectedTypes = TypeBindingAnalyzer.resolveBindingsForExpectedTypes(this.ctx, this.scope);
        final ChainFinder finder = new ChainFinder(expectedTypes, Sets.newHashSet((Object[])excludedTypes), this.invocationSite, this.scope);
        try {
            new SimpleTimeLimiter().callWithTimeout((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    finder.startChainSearch(ChainCompletionProposalComputer.this.entrypoints, maxChains, minDepth, maxDepth);
                    return null;
                }
            }, (long)this.prefStore.getInt("recommenders.chain.timeout"), TimeUnit.SECONDS, true);
        }
        catch (Exception exception) {
            this.setError("Timeout during call chain computation.");
        }
        return this.buildCompletionProposals(finder.getChains());
    }

    private List<ICompletionProposal> buildCompletionProposals(List<Chain> chains) {
        LinkedList proposals = Lists.newLinkedList();
        for (Chain chain : chains) {
            TemplateProposal proposal = CompletionTemplateBuilder.create(chain, this.ctx.getJavaContext());
            ChainCompletionProposal completionProposal = new ChainCompletionProposal(proposal, chain);
            proposals.add(completionProposal);
        }
        return proposals;
    }

    private void setError(String errorMessage) {
        this.error = errorMessage;
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public void sessionStarted() {
        this.setError(null);
    }

    public String getErrorMessage() {
        return this.error;
    }

    public void sessionEnded() {
    }
}

