/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.apidocs.rcp;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.recommenders.apidocs.ClassOverrideDirectives;
import org.eclipse.recommenders.apidocs.ClassOverridePatterns;
import org.eclipse.recommenders.apidocs.MethodPattern;
import org.eclipse.recommenders.apidocs.OverrideDirectivesModelProvider;
import org.eclipse.recommenders.apidocs.OverridePatternsModelProvider;
import org.eclipse.recommenders.apidocs.rcp.ApidocProvider;
import org.eclipse.recommenders.apidocs.rcp.JavaSelectionSubscriber;
import org.eclipse.recommenders.internal.apidocs.rcp.ApidocsViewUtils;
import org.eclipse.recommenders.internal.apidocs.rcp.Messages;
import org.eclipse.recommenders.models.IInputStreamTransformer;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.models.rcp.ModelEvents;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.rcp.JavaElementSelectionEvent;
import org.eclipse.recommenders.utils.Bags;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public final class OverridesProvider
extends ApidocProvider {
    private final JavaElementResolver resolver;
    private final EventBus workspaceBus;
    private final IProjectCoordinateProvider pcProvider;
    private final OverrideDirectivesModelProvider dStore;
    private final OverridePatternsModelProvider pStore;

    @Inject
    public OverridesProvider(IProjectCoordinateProvider pcProvider, JavaElementResolver resolver, EventBus workspaceBus, IModelRepository repository, IModelIndex index, Map<String, IInputStreamTransformer> transformers) {
        this.pcProvider = pcProvider;
        this.resolver = resolver;
        this.workspaceBus = workspaceBus;
        this.pStore = new OverridePatternsModelProvider(repository, index, transformers);
        this.dStore = new OverrideDirectivesModelProvider(repository, index, transformers);
    }

    @Subscribe
    public void onEvent(ModelEvents.ModelIndexOpenedEvent e) throws IOException {
        this.pStore.close();
        this.pStore.open();
        this.dStore.close();
        this.dStore.open();
    }

    @JavaSelectionSubscriber
    public void onTypeRootSelection(ITypeRoot root, JavaElementSelectionEvent event, Composite parent) throws ExecutionException {
        IType type = root.findPrimaryType();
        if (type != null) {
            this.onTypeSelection(type, event, parent);
        }
    }

    @JavaSelectionSubscriber
    public void onMethodSelection(IMethod method, JavaElementSelectionEvent event, Composite parent) throws ExecutionException {
        this.onTypeSelection(method.getDeclaringType(), event, parent);
    }

    @JavaSelectionSubscriber
    public void onVariableSelection(ILocalVariable var, JavaElementSelectionEvent event, Composite parent) throws ExecutionException {
        IType type = (IType)ApidocsViewUtils.findType(var).orNull();
        if (type != null) {
            this.onTypeSelection(type, event, parent);
        }
    }

    @JavaSelectionSubscriber
    public void onVariableSelection(IField var, JavaElementSelectionEvent event, Composite parent) throws ExecutionException, JavaModelException {
        IType type = (IType)ApidocsViewUtils.findType(var).orNull();
        if (type != null) {
            this.onTypeSelection(type, event, parent);
        }
    }

    @JavaSelectionSubscriber
    public void onTypeSelection(IType type, JavaElementSelectionEvent event, Composite parent) throws ExecutionException {
        this.renderClassOverrideDirectives(type, parent);
        this.renderClassOverridesPatterns(type, parent);
    }

    private boolean renderClassOverrideDirectives(IType type, Composite parent) throws ExecutionException {
        ClassOverrideDirectives model = (ClassOverrideDirectives)this.dStore.acquireModel((IUniqueName)((UniqueTypeName)this.pcProvider.toUniqueName(type).orNull())).orNull();
        try {
            if (model == null || model.getOverrides() == null) {
                return false;
            }
            this.runSyncInUiThread(new TypeOverrideDirectivesRenderer(type, model, parent));
        }
        finally {
            this.dStore.releaseModel((Object)model);
        }
        return true;
    }

    private boolean renderClassOverridesPatterns(IType type, Composite parent) throws ExecutionException {
        ClassOverridePatterns opt = (ClassOverridePatterns)this.pStore.acquireModel((IUniqueName)((UniqueTypeName)this.pcProvider.toUniqueName(type).orNull())).orNull();
        try {
            if (opt != null) {
                this.runSyncInUiThread(new OverridePatternsRenderer(type, opt, parent));
            }
        }
        finally {
            this.pStore.releaseModel((Object)opt);
        }
        return true;
    }

    private class OverridePatternsRenderer
    implements Runnable {
        private final Composite parent;
        private Composite container;
        double totalNumberOfExamples;
        private List<MethodPattern> patterns;

        public OverridePatternsRenderer(IType type, ClassOverridePatterns directive, Composite parent) {
            this.parent = parent;
            this.setPatterns(directive);
            this.computeTotalNumberOfExamples();
            this.filterInfrequentPatterns();
            this.sortPatterns();
        }

        private void setPatterns(ClassOverridePatterns patterns) {
            this.patterns = Arrays.asList(patterns.getPatterns());
        }

        private void filterInfrequentPatterns() {
            this.patterns = Lists.newLinkedList((Iterable)Collections2.filter(this.patterns, (Predicate)new Predicate<MethodPattern>(){

                public boolean apply(MethodPattern input) {
                    int numberOfObservations = input.getNumberOfObservations();
                    return (double)numberOfObservations / OverridePatternsRenderer.this.totalNumberOfExamples > 0.1;
                }
            }));
        }

        private void sortPatterns() {
            Collections.sort(this.patterns, new Comparator<MethodPattern>(){

                @Override
                public int compare(MethodPattern o1, MethodPattern o2) {
                    return o2.getNumberOfObservations() - o1.getNumberOfObservations();
                }
            });
        }

        private void computeTotalNumberOfExamples() {
            for (MethodPattern pattern : this.patterns) {
                this.totalNumberOfExamples += (double)pattern.getNumberOfObservations();
            }
        }

        @Override
        public void run() {
            this.createContainer();
            this.addHeader();
            int i = 1;
            for (MethodPattern pattern : this.patterns) {
                this.addDirectives(pattern, i++);
            }
        }

        private void createContainer() {
            this.container = new Composite(this.parent, 0);
            ApidocsViewUtils.setInfoBackgroundColor((Control)this.container);
            this.container.setLayout((Layout)new GridLayout());
            this.container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        }

        private void addHeader() {
            new Label(this.container, 0);
            String message = MessageFormat.format(Messages.PROVIDER_INTRO_OVERRIDE_PATTERNS, new Object[0]);
            ApidocsViewUtils.createLabel(this.container, message, true);
        }

        private void addDirectives(MethodPattern pattern, int index) {
            double patternPercentage = (double)pattern.getNumberOfObservations() / this.totalNumberOfExamples;
            String text = MessageFormat.format(Messages.TABLE_HEADER_OVERRIDE_PATTERN, index, patternPercentage, pattern.getNumberOfObservations());
            ApidocsViewUtils.createLabel(this.container, text, true, false, 16, true);
            Composite group = ApidocsViewUtils.createGridComposite(this.container, 1, 0, 0, 0, 0);
            LinkedList s = Lists.newLinkedList(pattern.getMethods().entrySet());
            Collections.sort(s, new Comparator<Map.Entry<IMethodName, Double>>(){

                @Override
                public int compare(Map.Entry<IMethodName, Double> o1, Map.Entry<IMethodName, Double> o2) {
                    return o1.getKey().getName().compareTo(o2.getKey().getName());
                }
            });
            Table table = new Table(group, 32768);
            table.setBackground(ApidocsViewUtils.createColor(29));
            table.setLayoutData((Object)GridDataFactory.fillDefaults().indent(10, 0).create());
            TableColumn column1 = new TableColumn(table, 0);
            TableColumn column2 = new TableColumn(table, 0);
            TableColumn column3 = new TableColumn(table, 0);
            TableColumn column4 = new TableColumn(table, 0);
            for (Map.Entry entry : s) {
                double percentage = (Double)entry.getValue();
                String phraseText = ApidocsViewUtils.percentageToRecommendationPhrase((int)Math.rint(percentage * 100.0));
                String stats = MessageFormat.format(Messages.TABLE_CELL_SUFFIX_PERCENTAGE, percentage);
                Link bar = ApidocsViewUtils.createMethodLink((Composite)table, (IMethodName)entry.getKey(), OverridesProvider.this.resolver, OverridesProvider.this.workspaceBus);
                TableItem item = new TableItem(table, 0);
                item.setText(new String[]{phraseText, Messages.TABLE_CELL_RELATION_OVERRIDE, bar.getText(), stats});
                item.setFont(0, JFaceResources.getBannerFont());
                item.setForeground(ApidocsViewUtils.createColor(28));
                TableEditor editor = new TableEditor(table);
                editor.grabVertical = true;
                editor.grabHorizontal = true;
                editor.setEditor((Control)bar, item, 2);
            }
            column1.pack();
            column2.pack();
            column3.pack();
            column4.pack();
            new Label(this.container, 258);
        }
    }

    private class TypeOverrideDirectivesRenderer
    implements Runnable {
        private final IType type;
        private final ClassOverrideDirectives directive;
        private final Composite parent;
        private Composite container;

        public TypeOverrideDirectivesRenderer(IType type, ClassOverrideDirectives directive, Composite parent) {
            this.type = type;
            this.directive = directive;
            this.parent = parent;
        }

        @Override
        public void run() {
            this.createContainer();
            this.addHeader();
            this.addDirectives();
        }

        private void createContainer() {
            this.container = new Composite(this.parent, 0);
            ApidocsViewUtils.setInfoBackgroundColor((Control)this.container);
            this.container.setLayout((Layout)new GridLayout());
        }

        private void addHeader() {
            String message = MessageFormat.format(Messages.PROVIDER_INTRO_OVERRIDE_STATISTICS, this.directive.getNumberOfSubclasses(), this.type.getElementName());
            Label label = new Label(this.container, 0);
            label.setText(message);
            ApidocsViewUtils.setInfoForegroundColor((Control)label);
            ApidocsViewUtils.setInfoBackgroundColor((Control)label);
        }

        private void addDirectives() {
            int numberOfSubclasses = this.directive.getNumberOfSubclasses();
            Multiset b = Bags.newHashMultiset((Map)this.directive.getOverrides());
            ApidocsViewUtils.renderMethodDirectivesBlock(this.container, (Multiset<IMethodName>)b, numberOfSubclasses, OverridesProvider.this.workspaceBus, OverridesProvider.this.resolver, Messages.TABLE_CELL_RELATION_OVERRIDE);
        }
    }
}

