/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d.geometry;

import java.io.Serializable;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Insets;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Translatable;

public final class Point
implements Translatable,
Serializable {
    private static final long serialVersionUID = 0L;
    public int x;
    public int y;

    public Point() {
    }

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point(double x, double y) {
        this.x = (int)x;
        this.y = (int)y;
    }

    public Point(Point copy) {
        this.x = copy.x;
        this.y = copy.y;
    }

    public Point(org.eclipse.swt.graphics.Point copy) {
        this.x = copy.x;
        this.y = copy.y;
    }

    public Point(Dimension copy) {
        this.x = copy.width;
        this.y = copy.height;
    }

    public Point getCopy() {
        return new Point(this.x, this.y);
    }

    public org.eclipse.swt.graphics.Point getSwtPoint() {
        return new org.eclipse.swt.graphics.Point(this.x, this.y);
    }

    public Point setLocation(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Point setLocation(Point point) {
        this.x = point.x;
        this.y = point.y;
        return this;
    }

    public Point setLocation(org.eclipse.swt.graphics.Point point) {
        this.x = point.x;
        this.y = point.y;
        return this;
    }

    public Dimension getDifference(Point point) {
        return new Dimension(this.x - point.x, this.y - point.y);
    }

    public double getDistance(Point point) {
        return Math.sqrt(this.getDistance2(point));
    }

    public int getDistance2(Point point) {
        int dx = point.x - this.x;
        int dy = point.y - this.y;
        return dx * dx + dy * dy;
    }

    public int getDistanceOrthogonal(Point point) {
        return Math.abs(this.y - point.y) + Math.abs(this.x - point.x);
    }

    public Point negate() {
        this.x = -this.x;
        this.y = -this.y;
        return this;
    }

    public Point scale(double amount) {
        return this.scale(amount, amount);
    }

    public Point scale(double xAmount, double yAmount) {
        this.x = (int)Math.floor((double)this.x * xAmount);
        this.y = (int)Math.floor((double)this.y * yAmount);
        return this;
    }

    public Point transpose() {
        int temp = this.x;
        this.x = this.y;
        this.y = temp;
        return this;
    }

    public void translate(Point point) {
        this.translate(point.x, point.y);
    }

    public void translate(Dimension dimension) {
        this.translate(dimension.width, dimension.height);
    }

    public void translate(Insets insets) {
        this.translate(insets.left, insets.top);
    }

    public void translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public Point getNegated() {
        return this.getCopy().negate();
    }

    public Point getScaled(double amount) {
        return this.getCopy().scale(amount);
    }

    public Point getTranslated(Dimension delta) {
        Point copy = this.getCopy();
        copy.translate(delta);
        return copy;
    }

    public Point getTranslated(int _x, int _y) {
        Point copy = this.getCopy();
        copy.translate(_x, _y);
        return copy;
    }

    public Point getTranslated(Point point) {
        Point copy = this.getCopy();
        copy.translate(point);
        return copy;
    }

    public Point getTransposed() {
        return this.getCopy().transpose();
    }

    public static Point max(Point point1, Point point2) {
        Point point = new Rectangle(point1, point2).getBottomRight();
        point.translate(-1, -1);
        return point;
    }

    public static Point min(Point point1, Point point2) {
        return new Rectangle(point1, point2).getTopLeft();
    }

    public boolean equals(Object object) {
        if (object instanceof Point) {
            Point point = (Point)object;
            return point.x == this.x && point.y == this.y;
        }
        return false;
    }

    public int hashCode() {
        return this.x ^ this.y << 10;
    }

    public String toString() {
        return "Point(" + this.x + ", " + this.y + ")";
    }
}

