/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import org.apache.commons.collections.primitives.AbstractDoubleCollection;
import org.apache.commons.collections.primitives.DoubleCollection;
import org.apache.commons.collections.primitives.DoubleIterator;
import org.apache.commons.collections.primitives.DoubleList;
import org.apache.commons.collections.primitives.DoubleListIterator;

public abstract class RandomAccessDoubleList
extends AbstractDoubleCollection
implements DoubleList {
    private int _modCount = 0;

    protected RandomAccessDoubleList() {
    }

    public abstract double get(int var1);

    public abstract int size();

    public double removeElementAt(int index) {
        throw new UnsupportedOperationException();
    }

    public double set(int index, double element) {
        throw new UnsupportedOperationException();
    }

    public void add(int index, double element) {
        throw new UnsupportedOperationException();
    }

    public boolean add(double element) {
        this.add(this.size(), element);
        return true;
    }

    public boolean addAll(int index, DoubleCollection collection) {
        boolean modified = false;
        DoubleIterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.add(index++, iter.next());
            modified = true;
        }
        return modified;
    }

    public int indexOf(double element) {
        int i = 0;
        DoubleIterator iter = this.iterator();
        while (iter.hasNext()) {
            if (iter.next() == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(double element) {
        DoubleListIterator iter = this.listIterator(this.size());
        while (iter.hasPrevious()) {
            if (iter.previous() != element) continue;
            return iter.nextIndex();
        }
        return -1;
    }

    public DoubleIterator iterator() {
        return this.listIterator();
    }

    public DoubleListIterator listIterator() {
        return this.listIterator(0);
    }

    public DoubleListIterator listIterator(int index) {
        return new RandomAccessDoubleListIterator(this, index);
    }

    public DoubleList subList(int fromIndex, int toIndex) {
        return new RandomAccessDoubleSubList(this, fromIndex, toIndex);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof DoubleList) {
            DoubleList thatList = (DoubleList)that;
            if (this.size() != thatList.size()) {
                return false;
            }
            DoubleIterator thatIter = thatList.iterator();
            DoubleIterator thisIter = this.iterator();
            while (thisIter.hasNext()) {
                if (thisIter.next() == thatIter.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        DoubleIterator iter = this.iterator();
        while (iter.hasNext()) {
            long bits = Double.doubleToLongBits(iter.next());
            hash = 31 * hash + (int)(bits ^ bits >>> 32);
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        DoubleIterator iter = this.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    protected int getModCount() {
        return this._modCount;
    }

    protected void incrModCount() {
        ++this._modCount;
    }

    private static class ComodChecker {
        private RandomAccessDoubleList _source = null;
        private int _expectedModCount = -1;

        ComodChecker(RandomAccessDoubleList source) {
            this._source = source;
            this.resyncModCount();
        }

        protected RandomAccessDoubleList getList() {
            return this._source;
        }

        protected void assertNotComodified() throws ConcurrentModificationException {
            if (this._expectedModCount != this.getList().getModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void resyncModCount() {
            this._expectedModCount = this.getList().getModCount();
        }
    }

    protected static class RandomAccessDoubleListIterator
    extends ComodChecker
    implements DoubleListIterator {
        private int _nextIndex = 0;
        private int _lastReturnedIndex = -1;

        RandomAccessDoubleListIterator(RandomAccessDoubleList list, int index) {
            super(list);
            if (index < 0 || index > this.getList().size()) {
                throw new IndexOutOfBoundsException("Index " + index + " not in [0," + this.getList().size() + ")");
            }
            this._nextIndex = index;
            this.resyncModCount();
        }

        public boolean hasNext() {
            this.assertNotComodified();
            return this._nextIndex < this.getList().size();
        }

        public boolean hasPrevious() {
            this.assertNotComodified();
            return this._nextIndex > 0;
        }

        public int nextIndex() {
            this.assertNotComodified();
            return this._nextIndex;
        }

        public int previousIndex() {
            this.assertNotComodified();
            return this._nextIndex - 1;
        }

        public double next() {
            this.assertNotComodified();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            double val = this.getList().get(this._nextIndex);
            this._lastReturnedIndex = this._nextIndex++;
            return val;
        }

        public double previous() {
            this.assertNotComodified();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            double val = this.getList().get(this._nextIndex - 1);
            this._lastReturnedIndex = this._nextIndex - 1;
            --this._nextIndex;
            return val;
        }

        public void add(double value) {
            this.assertNotComodified();
            this.getList().add(this._nextIndex, value);
            ++this._nextIndex;
            this._lastReturnedIndex = -1;
            this.resyncModCount();
        }

        public void remove() {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().removeElementAt(this._lastReturnedIndex);
            this._lastReturnedIndex = -1;
            --this._nextIndex;
            this.resyncModCount();
        }

        public void set(double value) {
            this.assertNotComodified();
            if (-1 == this._lastReturnedIndex) {
                throw new IllegalStateException();
            }
            this.getList().set(this._lastReturnedIndex, value);
            this.resyncModCount();
        }
    }

    protected static class RandomAccessDoubleSubList
    extends RandomAccessDoubleList
    implements DoubleList {
        private int _offset = 0;
        private int _limit = 0;
        private RandomAccessDoubleList _list = null;
        private ComodChecker _comod = null;

        RandomAccessDoubleSubList(RandomAccessDoubleList list, int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > list.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException();
            }
            this._list = list;
            this._offset = fromIndex;
            this._limit = toIndex - fromIndex;
            this._comod = new ComodChecker(list);
            this._comod.resyncModCount();
        }

        public double get(int index) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            return this._list.get(this.toUnderlyingIndex(index));
        }

        public double removeElementAt(int index) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            double val = this._list.removeElementAt(this.toUnderlyingIndex(index));
            --this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
            return val;
        }

        public double set(int index, double element) {
            this.checkRange(index);
            this._comod.assertNotComodified();
            double val = this._list.set(this.toUnderlyingIndex(index), element);
            this.incrModCount();
            this._comod.resyncModCount();
            return val;
        }

        public void add(int index, double element) {
            this.checkRangeIncludingEndpoint(index);
            this._comod.assertNotComodified();
            this._list.add(this.toUnderlyingIndex(index), element);
            ++this._limit;
            this._comod.resyncModCount();
            this.incrModCount();
        }

        public int size() {
            this._comod.assertNotComodified();
            return this._limit;
        }

        private void checkRange(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException("index " + index + " not in [0," + this.size() + ")");
            }
        }

        private void checkRangeIncludingEndpoint(int index) {
            if (index < 0 || index > this.size()) {
                throw new IndexOutOfBoundsException("index " + index + " not in [0," + this.size() + "]");
            }
        }

        private int toUnderlyingIndex(int index) {
            return index + this._offset;
        }
    }
}

