/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp;

import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.recommenders.internal.rcp.LogMessages;
import org.eclipse.recommenders.rcp.JavaElementSelectionEvent;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.ui.IEditorPart;

public final class JavaElementSelections {
    private static final Map<StructuralPropertyDescriptor, JavaElementSelectionEvent.JavaElementSelectionLocation> MAPPING = new HashMap<StructuralPropertyDescriptor, JavaElementSelectionEvent.JavaElementSelectionLocation>(){
        {
            this.put(CompilationUnit.IMPORTS_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.TYPE_DECLARATION);
            this.put(CompilationUnit.PACKAGE_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.TYPE_DECLARATION);
            this.put(CompilationUnit.TYPES_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.TYPE_DECLARATION);
            this.put(TypeDeclaration.BODY_DECLARATIONS_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.TYPE_DECLARATION);
            this.put(TypeDeclaration.INTERFACE_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.TYPE_DECLARATION);
            this.put(TypeDeclaration.JAVADOC_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.TYPE_DECLARATION);
            this.put(TypeDeclaration.MODIFIERS2_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.TYPE_DECLARATION);
            this.put(TypeDeclaration.NAME_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.TYPE_DECLARATION);
            this.put(TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.TYPE_DECLARATION_EXTENDS);
            this.put(TypeDeclaration.SUPER_INTERFACE_TYPES_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.TYPE_DECLARATION_IMPLEMENTS);
            this.put(TypeDeclaration.TYPE_PARAMETERS_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.UNKNOWN);
            this.put(MethodDeclaration.BODY_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_BODY);
            this.put(MethodDeclaration.CONSTRUCTOR_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_DECLARATION);
            this.put(MethodDeclaration.JAVADOC_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_DECLARATION);
            this.put(MethodDeclaration.MODIFIERS2_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_DECLARATION);
            this.put(MethodDeclaration.NAME_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_DECLARATION);
            this.put(MethodDeclaration.PARAMETERS_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_DECLARATION_PARAMETER);
            this.put(MethodDeclaration.RETURN_TYPE2_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_DECLARATION_RETURN);
            this.put(MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_DECLARATION_THROWS);
            this.put(MethodDeclaration.TYPE_PARAMETERS_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.UNKNOWN);
            this.put(Initializer.BODY_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_BODY);
            this.put(Initializer.MODIFIERS2_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_DECLARATION);
            this.put(FieldDeclaration.FRAGMENTS_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.FIELD_DECLARATION_INITIALIZER);
            this.put(VariableDeclarationFragment.NAME_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.FIELD_DECLARATION);
            this.put(FieldDeclaration.TYPE_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.FIELD_DECLARATION);
            this.put(FieldDeclaration.JAVADOC_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.FIELD_DECLARATION);
            this.put(FieldDeclaration.MODIFIERS2_PROPERTY, JavaElementSelectionEvent.JavaElementSelectionLocation.FIELD_DECLARATION);
        }
    };

    private JavaElementSelections() {
        throw new IllegalStateException("Not meant to be instantiated");
    }

    public static Optional<IJavaElement> resolveJavaElementFromEditor(IEditorPart editor, ITextSelection selection) {
        Checks.ensureIsNotNull((Object)editor);
        Checks.ensureIsNotNull((Object)selection);
        if (!JavaElementSelections.isValidSelection(selection)) {
            return Optional.absent();
        }
        if (editor instanceof JavaEditor) {
            JavaEditor javaEditor = (JavaEditor)editor;
            return JavaElementSelections.resolveJavaElementFromEditor(javaEditor, selection.getOffset());
        }
        return Optional.absent();
    }

    private static boolean isValidSelection(ITextSelection selection) {
        return selection.getOffset() != -1;
    }

    public static Optional<IJavaElement> resolveJavaElementFromEditor(JavaEditor editor, int offset) {
        Checks.ensureIsNotNull((Object)editor);
        Optional<ITypeRoot> root = JdtUtils.findTypeRoot((IEditorPart)editor);
        if (root.isPresent()) {
            return JavaElementSelections.resolveJavaElementFromTypeRootInEditor((ITypeRoot)root.get(), offset);
        }
        return Optional.absent();
    }

    public static Optional<IJavaElement> resolveJavaElementFromTypeRootInEditor(ITypeRoot root, int offset) {
        Checks.ensureIsNotNull((Object)root);
        try {
            if (JavaElementSelections.isInvalidSelection(root, offset)) {
                return Optional.absent();
            }
            IJavaElement[] elements = root.codeSelect(offset, 0);
            if (elements.length > 0) {
                return Optional.of((Object)elements[0]);
            }
            return Optional.absent();
        }
        catch (Exception e) {
            if (!JavaElementSelections.isInvalidSelection(root, offset)) {
                Logs.log((Logs.ILogMessage)LogMessages.FAILED_TO_RESOLVE_SELECTION, (Object[])new Object[]{root.getHandleIdentifier(), offset, e});
            }
            return Optional.absent();
        }
    }

    private static boolean isInvalidSelection(ITypeRoot root, int offset) {
        block5: {
            block4: {
                try {
                    if (root.exists()) break block4;
                    return true;
                }
                catch (Exception e) {
                    Logs.log((Logs.ILogMessage)LogMessages.EXCEPTION_WHILE_CHECKING_OFFSETS, (Throwable)e);
                    return false;
                }
            }
            IJavaElement ancestor = root.getAncestor(3);
            if (ancestor.exists()) break block5;
            return true;
        }
        ISourceRange range = root.getSourceRange();
        return range == null || offset < 0 || offset > range.getLength();
    }

    public static JavaElementSelectionEvent.JavaElementSelectionLocation resolveSelectionLocationFromAst(CompilationUnit astRoot, int offset) {
        Checks.ensureIsNotNull((Object)astRoot);
        ASTNode selectedNode = NodeFinder.perform((ASTNode)astRoot, (int)offset, (int)0);
        if (selectedNode == null) {
            return JavaElementSelectionEvent.JavaElementSelectionLocation.UNKNOWN;
        }
        return JavaElementSelections.resolveSelectionLocationFromAstNode(selectedNode);
    }

    public static JavaElementSelectionEvent.JavaElementSelectionLocation resolveSelectionLocationFromAstNode(ASTNode node) {
        if (node == null) {
            return JavaElementSelectionEvent.JavaElementSelectionLocation.UNKNOWN;
        }
        switch (node.getNodeType()) {
            case 15: 
            case 55: {
                return JavaElementSelectionEvent.JavaElementSelectionLocation.TYPE_DECLARATION;
            }
            case 28: 
            case 31: {
                return JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_DECLARATION;
            }
            case 23: {
                return JavaElementSelectionEvent.JavaElementSelectionLocation.FIELD_DECLARATION;
            }
        }
        return JavaElementSelections.resolveSelectionLocationFromNonMemberDeclarationNode(node);
    }

    /*
     * Unable to fully structure code
     */
    private static JavaElementSelectionEvent.JavaElementSelectionLocation resolveSelectionLocationFromNonMemberDeclarationNode(ASTNode node) {
        parent = node.getParent();
        if (parent != null) ** GOTO lbl13
        return JavaElementSelectionEvent.JavaElementSelectionLocation.TYPE_DECLARATION;
lbl-1000:
        // 1 sources

        {
            locationInParent = node.getLocationInParent();
            switch (parent.getNodeType()) {
                case 59: {
                    if (!JavaElementSelections.isVariableNameSelectionInFieldDeclaration(parent, locationInParent)) break;
                    return JavaElementSelectionEvent.JavaElementSelectionLocation.FIELD_DECLARATION;
                }
                case 15: 
                case 23: 
                case 28: 
                case 31: 
                case 55: {
                    return JavaElementSelections.mapLocationInParent(locationInParent);
                }
            }
            node = parent;
            parent = parent.getParent();
lbl13:
            // 2 sources

            ** while (node != null)
        }
lbl14:
        // 1 sources

        return JavaElementSelectionEvent.JavaElementSelectionLocation.UNKNOWN;
    }

    private static boolean isVariableNameSelectionInFieldDeclaration(ASTNode parent, StructuralPropertyDescriptor locationInParent) {
        ASTNode superparent = parent.getParent();
        return superparent instanceof FieldDeclaration && VariableDeclarationFragment.NAME_PROPERTY == locationInParent;
    }

    private static JavaElementSelectionEvent.JavaElementSelectionLocation mapLocationInParent(StructuralPropertyDescriptor locationInParent) {
        JavaElementSelectionEvent.JavaElementSelectionLocation res = MAPPING.get(locationInParent);
        return res != null ? res : JavaElementSelectionEvent.JavaElementSelectionLocation.UNKNOWN;
    }

    public static JavaElementSelectionEvent.JavaElementSelectionLocation resolveSelectionLocationFromJavaElement(IJavaElement element) {
        Checks.ensureIsNotNull((Object)element);
        switch (element.getElementType()) {
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                return JavaElementSelectionEvent.JavaElementSelectionLocation.TYPE_DECLARATION;
            }
            case 9: 
            case 10: {
                return JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_DECLARATION;
            }
            case 8: {
                return JavaElementSelectionEvent.JavaElementSelectionLocation.FIELD_DECLARATION;
            }
            case 14: {
                return JavaElementSelectionEvent.JavaElementSelectionLocation.METHOD_BODY;
            }
        }
        return JavaElementSelectionEvent.JavaElementSelectionLocation.UNKNOWN;
    }
}

