/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp.utils;

import com.google.common.base.Optional;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class RCPUtils {
    private RCPUtils() {
        throw new IllegalStateException("Not meant to be instantiated");
    }

    public static Optional<IWorkbenchPage> getActiveWorkbenchPage() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return Optional.absent();
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return Optional.absent();
        }
        IWorkbenchPage page = window.getActivePage();
        return Optional.of((Object)page);
    }

    public static StyledString deepCopy(StyledString displayString) {
        StyledString copy = new StyledString(displayString.getString());
        StyleRange[] styleRangeArray = displayString.getStyleRanges();
        int n = styleRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            final StyleRange range = styleRangeArray[n2];
            copy.setStyle(range.start, range.length, new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.background = range.background;
                    textStyle.borderColor = range.borderColor;
                    textStyle.borderStyle = range.borderStyle;
                    textStyle.font = range.font;
                    textStyle.foreground = range.foreground;
                }
            });
            ++n2;
        }
        return copy;
    }
}

