/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.breakpoints;

import com.ibm.icu.text.MessageFormat;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.core.breakpoints.JDIDebugBreakpointMessages;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaLineBreakpoint
extends JavaBreakpoint
implements IJavaLineBreakpoint {
    protected static final String CONDITION = "org.eclipse.jdt.debug.core.condition";
    protected static final String CONDITION_ENABLED = "org.eclipse.jdt.debug.core.conditionEnabled";
    protected static final String CONDITION_SUSPEND_ON_TRUE = "org.eclipse.jdt.debug.core.conditionSuspendOnTrue";
    protected static final String SOURCE_NAME = "org.eclipse.jdt.debug.core.sourceName";
    public static final String JAVA_LINE_BREAKPOINT = "org.eclipse.jdt.debug.javaLineBreakpointMarker";
    private Map<IJavaThread, ICompiledExpression> fSuspendEvents = new HashMap<IJavaThread, ICompiledExpression>();
    private Map<IJavaThread, ICompiledExpression> fCompiledExpressions = new HashMap<IJavaThread, ICompiledExpression>();
    private Map<IJavaStackFrame, IJavaProject> fProjectsByFrame = new HashMap<IJavaStackFrame, IJavaProject>();
    private Map<IDebugTarget, IValue> fConditionValues = new HashMap<IDebugTarget, IValue>();
    public static final int NO_LINE_NUMBERS = 162;

    public JavaLineBreakpoint() {
    }

    public JavaLineBreakpoint(IResource resource, String typeName, int lineNumber, int charStart, int charEnd, int hitCount, boolean add, Map<String, Object> attributes) throws DebugException {
        this(resource, typeName, lineNumber, charStart, charEnd, hitCount, add, attributes, JAVA_LINE_BREAKPOINT);
    }

    protected JavaLineBreakpoint(final IResource resource, final String typeName, final int lineNumber, final int charStart, final int charEnd, final int hitCount, final boolean add, final Map<String, Object> attributes, final String markerType) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JavaLineBreakpoint.this.setMarker(resource.createMarker(markerType));
                JavaLineBreakpoint.this.addLineBreakpointAttributes(attributes, JavaLineBreakpoint.this.getModelIdentifier(), true, lineNumber, charStart, charEnd);
                JavaLineBreakpoint.this.addTypeNameAndHitCount(attributes, typeName, hitCount);
                attributes.put("org.eclipse.jdt.debug.core.suspendPolicy", new Integer(JavaLineBreakpoint.this.getDefaultSuspendPolicy()));
                JavaLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                JavaLineBreakpoint.this.register(add);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    @Override
    public void addToTarget(JDIDebugTarget target) throws CoreException {
        this.clearCachedExpressionFor(target);
        super.addToTarget(target);
    }

    @Override
    public void removeFromTarget(JDIDebugTarget target) throws CoreException {
        this.clearCachedExpressionFor(target);
        this.clearCachedSuspendEvents(target);
        this.fConditionValues.remove(target);
        super.removeFromTarget(target);
    }

    protected void clearCachedSuspendEvents(JDIDebugTarget target) {
        this.removeCachedThreads(this.fSuspendEvents, target);
    }

    private void removeCachedThreads(Map<IJavaThread, ICompiledExpression> map, JDIDebugTarget target) {
        Set<IJavaThread> threads = map.keySet();
        ArrayList<JDIThread> threadsToRemove = new ArrayList<JDIThread>();
        for (JDIThread jDIThread : threads) {
            if (jDIThread.getDebugTarget() != target) continue;
            threadsToRemove.add(jDIThread);
        }
        Iterator<IJavaThread> iter = threadsToRemove.iterator();
        while (iter.hasNext()) {
            map.remove(iter.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCachedExpressionFor(JDIDebugTarget target) {
        this.removeCachedThreads(this.fCompiledExpressions, target);
        Map<IJavaStackFrame, IJavaProject> map = this.fProjectsByFrame;
        synchronized (map) {
            Set<IJavaStackFrame> frames = this.fProjectsByFrame.keySet();
            ArrayList<JDIStackFrame> framesToRemove = new ArrayList<JDIStackFrame>();
            for (JDIStackFrame jDIStackFrame : frames) {
                if (jDIStackFrame.getDebugTarget() != target) continue;
                framesToRemove.add(jDIStackFrame);
            }
            Iterator<IJavaStackFrame> iter = framesToRemove.iterator();
            while (iter.hasNext()) {
                this.fProjectsByFrame.remove(iter.next());
            }
        }
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    public static String getMarkerType() {
        return JAVA_LINE_BREAKPOINT;
    }

    @Override
    protected EventRequest[] newRequests(JDIDebugTarget target, ReferenceType type) throws CoreException {
        int lineNumber = this.getLineNumber();
        List<Location> locations = this.determineLocations(lineNumber, type, target);
        if (locations == null || locations.isEmpty()) {
            return null;
        }
        EventRequest[] requests = new EventRequest[locations.size()];
        int i = 0;
        for (Location location : locations) {
            requests[i] = this.createLineBreakpointRequest(location, target);
            ++i;
        }
        return requests;
    }

    protected BreakpointRequest createLineBreakpointRequest(Location location, JDIDebugTarget target) throws CoreException {
        BreakpointRequest request = null;
        EventRequestManager manager = target.getEventRequestManager();
        if (manager != null) {
            try {
                request = manager.createBreakpointRequest(location);
                this.configureRequest(request, target);
            }
            catch (VMDisconnectedException e) {
                if (!target.isAvailable()) {
                    return null;
                }
                JDIDebugPlugin.log(e);
            }
            catch (RuntimeException e) {
                target.internalError(e);
                return null;
            }
            return request;
        }
        target.requestFailed(JDIDebugBreakpointMessages.JavaLineBreakpoint_Unable_to_create_breakpoint_request___VM_disconnected__1, null);
        return null;
    }

    @Override
    protected void setRequestThreadFilter(EventRequest request, ThreadReference thread) {
        ((BreakpointRequest)request).addThreadFilter(thread);
    }

    protected List<Location> determineLocations(int lineNumber, ReferenceType type, JDIDebugTarget target) {
        List<Location> locations = null;
        try {
            locations = type.locationsOfLine("Java", null, lineNumber);
        }
        catch (AbsentInformationException absentInformationException) {
            if ((type.modifiers() & 0xF0001000) != 0 || type instanceof InterfaceType) {
                return null;
            }
            Status status = new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 162, JDIDebugBreakpointMessages.JavaLineBreakpoint_Absent_Line_Number_Information_1, null);
            IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
            if (handler != null) {
                try {
                    handler.handleStatus((IStatus)status, (Object)type);
                }
                catch (CoreException coreException) {}
            }
            return null;
        }
        catch (NativeMethodException nativeMethodException) {
            return null;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return null;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            return null;
        }
        catch (RuntimeException e) {
            target.internalError(e);
            return null;
        }
        return locations;
    }

    public void addLineBreakpointAttributes(Map<String, Object> attributes, String modelIdentifier, boolean enabled, int lineNumber, int charStart, int charEnd) {
        attributes.put("org.eclipse.debug.core.id", modelIdentifier);
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put("lineNumber", new Integer(lineNumber));
        attributes.put("charStart", new Integer(charStart));
        attributes.put("charEnd", new Integer(charEnd));
    }

    public void addTypeNameAndHitCount(Map<String, Object> attributes, String typeName, int hitCount) {
        attributes.put("org.eclipse.jdt.debug.core.typeName", typeName);
        if (hitCount > 0) {
            attributes.put("org.eclipse.jdt.debug.core.hitCount", new Integer(hitCount));
            attributes.put("org.eclipse.jdt.debug.core.expired", Boolean.FALSE);
        }
    }

    public boolean hasCondition() {
        try {
            String condition = this.getCondition();
            return this.isConditionEnabled() && condition != null && condition.length() > 0;
        }
        catch (CoreException exception) {
            JDIDebugPlugin.log(exception);
            return false;
        }
    }

    protected boolean suspendForEvent(Event event, JDIThread thread, boolean suspendVote) {
        this.expireHitCount(event);
        return this.suspend(thread, suspendVote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IJavaProject getJavaProject(IJavaStackFrame stackFrame) {
        Map<IJavaStackFrame, IJavaProject> map = this.fProjectsByFrame;
        synchronized (map) {
            IJavaProject project = this.fProjectsByFrame.get(stackFrame);
            if (project == null && (project = JavaDebugUtils.resolveJavaProject(stackFrame)) != null) {
                this.fProjectsByFrame.put(stackFrame, project);
            }
            return project;
        }
    }

    @Override
    public boolean supportsCondition() {
        return true;
    }

    @Override
    public String getCondition() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION, null);
    }

    @Override
    public void setCondition(String condition) throws CoreException {
        this.fCompiledExpressions.clear();
        this.fConditionValues.clear();
        this.fSuspendEvents.clear();
        if (condition != null && condition.trim().length() == 0) {
            condition = null;
        }
        this.setAttributes(new String[]{CONDITION}, new Object[]{condition});
        this.recreate();
    }

    protected String getMarkerMessage(boolean conditionEnabled, String condition, int hitCount, int suspendPolicy, int lineNumber) {
        StringBuffer message = new StringBuffer(super.getMarkerMessage(hitCount, suspendPolicy));
        if (lineNumber != -1) {
            message.append(MessageFormat.format((String)JDIDebugBreakpointMessages.JavaLineBreakpoint___line___0___1, (Object[])new Object[]{Integer.toString(lineNumber)}));
        }
        if (conditionEnabled && condition != null) {
            message.append(MessageFormat.format((String)JDIDebugBreakpointMessages.JavaLineBreakpoint___Condition___0___2, (Object[])new Object[]{condition}));
        }
        return message.toString();
    }

    @Override
    public boolean isConditionEnabled() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION_ENABLED, false);
    }

    @Override
    public void setConditionEnabled(boolean conditionEnabled) throws CoreException {
        this.setAttributes(new String[]{CONDITION_ENABLED}, new Object[]{conditionEnabled});
        this.recreate();
    }

    @Override
    protected void cleanupForThreadTermination(JDIThread thread) {
        this.fSuspendEvents.remove(thread);
        this.fCompiledExpressions.remove(thread);
        super.cleanupForThreadTermination(thread);
    }

    @Override
    protected void addInstanceFilter(EventRequest request, ObjectReference object) {
        if (request instanceof BreakpointRequest) {
            ((BreakpointRequest)request).addInstanceFilter(object);
        }
    }

    @Override
    public boolean isConditionSuspendOnTrue() throws DebugException {
        return this.ensureMarker().getAttribute(CONDITION_SUSPEND_ON_TRUE, true);
    }

    @Override
    public void setConditionSuspendOnTrue(boolean suspendOnTrue) throws CoreException {
        if (this.isConditionSuspendOnTrue() != suspendOnTrue) {
            this.setAttributes(new String[]{CONDITION_SUSPEND_ON_TRUE}, new Object[]{suspendOnTrue});
            this.fConditionValues.clear();
            this.recreate();
        }
    }

    protected ICompiledExpression getExpression(IJavaThread thread) {
        return this.fCompiledExpressions.get(thread);
    }

    protected void setExpression(IJavaThread thread, ICompiledExpression expression) {
        this.fCompiledExpressions.put(thread, expression);
    }

    protected IValue setCurrentConditionValue(IDebugTarget target, IValue value) {
        IValue prev = this.fConditionValues.get(target);
        this.fConditionValues.put(target, value);
        return prev;
    }
}

