/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.recommenders.internal.models.rcp.LogMessages;
import org.eclipse.recommenders.models.IProjectCoordinateAdvisor;
import org.eclipse.recommenders.utils.Logs;

public class AdvisorDescriptor {
    private final IConfigurationElement config;
    private boolean enabled;

    public AdvisorDescriptor(AdvisorDescriptor that) {
        this(that.config, that.enabled);
    }

    public AdvisorDescriptor(IConfigurationElement config, boolean enabled) {
        this.config = config;
        this.enabled = enabled;
    }

    public String getId() {
        return this.config.getAttribute("id");
    }

    public String getName() {
        return this.config.getAttribute("name");
    }

    public String getDescription() {
        return this.config.getAttribute("description");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public IProjectCoordinateAdvisor createAdvisor() throws CoreException {
        try {
            return (IProjectCoordinateAdvisor)this.config.createExecutableExtension("class");
        }
        catch (CoreException e) {
            String pluginId = this.config.getContributor().getName();
            Logs.log((Logs.ILogMessage)LogMessages.ADVISOR_INSTANTIATION_FAILED, (Throwable)e, (Object[])new Object[]{pluginId, this.config.getAttribute("class")});
            throw e;
        }
    }
}

