/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.recommenders.internal.models.rcp.Dependencies;
import org.eclipse.recommenders.models.DependencyInfo;
import org.eclipse.recommenders.models.DependencyType;
import org.eclipse.recommenders.models.IDependencyListener;
import org.eclipse.recommenders.rcp.JavaModelEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseDependencyListener
implements IDependencyListener {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseDependencyListener.class);
    private final HashMultimap<DependencyInfo, DependencyInfo> workspaceDependenciesByProject = HashMultimap.create();
    private final HashMultimap<DependencyInfo, IPackageFragmentRoot> jrePackageFragmentRoots = HashMultimap.create();
    private final Map<IJavaProject, DependencyInfo> projectDependencyInfos = Maps.newHashMap();

    public EclipseDependencyListener(EventBus bus) {
        bus.register((Object)this);
        this.parseWorkspaceForDependencies();
    }

    private void parseWorkspaceForDependencies() {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    this.registerDependenciesForJavaProject(javaProject);
                }
            }
            catch (CoreException e) {
                LOG.error("Failed to register dependencies for project {}", (Object)project, (Object)e);
            }
            ++n2;
        }
    }

    @Subscribe
    public void onEvent(JavaModelEvents.JavaProjectOpened e) {
        this.registerDependenciesForJavaProject(e.project);
    }

    @Subscribe
    public void onEvent(JavaModelEvents.JavaProjectClosed e) {
        this.deregisterDependenciesForJavaProject(e.project);
    }

    @Subscribe
    public void onEvent(JavaModelEvents.JarPackageFragmentRootAdded e) {
        this.registerDependencyForJAR(e.root);
    }

    @Subscribe
    public void onEvent(JavaModelEvents.JarPackageFragmentRootRemoved e) {
        this.deregisterDependencyForJAR(e.root);
    }

    private void registerDependenciesForJavaProject(IJavaProject javaProject) {
        DependencyInfo dependencyInfoForProject = this.getDependencyInfoForProject(javaProject);
        Optional<DependencyInfo> optionalJREDependencyInfo = Dependencies.createDependencyInfoForJre(javaProject);
        if (optionalJREDependencyInfo.isPresent()) {
            this.workspaceDependenciesByProject.put((Object)dependencyInfoForProject, (Object)((DependencyInfo)optionalJREDependencyInfo.get()));
            this.jrePackageFragmentRoots.putAll((Object)dependencyInfoForProject, EclipseDependencyListener.detectJREPackageFragementRoots(javaProject));
        }
        this.workspaceDependenciesByProject.putAll((Object)dependencyInfoForProject, this.searchForAllDependenciesOfProject(javaProject));
    }

    private Set<DependencyInfo> searchForAllDependenciesOfProject(IJavaProject javaProject) {
        HashSet dependencies = Sets.newHashSet();
        Set jreRoots = this.jrePackageFragmentRoots.get((Object)this.getDependencyInfoForProject(javaProject));
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                DependencyInfo dependencyInfo;
                IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                if (!jreRoots.contains(packageFragmentRoot) && packageFragmentRoot instanceof JarPackageFragmentRoot) {
                    dependencyInfo = Dependencies.createDependencyInfoForJar(packageFragmentRoot);
                    dependencies.add(dependencyInfo);
                } else if (packageFragmentRoot.getKind() == 1 && packageFragmentRoot.getJavaProject() != null) {
                    dependencyInfo = Dependencies.createDependencyInfoForProject(packageFragmentRoot.getJavaProject());
                    dependencies.add(dependencyInfo);
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LOG.error("Failed to search dependencies of project {}", (Object)javaProject, (Object)e);
        }
        return dependencies;
    }

    public static Set<IPackageFragmentRoot> detectJREPackageFragementRoots(IJavaProject javaProject) {
        HashSet<IPackageFragmentRoot> jreRoots = new HashSet<IPackageFragmentRoot>();
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5 && entry.getPath().toString().contains("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.findPackageFragmentRoots(entry);
                    int n3 = iPackageFragmentRootArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n4];
                        if (!packageFragmentRoot.getPath().toFile().getParentFile().getName().equals("ext")) {
                            jreRoots.add(packageFragmentRoot);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            LOG.error("Failed to detect JRE for project " + javaProject, (Throwable)e);
        }
        return jreRoots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterDependenciesForJavaProject(IJavaProject javaProject) {
        DependencyInfo dependencyInfoForProject = this.getDependencyInfoForProject(javaProject);
        this.workspaceDependenciesByProject.removeAll((Object)dependencyInfoForProject);
        this.jrePackageFragmentRoots.removeAll((Object)dependencyInfoForProject);
        Map<IJavaProject, DependencyInfo> map = this.projectDependencyInfos;
        synchronized (map) {
            this.projectDependencyInfos.remove(javaProject);
        }
    }

    private void registerDependencyForJAR(JarPackageFragmentRoot root) {
        Optional<IJavaProject> optionalJavaProject = this.getJavaProjectForPackageFragmentRoot((IPackageFragmentRoot)root);
        if (!optionalJavaProject.isPresent()) {
            return;
        }
        IJavaProject javaProject = (IJavaProject)optionalJavaProject.get();
        DependencyInfo dependencyInfoForProject = this.getDependencyInfoForProject(javaProject);
        if (!this.isJREOfProjectIsKnown(dependencyInfoForProject)) {
            this.workspaceDependenciesByProject.removeAll((Object)dependencyInfoForProject);
            this.registerDependenciesForJavaProject(javaProject);
        }
        if (!this.isPartOfTheJRE((IPackageFragmentRoot)root)) {
            DependencyInfo dependencyInfo = Dependencies.createDependencyInfoForJar((IPackageFragmentRoot)root);
            this.workspaceDependenciesByProject.put((Object)dependencyInfoForProject, (Object)dependencyInfo);
        }
    }

    private boolean isJREOfProjectIsKnown(DependencyInfo dependencyInfoForProject) {
        for (DependencyInfo dependencyInfo : this.workspaceDependenciesByProject.get((Object)dependencyInfoForProject)) {
            if (dependencyInfo.getType() != DependencyType.JRE) continue;
            return true;
        }
        return false;
    }

    private boolean isPartOfTheJRE(IPackageFragmentRoot pfr) {
        Optional<IJavaProject> optionalJavaProject = this.getJavaProjectForPackageFragmentRoot(pfr);
        return optionalJavaProject.isPresent() && this.jrePackageFragmentRoots.containsEntry((Object)Dependencies.createDependencyInfoForProject((IJavaProject)optionalJavaProject.get()), (Object)pfr);
    }

    private void deregisterDependencyForJAR(JarPackageFragmentRoot pfr) {
        Optional<IJavaProject> optionalJavaProject = this.getJavaProjectForPackageFragmentRoot((IPackageFragmentRoot)pfr);
        if (!optionalJavaProject.isPresent()) {
            return;
        }
        IJavaProject javaProject = (IJavaProject)optionalJavaProject.get();
        if (this.isPartOfTheJRE((IPackageFragmentRoot)pfr)) {
            this.deregisterJREDependenciesForProject(javaProject);
        } else {
            DependencyInfo dependencyInfo = Dependencies.createDependencyInfoForJar((IPackageFragmentRoot)pfr);
            DependencyInfo projectDependencyInfo = this.getDependencyInfoForProject(javaProject);
            this.workspaceDependenciesByProject.remove((Object)projectDependencyInfo, (Object)dependencyInfo);
            if (!this.workspaceDependenciesByProject.containsKey((Object)projectDependencyInfo)) {
                this.jrePackageFragmentRoots.removeAll((Object)projectDependencyInfo);
            }
        }
    }

    private void deregisterJREDependenciesForProject(IJavaProject javaProject) {
        DependencyInfo projectDependencyInfo = this.getDependencyInfoForProject(javaProject);
        for (DependencyInfo dependencyInfo : this.workspaceDependenciesByProject.get((Object)projectDependencyInfo)) {
            if (dependencyInfo.getType() != DependencyType.JRE) continue;
            this.workspaceDependenciesByProject.remove((Object)projectDependencyInfo, (Object)dependencyInfo);
            return;
        }
    }

    private Optional<IJavaProject> getJavaProjectForPackageFragmentRoot(IPackageFragmentRoot pfr) {
        IJavaProject parent = (IJavaProject)pfr.getAncestor(2);
        return Optional.fromNullable((Object)parent);
    }

    public ImmutableSet<DependencyInfo> getDependencies() {
        ImmutableSet.Builder res = ImmutableSet.builder();
        for (DependencyInfo javaProjects : this.workspaceDependenciesByProject.keySet()) {
            Set dependenciesForProject = this.workspaceDependenciesByProject.get((Object)javaProjects);
            res.addAll((Iterable)dependenciesForProject);
        }
        return res.build();
    }

    public ImmutableSet<DependencyInfo> getDependenciesForProject(DependencyInfo project) {
        Set infos = this.workspaceDependenciesByProject.get((Object)project);
        return ImmutableSet.copyOf((Collection)infos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DependencyInfo getDependencyInfoForProject(IJavaProject javaProject) {
        Map<IJavaProject, DependencyInfo> map = this.projectDependencyInfos;
        synchronized (map) {
            DependencyInfo dependencyInfo = this.projectDependencyInfos.get(javaProject);
            if (dependencyInfo == null) {
                dependencyInfo = Dependencies.createDependencyInfoForProject(javaProject);
                this.projectDependencyInfos.put(javaProject, dependencyInfo);
            }
            return dependencyInfo;
        }
    }

    public ImmutableSet<DependencyInfo> getProjects() {
        Set infos = this.workspaceDependenciesByProject.keySet();
        return ImmutableSet.copyOf((Collection)infos);
    }
}

