/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.base.Optional;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.recommenders.utils.LogMessages;
import org.eclipse.recommenders.utils.Logs;

public final class Reflections {
    private Reflections() {
        throw new IllegalStateException("Not meant to be instantiated");
    }

    public static Optional<Field> getDeclaredField(Class<?> declaringClass, String name) {
        if (declaringClass == null || name == null) {
            return Optional.absent();
        }
        try {
            Field field = declaringClass.getDeclaredField(name);
            field.setAccessible(true);
            return Optional.of((Object)field);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_REFLECTION_FAILED, e, name);
            return Optional.absent();
        }
    }

    public static Optional<Method> getDeclaredMethod(Class<?> declaringClass, String name, Class<?> ... parameterTypes) {
        if (declaringClass == null || name == null || parameterTypes == null) {
            return Optional.absent();
        }
        try {
            Method method = declaringClass.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            return Optional.of((Object)method);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_REFLECTION_FAILED, e, name);
            return Optional.absent();
        }
    }
}

