/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.ConversionException;
import org.mvel2.ConversionHandler;
import org.mvel2.conversion.Converter;

public class BigDecimalCH
implements ConversionHandler {
    private static final Map<Class, Converter> CNV = new HashMap<Class, Converter>();

    static {
        CNV.put(Object.class, new Converter(){

            public BigDecimal convert(Object o) {
                return new BigDecimal(String.valueOf(o), MathContext.DECIMAL128);
            }
        });
        CNV.put(BigDecimal.class, new Converter(){

            public BigDecimal convert(Object o) {
                return (BigDecimal)o;
            }
        });
        CNV.put(BigInteger.class, new Converter(){

            public BigDecimal convert(Object o) {
                return new BigDecimal(((BigInteger)o).doubleValue(), MathContext.DECIMAL128);
            }
        });
        CNV.put(String.class, new Converter(){

            public BigDecimal convert(Object o) {
                return new BigDecimal((String)o, MathContext.DECIMAL128);
            }
        });
        CNV.put(Double.class, new Converter(){

            public BigDecimal convert(Object o) {
                return new BigDecimal((Double)o, MathContext.DECIMAL128);
            }
        });
        CNV.put(Float.class, new Converter(){

            public BigDecimal convert(Object o) {
                return new BigDecimal(((Float)o).doubleValue(), MathContext.DECIMAL128);
            }
        });
        CNV.put(Short.class, new Converter(){

            public BigDecimal convert(Object o) {
                return new BigDecimal(((Short)o).doubleValue(), MathContext.DECIMAL128);
            }
        });
        CNV.put(Long.class, new Converter(){

            public BigDecimal convert(Object o) {
                return new BigDecimal(((Long)o).doubleValue(), MathContext.DECIMAL128);
            }
        });
        CNV.put(Integer.class, new Converter(){

            public BigDecimal convert(Object o) {
                return new BigDecimal(((Integer)o).doubleValue(), MathContext.DECIMAL128);
            }
        });
        CNV.put(String.class, new Converter(){

            public BigDecimal convert(Object o) {
                return new BigDecimal((String)o, MathContext.DECIMAL128);
            }
        });
        CNV.put(char[].class, new Converter(){

            public BigDecimal convert(Object o) {
                return new BigDecimal((char[])o, MathContext.DECIMAL128);
            }
        });
    }

    public Object convertFrom(Object in) {
        if (!CNV.containsKey(in.getClass())) {
            throw new ConversionException("cannot convert type: " + in.getClass().getName() + " to: " + Integer.class.getName());
        }
        return CNV.get(in.getClass()).convert(in);
    }

    public boolean canConvertFrom(Class cls) {
        return CNV.containsKey(cls);
    }
}

