/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.io.xdsl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.recommenders.internal.jayes.io.util.XMLUtil;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.io.IBayesNetWriter;

public class XDSLWriter
implements IBayesNetWriter {
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
    private static final String COMMENT = "<!--\n\t Bayesian Network in XDSL format \n-->\n";
    private final Writer out;

    public XDSLWriter(OutputStream out) {
        this.out = new OutputStreamWriter(out);
    }

    @Override
    public void write(BayesNet net) throws IOException {
        StringBuilder bldr = new StringBuilder();
        bldr.append(XML_HEADER);
        bldr.append(COMMENT);
        int offset = bldr.length();
        this.getVariableDefs(bldr, net);
        XMLUtil.surround(offset, bldr, "nodes", new String[0]);
        XMLUtil.surround(offset, bldr, "smile", "version", "1.0", "id", net.getName(), "numsamples", "1000", "discsamples", "10000");
        this.out.write(bldr.toString());
        this.out.flush();
    }

    private void getVariableDefs(StringBuilder bldr, BayesNet net) {
        for (BayesNode node : net.getNodes()) {
            int offset = bldr.length();
            this.encodeStates(bldr, node);
            this.encodeParents(bldr, node);
            bldr.append('\n');
            this.encodeProbabilities(bldr, node);
            XMLUtil.surround(offset, bldr, "cpt", "id", node.getName());
            bldr.append('\n');
        }
    }

    private void encodeStates(StringBuilder bldr, BayesNode node) {
        for (String outcome : node.getOutcomes()) {
            XMLUtil.emptyTag(bldr, "state", "id", StringEscapeUtils.escapeXml((String)outcome));
            bldr.append('\n');
        }
    }

    private void encodeParents(StringBuilder bldr, BayesNode node) {
        int offset = bldr.length();
        for (BayesNode p : node.getParents()) {
            bldr.append(p.getName().trim().replaceAll("\\s+", "_"));
            bldr.append(' ');
        }
        if (!node.getParents().isEmpty()) {
            bldr.deleteCharAt(bldr.length() - 1);
        }
        XMLUtil.surround(offset, bldr, "parents", new String[0]);
    }

    private void encodeProbabilities(StringBuilder bldr, BayesNode node) {
        if (node.getProbabilities().length == 0) {
            throw new IllegalArgumentException("Bayesian Network is broken: " + node.getName() + " has an empty conditional probability table");
        }
        int offset = bldr.length();
        double[] dArray = node.getProbabilities();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            bldr.append(d);
            bldr.append(' ');
            ++n2;
        }
        bldr.deleteCharAt(bldr.length() - 1);
        XMLUtil.surround(offset, bldr, "probabilities", new String[0]);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

