/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.apidocs;

import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;

public final class MethodSelfcallDirectives {
    public String _id;
    public String _rev;
    private final String providerId = this.getClass().getSimpleName();
    private IMethodName method;
    private int numberOfDefinitions;
    private Map<IMethodName, Integer> calls;

    public static MethodSelfcallDirectives create(IMethodName method, int numberOfDefinitions, Map<IMethodName, Integer> selfcalls) {
        MethodSelfcallDirectives res = new MethodSelfcallDirectives();
        res.method = method;
        res.numberOfDefinitions = numberOfDefinitions;
        res.calls = selfcalls;
        res.validate();
        return res;
    }

    public int getNumberOfDefinitions() {
        return this.numberOfDefinitions;
    }

    public Map<IMethodName, Integer> getCalls() {
        return this.calls;
    }

    public void validate() {
        Checks.ensureIsTrue((boolean)"MethodSelfcallDirectives".equals(this.providerId));
        Checks.ensureIsNotNull((Object)this.method);
        Checks.ensureIsGreaterOrEqualTo((double)this.numberOfDefinitions, (double)1.0, null);
        Checks.ensureIsFalse((boolean)this.calls.isEmpty(), (String)"empty self-calls not allowed.", (Object[])new Object[0]);
    }

    public IMethodName getMethod() {
        return this.method;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

