/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.ui;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class CodanEditorUtility {
    public static void openFileURL(String fileUrl, IResource markerResource) throws PartInitException, BadLocationException {
        String file = CodanEditorUtility.getFileFromURL(fileUrl);
        IEditorPart part = CodanEditorUtility.openInEditor(file, markerResource);
        int line = CodanEditorUtility.getLineFromURL(fileUrl);
        CodanEditorUtility.revealLine(part, line);
    }

    public static int getLineFromURL(String fileUrl) {
        String sline = fileUrl.replaceAll(".*#(\\d+)$", "$1");
        int line = -1;
        try {
            line = Integer.parseInt(sline);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return line;
    }

    public static String getFileFromURL(String link) {
        String file = link.replaceFirst("^file:", "");
        file = file.replaceAll("#\\d+$", "");
        return file;
    }

    public static void revealLine(IEditorPart part, int line) throws BadLocationException {
        if (line > 0 && part instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)part;
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)part.getEditorInput());
            textEditor.selectAndReveal(document.getLineOffset(line - 1), 0);
        }
    }

    public static IEditorPart openInEditor(String file, IResource markerResource) throws PartInitException {
        IFile efile = null;
        if (markerResource instanceof IFile) {
            efile = (IFile)markerResource;
        }
        if (efile != null) {
            IWorkbenchPage page = CodanEditorUtility.getActivePage();
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file);
            IEditorPart part = page.openEditor((IEditorInput)new FileEditorInput(efile), desc.getId());
            return part;
        }
        File fileToOpen = new File(file);
        if (fileToOpen.exists() && fileToOpen.isFile()) {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(fileToOpen.toURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                return IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            catch (PartInitException partInitException) {
                // empty catch block
            }
        }
        return null;
    }

    public static IEditorPart openInEditor(IMarker marker) throws PartInitException {
        String href = CodanEditorUtility.getLocationHRef(marker);
        String file = CodanEditorUtility.getFileFromURL(href);
        return CodanEditorUtility.openInEditor(file, marker.getResource());
    }

    public static String getLocationHRef(IMarker marker) {
        String loc = marker.getResource().getLocationURI().toString();
        String loc2 = marker.getAttribute("location", "");
        int line = marker.getAttribute("lineNumber", 0);
        if (loc2.length() > 0) {
            loc = "file:" + loc2.replaceAll("[^:]*: ", "");
        }
        String href = String.valueOf(loc) + "#" + line;
        return href;
    }

    public static String getLocation(IMarker marker) {
        String loc = marker.getResource().getFullPath().toPortableString();
        String loc2 = marker.getAttribute("location", "");
        int line = marker.getAttribute("lineNumber", 0);
        if (loc2.length() > 0) {
            loc = loc2.replaceAll("[^:]*: ", "");
        }
        return String.valueOf(loc) + ":" + line;
    }

    public static boolean isResourceOpenInEditor(IResource resource, IEditorPart editor) {
        if (editor == null) {
            return false;
        }
        IResource realResource = ResourceUtil.getResource((IEditorInput)editor.getEditorInput());
        return resource.equals((Object)realResource);
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage activePage = CodanEditorUtility.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart e = activePage.getActiveEditor();
        return e;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return null;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        return activePage;
    }
}

