/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.symbols;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.tracecompass.internal.tmf.core.callstack.FunctionNameMapper;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.symbols.BasicSymbolProvider;
import org.eclipse.tracecompass.internal.tmf.ui.symbols.MappingFile;
import org.eclipse.tracecompass.internal.tmf.ui.symbols.Messages;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.symbols.AbstractSymbolProviderPreferencePage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class BasicSymbolProviderPreferencePage
extends AbstractSymbolProviderPreferencePage {
    private static final ImageDescriptor BIN_ICON = BasicSymbolProviderPreferencePage.getImageDescriptor("icons/obj16/binary_mapping_file.gif");
    private static final ImageDescriptor TXT_ICON = BasicSymbolProviderPreferencePage.getImageDescriptor("icons/obj16/text_mapping_file.gif");
    private static final byte @NonNull [] ELF_HEADER = new byte[]{127, 69, 76, 70};
    private static final byte @NonNull [] MZ_HEADER = new byte[]{77, 90};
    private static final byte @NonNull [] COMPILED_JAVA_CLASS_HEADER = new byte[]{67, 65, 70, 69, 66, 65, 66, 69};
    private static final ImmutableList<byte[]> BINARY_HEADERS = ImmutableList.of((Object)ELF_HEADER, (Object)MZ_HEADER, (Object)COMPILED_JAVA_CLASS_HEADER);
    private BasicSymbolProvider fSymbolProvider;
    private Button fRemoveFile;
    private Button fPriorityUp;
    private Button fPriorityDown;
    private TableViewer fMappingTable;
    private final @NonNull List<@NonNull MappingFile> fMappingFiles = new ArrayList<MappingFile>();
    ColumnLabelProvider clp = new ColumnLabelProvider(){

        public String getText(Object element) {
            if (element instanceof MappingFile) {
                return ((MappingFile)element).getFullPath();
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof MappingFile) {
                Image txtImage;
                ImageRegistry registry = Activator.getDefault().getImageRegistry();
                Image binImage = registry.get(BIN_ICON.toString());
                if (binImage == null) {
                    registry.put(BIN_ICON.toString(), BIN_ICON);
                    binImage = registry.get(BIN_ICON.toString());
                }
                if ((txtImage = registry.get(TXT_ICON.toString())) == null) {
                    registry.put(TXT_ICON.toString(), TXT_ICON);
                    txtImage = registry.get(TXT_ICON.toString());
                }
                return ((MappingFile)element).isBinaryFile() ? binImage : txtImage;
            }
            return null;
        }
    };

    public BasicSymbolProviderPreferencePage(@NonNull BasicSymbolProvider provider) {
        super(provider);
        this.fSymbolProvider = provider;
        this.setDescription(MessageFormat.format(Messages.BasicSymbolProviderPrefPage_description, provider.getTrace().getName()));
        this.setValid(true);
        this.setTitle(MessageFormat.format(Messages.BasicSymbolProviderPrefPage_tabTitle, provider.getTrace().getName()));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.fMappingTable = new TableViewer(composite, 2818);
        this.fMappingTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        final Table table = this.fMappingTable.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(false);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionCount = table.getSelectionCount();
                boolean enablePriorityButtons = table.getItemCount() >= 2 && selectionCount == 1;
                BasicSymbolProviderPreferencePage.this.fPriorityUp.setEnabled(enablePriorityButtons);
                BasicSymbolProviderPreferencePage.this.fPriorityDown.setEnabled(enablePriorityButtons);
                BasicSymbolProviderPreferencePage.this.fRemoveFile.setEnabled(selectionCount >= 1);
            }
        });
        TableViewerColumn col = new TableViewerColumn(this.fMappingTable, 0);
        col.setLabelProvider((CellLabelProvider)this.clp);
        this.fMappingFiles.addAll(this.fSymbolProvider.getMappingFiles());
        this.fMappingTable.setInput(this.fMappingFiles);
        col.getColumn().pack();
        Composite buttonContainer = new Composite(composite, 0);
        buttonContainer.setLayout((Layout)new GridLayout());
        buttonContainer.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        Button fAddFile = new Button(buttonContainer, 0);
        fAddFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        fAddFile.setText(Messages.BasicSymbolProviderPrefPage_addFile_text);
        fAddFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = TmfFileDialogFactory.create(Display.getCurrent().getActiveShell(), 4098);
                dialog.open();
                BasicSymbolProviderPreferencePage.this.addSelectedMappingFiles(dialog.getFilterPath(), dialog.getFileNames());
            }
        });
        this.fRemoveFile = new Button(buttonContainer, 0);
        this.fRemoveFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fRemoveFile.setText(Messages.BasicSymbolProviderPrefPage_removeFile_text);
        this.fRemoveFile.setEnabled(false);
        this.fRemoveFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indices = BasicSymbolProviderPreferencePage.this.fMappingTable.getTable().getSelectionIndices();
                ArrayUtils.reverse((int[])indices);
                int[] nArray = indices;
                int n = indices.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    BasicSymbolProviderPreferencePage.this.fMappingFiles.remove(index);
                    ++n2;
                }
                BasicSymbolProviderPreferencePage.this.fMappingTable.refresh();
                BasicSymbolProviderPreferencePage.this.fPriorityUp.setEnabled(false);
                BasicSymbolProviderPreferencePage.this.fPriorityDown.setEnabled(false);
                BasicSymbolProviderPreferencePage.this.fRemoveFile.setEnabled(false);
            }
        });
        Composite priorityContainer = new Composite(buttonContainer, 0);
        GridLayout priorityContainerLayout = new GridLayout();
        priorityContainerLayout.marginTop = 5;
        priorityContainer.setLayout((Layout)priorityContainerLayout);
        priorityContainer.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.fPriorityUp = new Button(buttonContainer, 0);
        this.fPriorityUp.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fPriorityUp.setText(Messages.BasicSymbolProviderPrefPage_priorityUp_text);
        this.fPriorityUp.setToolTipText(Messages.BasicSymbolProviderPrefPage_priorityUp_tooltip);
        this.fPriorityUp.setEnabled(false);
        this.fPriorityUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = BasicSymbolProviderPreferencePage.this.fMappingTable.getTable().getSelectionIndex();
                if (index > 0) {
                    Collections.swap(BasicSymbolProviderPreferencePage.this.fMappingFiles, index, index - 1);
                    BasicSymbolProviderPreferencePage.this.fMappingTable.refresh();
                }
            }
        });
        this.fPriorityDown = new Button(buttonContainer, 0);
        this.fPriorityDown.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fPriorityDown.setText(Messages.BasicSymbolProviderPrefPage_priorityDown_text);
        this.fPriorityDown.setToolTipText(Messages.BasicSymbolProviderPrefPage_priorityDown_tooltip);
        this.fPriorityDown.setEnabled(false);
        this.fPriorityDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = table.getSelectionIndex();
                if (index < table.getItemCount() - 1) {
                    Collections.swap(BasicSymbolProviderPreferencePage.this.fMappingFiles, index, index + 1);
                    BasicSymbolProviderPreferencePage.this.fMappingTable.refresh();
                }
            }
        });
        return composite;
    }

    @Override
    public void saveConfiguration() {
        this.fSymbolProvider.setMappingFiles(this.fMappingFiles);
    }

    private static ImageDescriptor getImageDescriptor(String file) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tracecompass.tmf.ui", (String)file);
    }

    private void addSelectedMappingFiles(String filterPath, String[] fileNames) {
        ArrayList<String> invalidFiles = new ArrayList<String>();
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            String fullPath = String.valueOf(filterPath) + File.separator + fileName;
            File file = new File(fullPath);
            Map results = null;
            boolean isBinaryFile = BasicSymbolProviderPreferencePage.isBinaryFile(fullPath);
            results = isBinaryFile ? FunctionNameMapper.mapFromBinaryFile((File)file) : FunctionNameMapper.mapFromNmTextFile((File)file);
            if (results != null) {
                MappingFile mf = new MappingFile(file.getAbsolutePath(), isBinaryFile, results);
                if (!this.fMappingFiles.contains(mf)) {
                    this.fMappingFiles.add(mf);
                }
            } else {
                invalidFiles.add(fullPath);
            }
            ++n2;
        }
        if (!invalidFiles.isEmpty()) {
            this.displayErrorMessage(invalidFiles);
        }
        this.fMappingTable.refresh();
    }

    private static boolean isBinaryFile(String fullPath) {
        byte[] firstBytes = new byte[8];
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (FileInputStream input = new FileInputStream(fullPath);){
                input.read(firstBytes);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (byte[] header : BINARY_HEADERS) {
            if (firstBytes.length < header.length || !BasicSymbolProviderPreferencePage.startsWith(header, firstBytes)) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWith(byte[] a, byte[] b) {
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void displayErrorMessage(@NonNull List<String> invalidFiles) {
        StringBuilder errorMessageContent = new StringBuilder();
        errorMessageContent.append(System.lineSeparator()).append(System.lineSeparator());
        invalidFiles.forEach(file -> {
            StringBuilder stringBuilder2 = errorMessageContent.append("\u2022  ").append((String)file).append(System.lineSeparator());
        });
        MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.BasicSymbolProviderPrefPage_invalidMappingFileDialogHeader, (String)(String.valueOf(Messages.BasicSymbolProviderPrefPage_invalidMappingFileMessage) + errorMessageContent.toString()));
    }
}

