/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tools.templates.ui.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tools.templates.ui.internal.Tag;
import org.eclipse.tools.templates.ui.internal.TemplateExtension;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Template {
    private final TemplateExtension parent;
    private final IConfigurationElement element;
    private Map<String, Tag> tags;

    public Template(TemplateExtension parent, IConfigurationElement element) {
        this.parent = parent;
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getLabel() {
        return this.element.getAttribute("label");
    }

    public String getDescription() {
        IConfigurationElement[] descs = this.element.getChildren("description");
        return descs.length > 0 ? descs[0].getValue() : null;
    }

    public ImageDescriptor getIcon() {
        String iconPath = this.element.getAttribute("icon");
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)this.element.getNamespaceIdentifier(), (String)iconPath);
    }

    private void initTags() {
        if (this.tags == null) {
            this.tags = new HashMap<String, Tag>();
            IConfigurationElement[] iConfigurationElementArray = this.element.getChildren("tagReference");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ref = iConfigurationElementArray[n2];
                String id = ref.getAttribute("id");
                Tag tag = this.parent.getTag(id);
                if (tag != null) {
                    this.tags.put(tag.getId(), tag);
                }
                ++n2;
            }
        }
    }

    public void addTag(Tag tag) {
        this.initTags();
        this.tags.put(tag.getId(), tag);
    }

    public boolean hasTag(String tagId) {
        if (tagId.equals("all")) {
            return true;
        }
        this.initTags();
        return this.tags.containsKey(tagId);
    }

    public Collection<Tag> getTags() {
        return this.tags.values();
    }

    public IWorkbenchWizard getWizard() throws CoreException {
        return (IWorkbenchWizard)this.element.createExecutableExtension("wizard");
    }
}

