/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.ui.views.vm.vcpuview;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.module.VirtualMachineCpuAnalysis;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.trace.VirtualMachineExperiment;
import org.eclipse.tracecompass.internal.lttng2.kernel.ui.Activator;
import org.eclipse.tracecompass.internal.lttng2.kernel.ui.views.vm.vcpuview.Messages;
import org.eclipse.tracecompass.internal.lttng2.kernel.ui.views.vm.vcpuview.VirtualMachineCommon;
import org.eclipse.tracecompass.internal.lttng2.kernel.ui.views.vm.vcpuview.VirtualMachinePresentationProvider;
import org.eclipse.tracecompass.internal.lttng2.kernel.ui.views.vm.vcpuview.VirtualMachineViewEntry;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperimentUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class VirtualMachineView
extends AbstractTimeGraphView {
    public static final String ID = "org.eclipse.tracecompass.lttng2.analysis.vm.ui.vmview";
    private static final String[] COLUMN_NAMES = new String[]{Messages.VmView_stateTypeName};
    private static final String[] FILTER_COLUMN_NAMES = new String[]{Messages.VmView_stateTypeName};
    private static final long BUILD_UPDATE_TIMEOUT = 500L;
    private static final int[] DEFAULT_WEIGHT = new int[]{1, 3};
    private Comparator<ITimeGraphEntry> fComparator = VirtualMachineViewEntry.getComparator();

    public VirtualMachineView() {
        super(ID, (TimeGraphPresentationProvider)new VirtualMachinePresentationProvider());
        this.setFilterColumns(FILTER_COLUMN_NAMES);
        this.setTreeColumns(COLUMN_NAMES);
        this.setTreeLabelProvider(new VmViewTreeLabelProvider());
        this.setWeight(DEFAULT_WEIGHT);
        this.setAutoExpandLevel(2);
    }

    protected @Nullable String getNextText() {
        return Messages.VmView_nextResourceActionNameText;
    }

    protected @Nullable String getNextTooltip() {
        return Messages.VmView_nextResourceActionToolTipText;
    }

    protected @Nullable String getPrevText() {
        return Messages.VmView_previousResourceActionNameText;
    }

    protected @Nullable String getPrevTooltip() {
        return Messages.VmView_previousResourceActionToolTipText;
    }

    protected void buildEntryList(ITmfTrace trace, ITmfTrace parentTrace, IProgressMonitor monitor) {
        this.setStartTime(Long.MAX_VALUE);
        this.setEndTime(Long.MIN_VALUE);
        if (!(parentTrace instanceof VirtualMachineExperiment)) {
            return;
        }
        ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)parentTrace, (String)"org.eclipse.tracecompass.lttng2.analysis.vm.core.VirtualMachineAnalysisModule");
        if (ssq == null) {
            return;
        }
        VirtualMachineExperiment vmExperiment = (VirtualMachineExperiment)parentTrace;
        long startTime = ssq.getStartTime();
        ArrayList<VirtualMachineViewEntry> entryList = new ArrayList<VirtualMachineViewEntry>();
        HashMap<String, VirtualMachineViewEntry> entryMap = new HashMap<String, VirtualMachineViewEntry>();
        boolean complete = false;
        VirtualMachineViewEntry groupEntry = new VirtualMachineViewEntry.VmEntryBuilder(vmExperiment.getName(), startTime, startTime, vmExperiment).build();
        entryList.add(groupEntry);
        this.putEntryList(parentTrace, new ArrayList(entryList));
        while (!complete) {
            if (monitor.isCanceled()) {
                return;
            }
            complete = ssq.waitUntilBuilt(500L);
            if (ssq.isCancelled()) {
                return;
            }
            long currentEndTime = ssq.getCurrentEndTime();
            long endTime = currentEndTime + 1L;
            groupEntry.updateEndTime(endTime);
            this.setStartTime(Math.min(this.getStartTime(), startTime));
            this.setEndTime(Math.max(this.getEndTime(), currentEndTime));
            this.buildEntries(ssq, startTime, endTime, groupEntry, entryMap, vmExperiment);
            if (parentTrace.equals(this.getTrace())) {
                this.refresh();
            }
            this.buildEntryEventLists(entryList, ssq, startTime, endTime, monitor);
        }
    }

    private void buildEntries(ITmfStateSystem ssq, long startTime, long endTime, VirtualMachineViewEntry groupEntry, Map<@NonNull String, @NonNull VirtualMachineViewEntry> entryMap, VirtualMachineExperiment vmExperiment) {
        try {
            List vmQuarks = ssq.getQuarks(new String[]{"Virtual Machines", "*"});
            for (Integer vmQuark : vmQuarks) {
                VirtualMachineViewEntry vmEntry;
                String vmHostId = ssq.getAttributeName(vmQuark.intValue());
                ITmfStateInterval vmNameInterval = StateSystemUtils.queryUntilNonNullValue((ITmfStateSystem)ssq, (int)vmQuark, (long)startTime, (long)endTime);
                String vmName = vmHostId;
                if (vmNameInterval != null) {
                    vmName = vmNameInterval.getStateValue().unboxStr();
                }
                if ((vmEntry = entryMap.get(vmHostId)) == null) {
                    vmEntry = new VirtualMachineViewEntry.VmEntryBuilder(vmName, startTime, endTime, vmExperiment).setId(vmHostId).setVmName(vmName).setNumericId(vmQuark).setType(VirtualMachineCommon.Type.VM).build();
                    vmEntry.sortChildren(this.fComparator);
                    groupEntry.addChild(vmEntry);
                    entryMap.put(vmHostId, vmEntry);
                } else {
                    vmEntry.updateEndTime(endTime);
                }
                for (Integer vCpuQuark : ssq.getSubAttributes(vmQuark.intValue(), false)) {
                    String vcpuId = ssq.getAttributeName(vCpuQuark.intValue());
                    VirtualMachineViewEntry vcpuEntry = entryMap.get(String.valueOf(vmHostId) + vcpuId);
                    if (vcpuEntry == null) {
                        vcpuEntry = new VirtualMachineViewEntry.VmEntryBuilder(vcpuId, startTime, endTime, vmExperiment).setId(vcpuId).setVmName(vmName).setNumericId(vCpuQuark).setType(VirtualMachineCommon.Type.VCPU).build();
                        vmEntry.addChild(vcpuEntry);
                        entryMap.put(String.valueOf(vmHostId) + vcpuId, vcpuEntry);
                        continue;
                    }
                    vcpuEntry.updateEndTime(endTime);
                }
                VirtualMachineView.buildThreadEntries(vmEntry, entryMap, startTime, endTime);
            }
        }
        catch (StateValueTypeException | TimeRangeException e) {
            Activator.getDefault().logError("VirtualMachineView: error building event list", e);
        }
    }

    private static void buildThreadEntries(VirtualMachineViewEntry vmEntry, Map<String, VirtualMachineViewEntry> entryMap, long startTime, long endTime) {
        String vmHostId = vmEntry.getId();
        VirtualMachineExperiment vmExperiment = vmEntry.getExperiment();
        KernelAnalysisModule kernelModule = (KernelAnalysisModule)TmfExperimentUtils.getAnalysisModuleOfClassForHost((TmfExperiment)vmExperiment, (String)vmHostId, KernelAnalysisModule.class);
        if (kernelModule == null) {
            return;
        }
        VirtualMachineViewEntry threadEntry = entryMap.get(String.valueOf(vmHostId) + NonNullUtils.nullToEmptyString((Object)Messages.VmView_threads));
        if (threadEntry == null) {
            threadEntry = new VirtualMachineViewEntry.VmEntryBuilder(NonNullUtils.nullToEmptyString((Object)Messages.VmView_threads), startTime, endTime, vmExperiment).build();
            entryMap.put(String.valueOf(vmHostId) + NonNullUtils.nullToEmptyString((Object)Messages.VmView_threads), threadEntry);
            vmEntry.addChild(threadEntry);
        } else {
            threadEntry.updateEndTime(endTime);
        }
        String vmName = vmEntry.getVmName();
        if (vmName == null) {
            return;
        }
        Collection threadIds = KernelThreadInformationProvider.getThreadIds((KernelAnalysisModule)kernelModule);
        for (Integer threadId : threadIds) {
            if (threadId == -1) continue;
            VirtualMachineViewEntry oneThreadEntry = entryMap.get(String.valueOf(vmHostId) + ':' + threadId);
            if (oneThreadEntry != null) {
                oneThreadEntry.updateEndTime(endTime);
                continue;
            }
            String threadName = KernelThreadInformationProvider.getExecutableName((KernelAnalysisModule)kernelModule, (Integer)threadId);
            String tidString = threadId.toString();
            threadName = threadName != null ? String.valueOf(tidString) + ':' + ' ' + threadName : tidString;
            oneThreadEntry = new VirtualMachineViewEntry.VmEntryBuilder(threadName, startTime, endTime, vmExperiment).setId(threadName).setVmName(vmName).setNumericId(threadId).setType(VirtualMachineCommon.Type.THREAD).build();
            threadEntry.addChild(oneThreadEntry);
            entryMap.put(String.valueOf(vmHostId) + ':' + threadId, oneThreadEntry);
        }
    }

    private void buildEntryEventLists(List<@NonNull VirtualMachineViewEntry> entryList, ITmfStateSystem ssq, long startTime, long endTime, IProgressMonitor monitor) {
        for (VirtualMachineViewEntry entry : entryList) {
            if (monitor.isCanceled()) {
                return;
            }
            this.buildEntryEventList(entry, ssq, startTime, endTime, monitor);
        }
    }

    private void buildEntryEventList(TimeGraphEntry entry, ITmfStateSystem ssq, long start, long end, IProgressMonitor monitor) {
        if (start < entry.getEndTime() && end > entry.getStartTime()) {
            long startTime = Math.max(start, entry.getStartTime());
            long endTime = Math.min(end + 1L, entry.getEndTime());
            long resolution = Math.max(1L, (end - ssq.getStartTime()) / (long)this.getDisplayWidth());
            List<ITimeEvent> eventList = this.getEventList(entry, startTime, endTime, resolution, monitor);
            entry.setEventList(eventList);
            this.redraw();
            for (TimeGraphEntry child : entry.getChildren()) {
                if (monitor.isCanceled()) {
                    return;
                }
                this.buildEntryEventList(child, ssq, start, end, monitor);
            }
        }
    }

    protected @Nullable List<ITimeEvent> getEventList(TimeGraphEntry entry, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        if (!(entry instanceof VirtualMachineViewEntry)) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        VirtualMachineViewEntry vmEntry = (VirtualMachineViewEntry)entry;
        switch (vmEntry.getType()) {
            case THREAD: {
                return VirtualMachineView.getThreadEventList(vmEntry, endTime, monitor);
            }
            case VCPU: {
                return VirtualMachineView.getVcpuEventList(vmEntry, startTime, endTime, resolution, monitor);
            }
            case VM: {
                VirtualMachineExperiment experiment = vmEntry.getExperiment();
                VirtualMachineCpuAnalysis vmAnalysis = (VirtualMachineCpuAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)experiment, VirtualMachineCpuAnalysis.class, (String)"org.eclipse.tracecompass.lttng2.analysis.vm.core.VirtualMachineAnalysisModule");
                if (vmAnalysis == null) break;
                Multimap updatedThreadIntervals = vmAnalysis.getUpdatedThreadIntervals(vmEntry.getNumericId().intValue(), startTime, endTime, resolution, monitor);
                vmEntry.setThreadIntervals((Multimap<Integer, ITmfStateInterval>)updatedThreadIntervals);
                break;
            }
            case NULL: {
                break;
            }
        }
        return null;
    }

    private static @Nullable List<@NonNull ITimeEvent> getVcpuEventList(VirtualMachineViewEntry vmEntry, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        List<ITimeEvent> eventList = null;
        try {
            int quark = vmEntry.getNumericId();
            ITmfStateSystem ssq = TmfStateSystemAnalysisModule.getStateSystem((ITmfTrace)vmEntry.getExperiment(), (String)"org.eclipse.tracecompass.lttng2.analysis.vm.core.VirtualMachineAnalysisModule");
            if (ssq == null) {
                return Collections.EMPTY_LIST;
            }
            long realStart = Math.max(startTime, ssq.getStartTime());
            long realEnd = Math.min(endTime, ssq.getCurrentEndTime() + 1L);
            if (realEnd <= realStart) {
                return Collections.EMPTY_LIST;
            }
            quark = ssq.getQuarkRelative(quark, new String[]{"Status"});
            List statusIntervals = StateSystemUtils.queryHistoryRange((ITmfStateSystem)ssq, (int)quark, (long)realStart, (long)(realEnd - 1L), (long)resolution, (IProgressMonitor)monitor);
            eventList = VirtualMachineView.parseIntervalsForEvents(vmEntry, statusIntervals, endTime, monitor);
        }
        catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
            Activator.getDefault().logError("Error getting event list", e);
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {
            // empty catch block
        }
        return eventList;
    }

    private static @Nullable List<@NonNull ITimeEvent> getThreadEventList(VirtualMachineViewEntry vmEntry, long endTime, IProgressMonitor monitor) {
        List<ITimeEvent> eventList = null;
        Collection<ITmfStateInterval> threadIntervals = VirtualMachineView.getThreadIntervalsForEntry(vmEntry);
        if (threadIntervals != null) {
            eventList = VirtualMachineView.parseIntervalsForEvents(vmEntry, threadIntervals, endTime, monitor);
        }
        return eventList;
    }

    private static @Nullable List<@NonNull ITimeEvent> parseIntervalsForEvents(VirtualMachineViewEntry vmEntry, Collection<@NonNull ITmfStateInterval> intervals, long endTime, IProgressMonitor monitor) {
        ArrayList<ITimeEvent> eventList = new ArrayList<ITimeEvent>(intervals.size());
        long lastEndTime = -1L;
        for (ITmfStateInterval interval : intervals) {
            if (monitor.isCanceled()) {
                return null;
            }
            long time = interval.getStartTime();
            long duration = interval.getEndTime() - time + 1L;
            if (!interval.getStateValue().isNull()) {
                int status = interval.getStateValue().unboxInt();
                if (lastEndTime != time && lastEndTime != -1L) {
                    eventList.add((ITimeEvent)new TimeEvent((ITimeGraphEntry)vmEntry, lastEndTime, time - lastEndTime));
                }
                eventList.add((ITimeEvent)new TimeEvent((ITimeGraphEntry)vmEntry, time, duration, status));
            } else if (lastEndTime == -1L || time + duration >= endTime) {
                eventList.add((ITimeEvent)new NullTimeEvent((ITimeGraphEntry)vmEntry, time, duration));
            }
            lastEndTime = time + duration;
        }
        return eventList;
    }

    private static @Nullable Collection<@NonNull ITmfStateInterval> getThreadIntervalsForEntry(VirtualMachineViewEntry vmEntry) {
        Collection<ITmfStateInterval> threadIntervals = null;
        TimeGraphEntry parent = vmEntry.getParent();
        while (threadIntervals == null && parent != null) {
            if (parent instanceof VirtualMachineViewEntry) {
                threadIntervals = ((VirtualMachineViewEntry)parent).getThreadIntervals(vmEntry.getNumericId());
            }
            parent = parent.getParent();
        }
        return threadIntervals;
    }

    protected Iterable<ITmfTrace> getTracesToBuild(@Nullable ITmfTrace trace) {
        if (trace == null) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(trace);
    }

    private static class VmViewTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private VmViewTreeLabelProvider() {
        }

        public String getColumnText(@Nullable Object element, int columnIndex) {
            if (!(element instanceof VirtualMachineViewEntry)) {
                return "";
            }
            VirtualMachineViewEntry entry = (VirtualMachineViewEntry)((Object)element);
            if (COLUMN_NAMES[columnIndex].equals(Messages.VmView_stateTypeName)) {
                String name = entry.getName();
                return name == null ? "" : name;
            }
            return "";
        }
    }
}

