/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.parser;

import javax.xml.namespace.QName;
import org.apache.ws.commons.util.NamespaceContextImpl;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcExtensionException;
import org.apache.xmlrpc.common.XmlRpcStreamConfig;
import org.apache.xmlrpc.parser.TypeParser;
import org.apache.xmlrpc.parser.TypeParserImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class RecursiveTypeParserImpl
extends TypeParserImpl {
    private final NamespaceContextImpl context;
    protected final XmlRpcStreamConfig cfg;
    private final TypeFactory factory;
    private boolean inValueTag;
    private TypeParser typeParser;
    private String text;

    protected RecursiveTypeParserImpl(XmlRpcStreamConfig pConfig, NamespaceContextImpl pContext, TypeFactory pFactory) {
        this.cfg = pConfig;
        this.context = pContext;
        this.factory = pFactory;
    }

    protected void startValueTag() throws SAXException {
        this.inValueTag = true;
        this.text = null;
        this.typeParser = null;
    }

    protected abstract void addResult(Object var1) throws SAXException;

    protected void endValueTag() throws SAXException {
        if (this.inValueTag) {
            if (this.typeParser == null) {
                this.addResult(this.text == null ? "" : this.text);
                this.text = null;
            } else {
                this.typeParser.endDocument();
                try {
                    this.addResult(this.typeParser.getResult());
                }
                catch (XmlRpcException e) {
                    throw new SAXException(e);
                }
                this.typeParser = null;
            }
        } else {
            throw new SAXParseException("Invalid state: Not inside value tag.", this.getDocumentLocator());
        }
    }

    public void startDocument() throws SAXException {
        this.inValueTag = false;
        this.text = null;
        this.typeParser = null;
    }

    public void endElement(String pURI, String pLocalName, String pQName) throws SAXException {
        if (this.inValueTag) {
            if (this.typeParser == null) {
                throw new SAXParseException("Invalid state: No type parser configured.", this.getDocumentLocator());
            }
        } else {
            throw new SAXParseException("Invalid state: Not inside value tag.", this.getDocumentLocator());
        }
        this.typeParser.endElement(pURI, pLocalName, pQName);
    }

    public void startElement(String pURI, String pLocalName, String pQName, Attributes pAttrs) throws SAXException {
        if (this.inValueTag) {
            if (this.typeParser == null) {
                this.typeParser = this.factory.getParser(this.cfg, this.context, pURI, pLocalName);
                if (this.typeParser == null) {
                    if ("http://ws.apache.org/xmlrpc/namespaces/extensions".equals(pURI) && !this.cfg.isEnabledForExtensions()) {
                        String msg = "The tag " + new QName(pURI, pLocalName) + " is invalid, if isEnabledForExtensions() == false.";
                        throw new SAXParseException(msg, this.getDocumentLocator(), new XmlRpcExtensionException(msg));
                    }
                    throw new SAXParseException("Unknown type: " + new QName(pURI, pLocalName), this.getDocumentLocator());
                }
                this.typeParser.setDocumentLocator(this.getDocumentLocator());
                this.typeParser.startDocument();
                if (this.text != null) {
                    this.typeParser.characters(this.text.toCharArray(), 0, this.text.length());
                    this.text = null;
                }
            }
        } else {
            throw new SAXParseException("Invalid state: Not inside value tag.", this.getDocumentLocator());
        }
        this.typeParser.startElement(pURI, pLocalName, pQName, pAttrs);
    }

    public void characters(char[] pChars, int pOffset, int pLength) throws SAXException {
        if (this.typeParser == null) {
            if (this.inValueTag) {
                String s = new String(pChars, pOffset, pLength);
                this.text = this.text == null ? s : this.text + s;
            } else {
                super.characters(pChars, pOffset, pLength);
            }
        } else {
            this.typeParser.characters(pChars, pOffset, pLength);
        }
    }

    public void ignorableWhitespace(char[] pChars, int pOffset, int pLength) throws SAXException {
        if (this.typeParser == null) {
            if (this.inValueTag) {
                String s = new String(pChars, pOffset, pLength);
                this.text = this.text == null ? s : this.text + s;
            } else {
                super.ignorableWhitespace(pChars, pOffset, pLength);
            }
        } else {
            this.typeParser.ignorableWhitespace(pChars, pOffset, pLength);
        }
    }

    public void processingInstruction(String pTarget, String pData) throws SAXException {
        if (this.typeParser == null) {
            super.processingInstruction(pTarget, pData);
        } else {
            this.typeParser.processingInstruction(pTarget, pData);
        }
    }

    public void skippedEntity(String pEntity) throws SAXException {
        if (this.typeParser == null) {
            super.skippedEntity(pEntity);
        } else {
            this.typeParser.skippedEntity(pEntity);
        }
    }

    public void startPrefixMapping(String pPrefix, String pURI) throws SAXException {
        if (this.typeParser == null) {
            super.startPrefixMapping(pPrefix, pURI);
        } else {
            this.context.startPrefixMapping(pPrefix, pURI);
        }
    }

    public void endPrefixMapping(String pPrefix) throws SAXException {
        if (this.typeParser == null) {
            super.endPrefixMapping(pPrefix);
        } else {
            this.context.endPrefixMapping(pPrefix);
        }
    }
}

