/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.internal.mylyn.ui.commit;

import org.eclipse.egit.ui.IBranchNameProvider;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class ActiveTaskBranchNameProvider
implements IBranchNameProvider {
    protected ITask getCurrentTask() {
        return TasksUi.getTaskActivityManager().getActiveTask();
    }

    public String getBranchNameSuggestion() {
        ITask task = this.getCurrentTask();
        if (task == null) {
            return null;
        }
        String taskKey = task.getTaskKey();
        if (taskKey == null) {
            taskKey = task.getTaskId();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TasksUiInternal.getTaskPrefix((String)task.getConnectorKind()));
        sb.append(taskKey);
        sb.append('-');
        sb.append(task.getSummary());
        return this.normalizeBranchName(sb.toString());
    }

    private String normalizeBranchName(String name) {
        String normalized = Repository.normalizeBranchName((String)name);
        if (normalized != null && normalized.length() > 30) {
            normalized = Repository.normalizeBranchName((String)normalized.substring(0, 30));
        }
        return normalized;
    }
}

