/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.propertypages;

import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.ui.ISystemConnectionFormCaller;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemConnectionForm;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.rse.ui.validators.ISystemValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SystemConnectionPropertyPage
extends SystemBasePropertyPage
implements ISystemMessageLine,
ISystemConnectionFormCaller {
    protected SystemConnectionForm form = new SystemConnectionForm(this, this);
    protected String parentHelpId = "org.eclipse.rse.ui.pcon0000";

    protected Control createContentArea(Composite parent) {
        IHost conn = (IHost)this.getElement();
        this.form.initializeInputFields(conn);
        ISubSystem[] sses = conn.getSubSystems();
        boolean addEncodingFields = false;
        int i = 0;
        while (i < sses.length && !addEncodingFields) {
            ISubSystem ss = sses[i];
            addEncodingFields = ss.getSubSystemConfiguration().supportsEncoding(conn);
            ++i;
        }
        if (addEncodingFields) {
            this.form.addDefaultEncodingFields();
        }
        ISystemValidator[] connectionNameValidators = new ISystemValidator[]{SystemConnectionForm.getConnectionNameValidator(conn)};
        this.form.setConnectionNameValidators(connectionNameValidators);
        Control c = this.form.createContents(parent, true, this.parentHelpId);
        this.form.getInitialFocusControl().setFocus();
        SystemWidgetHelpers.setCompositeHelp(parent, this.parentHelpId);
        return c;
    }

    protected IHost getConnection() {
        return (IHost)this.getElement();
    }

    private boolean hasConnectionChanged(IHost conn) {
        return !this.compareStrings(conn.getName(), this.form.getConnectionName()) || !this.compareStrings(conn.getHostName(), this.form.getHostName()) || !this.compareStrings(conn.getDescription(), this.form.getConnectionDescription()) || !this.compareStrings(conn.getDefaultUserId(), this.form.getDefaultUserId());
    }

    private boolean compareStrings(String str1, String str2) {
        if (str1 == null || str1.length() == 0) {
            return str2 == null || str2.length() == 0;
        }
        return str2 == null || str2.length() == 0 ? false : str1.equals(str2);
    }

    public boolean performOk() {
        boolean okToClose = this.verifyPageContents();
        if (okToClose) {
            IHost conn = (IHost)this.getElement();
            ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
            if (this.hasConnectionChanged(conn)) {
                sr.updateHost(conn, conn.getSystemType(), this.form.getConnectionName(), this.form.getHostName(), this.form.getConnectionDescription(), this.form.getDefaultUserId(), this.form.getUserIdLocation());
            }
            String encoding = this.form.getDefaultEncoding();
            boolean isRemoteEncoding = this.form.isEncodingRemoteDefault();
            String currentEncoding = conn.getDefaultEncoding(false);
            if (!isRemoteEncoding && encoding != null && !encoding.equals(currentEncoding)) {
                conn.setDefaultEncoding(encoding, false);
            } else if (currentEncoding != null && !encoding.equals(currentEncoding)) {
                conn.setDefaultEncoding(null, false);
                conn.setDefaultEncoding(null, true);
            }
            boolean offlineSelection = this.form.isWorkOffline();
            if (offlineSelection != conn.isOffline()) {
                if (!offlineSelection) {
                    sr.setHostOffline(conn, false);
                } else {
                    sr.setHostOffline(conn, true);
                    ISubSystem[] subsystems = sr.getSubSystems(conn);
                    if (subsystems != null) {
                        boolean cancelled = false;
                        int i = 0;
                        while (i < subsystems.length && !cancelled) {
                            try {
                                subsystems[i].disconnect(false);
                            }
                            catch (InterruptedException interruptedException) {
                                cancelled = true;
                            }
                            catch (Exception e) {
                                SystemBasePlugin.logError("SystemConnectionPropertyPage.performOk", e);
                            }
                            ++i;
                        }
                    }
                    if (sr.isAnySubSystemConnected(conn) && !conn.getSystemType().isLocal()) {
                        sr.setHostOffline(conn, false);
                        okToClose = false;
                    }
                }
            }
        }
        return okToClose;
    }

    protected boolean verifyPageContents() {
        return this.form.verify(true);
    }

    public void systemTypeSelected(IRSESystemType systemType, boolean duringInitialization) {
    }
}

