/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.net;

import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.IProxyProvider;
import org.eclipse.mylyn.commons.net.WebUtil;

public class WebLocation
extends AbstractWebLocation {
    private final Map<AuthenticationType, AuthenticationCredentials> credentialsByType = new HashMap<AuthenticationType, AuthenticationCredentials>();
    private final IProxyProvider proxyProvider;

    public WebLocation(String url, String username, String password, IProxyProvider proxyProvider) {
        super(url);
        this.proxyProvider = proxyProvider;
        if (username != null && password != null) {
            this.setCredentials(AuthenticationType.REPOSITORY, username, password);
        }
    }

    public WebLocation(String url, String username, String password) {
        this(url, username, password, new PlatformProxyProvider());
    }

    public WebLocation(String url) {
        this(url, null, null, new PlatformProxyProvider());
    }

    @Override
    public AuthenticationCredentials getCredentials(AuthenticationType authType) {
        return this.credentialsByType.get((Object)authType);
    }

    @Override
    public Proxy getProxyForHost(String host, String proxyType) {
        if (this.proxyProvider != null) {
            return this.proxyProvider.getProxyForHost(host, proxyType);
        }
        return null;
    }

    public void setCredentials(AuthenticationType authType, String username, String password) {
        this.credentialsByType.put(authType, new AuthenticationCredentials(username, password));
    }

    private static class PlatformProxyProvider
    implements IProxyProvider {
        private PlatformProxyProvider() {
        }

        @Override
        public Proxy getProxyForHost(String host, String proxyType) {
            return WebUtil.getProxy(host, proxyType);
        }
    }
}

