/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.net.Inet4Address;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.core.util.NetworkMonitor;
import org.eclipse.php.internal.core.util.NetworkUtil;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.PHPDebugUtil;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.preferences.AbstractDebuggerConfigurationDialog;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.zend.communication.BroadcastDaemon;
import org.eclipse.php.internal.debug.core.zend.debugger.ConfigureHostsDialog;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerConfiguration;
import org.eclipse.php.internal.debug.daemon.communication.DaemonsRegistry;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class ZendDebuggerConfigurationDialog
extends AbstractDebuggerConfigurationDialog {
    protected ZendDebuggerConfiguration fDebuggerConfiguration;
    private Button fRunWithDebugInfo;
    private Text fDebugTextBox;
    private Text fClientIP;
    private Button fClientIPButton;
    private Text fDebugResponseTimeout;
    private Button fUseNewProtocol;
    private Button fAutoModeButton;
    private Button fManualModeButton;
    private Text fBroadcastPortText;
    private Text fDummyFileText;
    private Button fUseSSLButton;
    private NetworkMonitor fNetworkMonitor;
    private Composite fClientIpComposite;
    private Image fTitleImage;

    public ZendDebuggerConfigurationDialog(ZendDebuggerConfiguration zendDebuggerConfiguration, Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fDebuggerConfiguration = zendDebuggerConfiguration;
        this.fNetworkMonitor = new NetworkMonitor();
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        parent = (Composite)super.createDialogArea(parent);
        GridData ptGridData = (GridData)parent.getLayoutData();
        ptGridData.widthHint = this.convertWidthInCharsToPixels(120);
        this.getShell().setText(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Dialog_title);
        this.setTitle(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_zendDebuggerSettings);
        this.setMessage(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Dialog_description);
        this.fTitleImage = this.getDialogImage();
        if (this.fTitleImage != null) {
            this.setTitleImage(this.fTitleImage);
        }
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ZendDebuggerConfigurationDialog.this.fTitleImage != null) {
                    ZendDebuggerConfigurationDialog.this.fTitleImage.dispose();
                }
            }
        });
        Composite connectionSettingsGroup = this.createSubsection(parent, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Connection_settings_group);
        this.addLabelControl(connectionSettingsGroup, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_client_host_ip, PHPDebugCorePreferenceNames.CLIENT_IP);
        this.fAutoModeButton = new Button(connectionSettingsGroup, 16);
        this.fAutoModeButton.setText(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_AutoMode);
        this.fAutoModeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ZendDebuggerConfigurationDialog.this.fAutoModeButton.getSelection()) {
                    String value = DefaultScope.INSTANCE.getNode("org.eclipse.php.debug.core").get(PHPDebugCorePreferenceNames.CLIENT_IP, "127.0.0.1");
                    ZendDebuggerConfigurationDialog.this.fClientIP.setText(value);
                    ZendDebuggerConfigurationDialog.this.fClientIPButton.setText(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Reload);
                    ZendDebuggerConfigurationDialog.this.fClientIpComposite.layout(true);
                }
            }
        });
        this.fManualModeButton = new Button(connectionSettingsGroup, 16);
        this.fManualModeButton.setText(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_ManualMode);
        this.fManualModeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZendDebuggerConfigurationDialog.this.fClientIP.setEnabled(ZendDebuggerConfigurationDialog.this.fManualModeButton.getSelection());
                ZendDebuggerConfigurationDialog.this.fClientIPButton.setText(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Configure);
                ZendDebuggerConfigurationDialog.this.fClientIpComposite.layout(true);
            }
        });
        new Label(connectionSettingsGroup, 0);
        this.fClientIpComposite = new Composite(connectionSettingsGroup, 0);
        this.fClientIpComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        GridLayout cicLayout = new GridLayout(3, false);
        cicLayout.marginHeight = 0;
        cicLayout.marginWidth = 0;
        this.fClientIpComposite.setLayout((Layout)cicLayout);
        this.fClientIP = this.addTextField(this.fClientIpComposite, PHPDebugCorePreferenceNames.CLIENT_IP, 0, 1);
        this.fClientIP.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ZendDebuggerConfigurationDialog.this.validate();
            }
        });
        GridData gridData = (GridData)this.fClientIP.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        this.fClientIPButton = SWTFactory.createPushButton((Composite)this.fClientIpComposite, null, null);
        this.fClientIPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (ZendDebuggerConfigurationDialog.this.fAutoModeButton.getSelection()) {
                    ZendDebuggerConfigurationDialog.this.reloadIPs();
                } else if (ZendDebuggerConfigurationDialog.this.fManualModeButton.getSelection()) {
                    ZendDebuggerConfigurationDialog.this.openIPsDialog();
                }
            }
        });
        this.addLabelControl(connectionSettingsGroup, PHPDebugCoreMessages.DebuggerConfigurationDialog_debugPort, PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT);
        this.fDebugTextBox = this.addTextField(connectionSettingsGroup, PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, 6, 2);
        gridData = (GridData)this.fDebugTextBox.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        this.fDebugTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ZendDebuggerConfigurationDialog.this.validate();
            }
        });
        this.addLabelControl(connectionSettingsGroup, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_debug_response_timeout, PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT);
        this.fDebugResponseTimeout = this.addTextField(connectionSettingsGroup, PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT, 0, 2);
        gridData = (GridData)this.fDebugResponseTimeout.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        this.fDebugResponseTimeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ZendDebuggerConfigurationDialog.this.validate();
            }
        });
        this.createNoteComposite(connectionSettingsGroup.getFont(), connectionSettingsGroup, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Note_label, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Note_text, 3);
        Composite generalSettingsGroup = this.createSubsection(parent, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_General_settings_group);
        this.addLabelControl(generalSettingsGroup, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Broadcast_port, PHPDebugCorePreferenceNames.ZEND_DEBUG_BROADCAST_PORT);
        this.fBroadcastPortText = this.addTextField(generalSettingsGroup, PHPDebugCorePreferenceNames.ZEND_DEBUG_BROADCAST_PORT, 6, 2);
        gridData = (GridData)this.fBroadcastPortText.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(100);
        this.fBroadcastPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ZendDebuggerConfigurationDialog.this.validate();
            }
        });
        this.addLabelControl(generalSettingsGroup, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Dummy_file_name, PHPDebugCorePreferenceNames.ZEND_DEBUG_DUMMY_FILE);
        this.fDummyFileText = this.addTextField(generalSettingsGroup, PHPDebugCorePreferenceNames.ZEND_DEBUG_DUMMY_FILE, 20, 2);
        gridData = (GridData)this.fDummyFileText.getLayoutData();
        gridData.widthHint = this.convertWidthInCharsToPixels(100);
        this.fUseSSLButton = this.addCheckBox(generalSettingsGroup, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_UseSSLEncryption, "zend_debug_use_ssl_encryption", 0);
        this.fRunWithDebugInfo = this.addCheckBox(generalSettingsGroup, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_runWithDebugInfo, PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO, 0);
        this.fUseNewProtocol = this.addCheckBox(generalSettingsGroup, PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_useNewProtocol, PHPDebugCorePreferenceNames.ZEND_NEW_PROTOCOL, 0);
        this.internalInitializeValues();
        return parent;
    }

    private Image getDialogImage() {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        Bundle bundle = Platform.getBundle((String)"org.eclipse.php.debug.ui");
        URL url = null;
        if (bundle != null) {
            url = FileLocator.find((Bundle)bundle, (IPath)new Path("$nl$/icon/full/wizban/zend_debugger_conf_wiz.png"), null);
            desc = ImageDescriptor.createFromURL((URL)url);
            return desc.createImage();
        }
        return null;
    }

    private void internalInitializeValues() {
        IPreferencesService service = Platform.getPreferencesService();
        this.fRunWithDebugInfo.setSelection(service.getBoolean("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO, false, null));
        this.fDebugTextBox.setText(Integer.toString(service.getInt("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, 0, null)));
        IEclipsePreferences instanceScope = InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core");
        String customClientHosts = instanceScope.get(PHPDebugCorePreferenceNames.CLIENT_IP, null);
        this.fAutoModeButton.setSelection(customClientHosts == null);
        this.fManualModeButton.setSelection(customClientHosts != null);
        this.fClientIP.setEnabled(customClientHosts != null);
        this.fClientIP.setText(PHPDebugPlugin.getDebugHosts());
        this.fDebugResponseTimeout.setText(Integer.toString(service.getInt("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT, 0, null)));
        this.fUseNewProtocol.setSelection(service.getBoolean("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.ZEND_NEW_PROTOCOL, false, null));
        this.fBroadcastPortText.setText(Integer.toString(service.getInt("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.ZEND_DEBUG_BROADCAST_PORT, 0, null)));
        this.fDummyFileText.setText(service.getString("org.eclipse.php.debug.core", PHPDebugCorePreferenceNames.ZEND_DEBUG_DUMMY_FILE, null, null));
        this.fUseSSLButton.setSelection(service.getBoolean("org.eclipse.php.debug.core", "zend_debug_use_ssl_encryption", false, null));
        this.fClientIPButton.setText(this.fManualModeButton.getSelection() ? PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Configure : PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Reload);
    }

    private String getClientIPs(String userHosts) {
        final ArrayList<Inet4Address> detectedIPs = new ArrayList<Inet4Address>();
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                detectedIPs.addAll(ZendDebuggerConfigurationDialog.this.fNetworkMonitor.getAllAddresses());
            }
        });
        String[] userHostsArray = PHPDebugUtil.getZendHostsArray(userHosts);
        ArrayList<Inet4Address> userIPs = new ArrayList<Inet4Address>();
        String[] stringArray = userHostsArray;
        int n = userHostsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String userHost = stringArray[n2];
            Inet4Address address = NetworkUtil.getByName((String)userHost, (int)2000);
            if (address != null) {
                userIPs.add(address);
            }
            ++n2;
        }
        ConfigureHostsDialog configureIPs = new ConfigureHostsDialog(userIPs, detectedIPs);
        int choice = configureIPs.open();
        if (choice != 0) {
            return "";
        }
        List<Inet4Address> selectdIPs = configureIPs.getSelectedIPs();
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<Inet4Address> ipsIterator = selectdIPs.iterator();
        if (ipsIterator.hasNext()) {
            stringBuffer.append(ipsIterator.next().getHostAddress());
        }
        while (ipsIterator.hasNext()) {
            stringBuffer.append(", " + ipsIterator.next().getHostAddress());
        }
        return stringBuffer.toString();
    }

    private void reloadIPs() {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ZendDebuggerConfigurationDialog.this.fNetworkMonitor = new NetworkMonitor();
                ArrayList<Inet4Address> addresses = new ArrayList<Inet4Address>();
                addresses.addAll(ZendDebuggerConfigurationDialog.this.fNetworkMonitor.getPrivateAddresses());
                addresses.add(NetworkUtil.LOCALHOST);
                StringBuffer addressesString = new StringBuffer();
                for (Inet4Address address : addresses) {
                    addressesString.append(String.valueOf(addressesString.length() != 0 ? ", " : "") + address.getHostAddress());
                }
                ZendDebuggerConfigurationDialog.this.fClientIP.setText(addressesString.toString());
            }
        });
        this.validate();
    }

    private void openIPsDialog() {
        String clientIPs = this.getClientIPs(this.fClientIP.getText());
        if (!clientIPs.isEmpty()) {
            this.fClientIP.setText(clientIPs);
            this.validate();
        }
    }

    protected void okPressed() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.php.debug.core");
        prefs.putBoolean(PHPDebugCorePreferenceNames.RUN_WITH_DEBUG_INFO, this.fRunWithDebugInfo.getSelection());
        prefs.put(PHPDebugCorePreferenceNames.ZEND_DEBUG_PORT, this.fDebugTextBox.getText());
        prefs.putInt(PHPDebugCorePreferenceNames.ZEND_DEBUG_BROADCAST_PORT, Integer.parseInt(this.fBroadcastPortText.getText()));
        prefs.put(PHPDebugCorePreferenceNames.ZEND_DEBUG_DUMMY_FILE, this.fDummyFileText.getText().trim());
        if (this.fAutoModeButton.getSelection()) {
            prefs.remove(PHPDebugCorePreferenceNames.CLIENT_IP);
        } else {
            prefs.put(PHPDebugCorePreferenceNames.CLIENT_IP, this.fClientIP.getText());
        }
        prefs.putInt(PHPDebugCorePreferenceNames.DEBUG_RESPONSE_TIMEOUT, Integer.parseInt(this.fDebugResponseTimeout.getText()));
        prefs.putBoolean(PHPDebugCorePreferenceNames.ZEND_NEW_PROTOCOL, this.fUseNewProtocol.getSelection());
        prefs.putBoolean("zend_debug_use_ssl_encryption", this.fUseSSLButton.getSelection());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
        super.okPressed();
    }

    protected void validate() {
        this.setMessage(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_Dialog_description);
        String debugPort = this.fDebugTextBox.getText();
        Integer debugPortNumber = null;
        try {
            debugPortNumber = Integer.valueOf(debugPort);
            int i = debugPortNumber;
            if (i < 1 || i > 65535) {
                this.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPortRange, 3);
                return;
            }
        }
        catch (NumberFormatException ex) {
            this.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPort, 3);
            return;
        }
        catch (Exception e) {
            this.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPort, 3);
            return;
        }
        String broadcastPort = this.fBroadcastPortText.getText();
        Integer broadcastPortNumber = null;
        try {
            broadcastPortNumber = Integer.valueOf(broadcastPort);
            int i = broadcastPortNumber;
            if (i < 1 || i > 65535) {
                this.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPortRange, 3);
                return;
            }
        }
        catch (NumberFormatException ex) {
            this.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPort, 3);
            return;
        }
        catch (Exception e) {
            this.setMessage(PHPDebugCoreMessages.DebugConfigurationDialog_invalidPort, 3);
            return;
        }
        String responseTime = this.fDebugResponseTimeout.getText();
        Integer responseTimeout = null;
        try {
            responseTimeout = Integer.valueOf(responseTime);
            int i = responseTimeout;
            if (i < 5000) {
                this.setMessage(NLS.bind((String)PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_invalid_response_time, (Object)5000), 3);
                return;
            }
        }
        catch (Exception exc) {
            this.setMessage(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_invalid_response_time_exc, 3);
            return;
        }
        String[] clientHosts = PHPDebugUtil.getZendHostsArray(this.fClientIP.getText());
        this.fNetworkMonitor.validate(clientHosts, new NetworkMonitor.IHostsValidationListener[]{new NetworkMonitor.IHostsValidationListener(){

            public void validated(List<String> invalidAddresses) {
                if (!invalidAddresses.isEmpty()) {
                    StringBuilder addresses = new StringBuilder();
                    for (String address : invalidAddresses) {
                        addresses.append(String.valueOf(addresses.length() != 0 ? ", " : "") + '\'' + address + '\'');
                    }
                    String message = invalidAddresses.size() == 1 ? MessageFormat.format(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_ClientIPWarning, addresses.toString()) : MessageFormat.format(PHPDebugCoreMessages.ZendDebuggerConfigurationDialog_ClientIPsWarning, addresses.toString());
                    final String warningMessage = message;
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ZendDebuggerConfigurationDialog.this.getShell().isDisposed() && ZendDebuggerConfigurationDialog.this.getButton(0).isEnabled()) {
                                ZendDebuggerConfigurationDialog.this.setMessage(warningMessage, 2);
                            }
                        }
                    });
                }
            }
        }});
        if (!PHPLaunchUtilities.isPortAvailable(debugPortNumber) && !PHPLaunchUtilities.isDebugDaemonActive(debugPortNumber, "org.eclipse.php.debug.core.zendDebugger")) {
            this.setMessage(NLS.bind((String)PHPDebugCoreMessages.DebugConfigurationDialog_PortInUse, (Object)debugPort), 2);
        }
        if (!PHPLaunchUtilities.isPortAvailable(broadcastPortNumber)) {
            for (ICommunicationDaemon daemon : DaemonsRegistry.getDaemons()) {
                if (!(daemon instanceof BroadcastDaemon) || ((BroadcastDaemon)daemon).isListening(broadcastPortNumber)) continue;
                this.setMessage(NLS.bind((String)PHPDebugCoreMessages.DebugConfigurationDialog_PortInUse, (Object)broadcastPort), 2);
            }
        }
    }
}

