/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.php.internal.core.compiler.ast.parser.PHPProblemIdentifier;
import org.eclipse.php.internal.ui.text.correction.LocalCorrectionsSubProcessor;
import org.eclipse.php.internal.ui.text.correction.ModifierCorrectionSubProcessor;
import org.eclipse.php.internal.ui.text.correction.ReorgCorrectionsSubProcessor;
import org.eclipse.php.internal.ui.text.correction.UnresolvedElementsSubProcessor;
import org.eclipse.php.ui.text.correction.IInvocationContext;
import org.eclipse.php.ui.text.correction.IProblemLocation;
import org.eclipse.php.ui.text.correction.IQuickFixProcessor;

public class QuickFixProcessor
implements IQuickFixProcessor {
    @Override
    public IScriptCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations == null || locations.length == 0) {
            return null;
        }
        HashSet<IProblemIdentifier> handledProblems = new HashSet<IProblemIdentifier>(locations.length);
        ArrayList<IScriptCompletionProposal> resultingCollections = new ArrayList<IScriptCompletionProposal>();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            IProblemIdentifier id = curr.getProblemIdentifier();
            if (handledProblems.add(id)) {
                this.process(context, curr, resultingCollections);
            }
            ++i;
        }
        return resultingCollections.toArray(new IScriptCompletionProposal[resultingCollections.size()]);
    }

    private void process(IInvocationContext context, IProblemLocation problem, Collection<IScriptCompletionProposal> proposals) throws CoreException {
        if (!(problem.getProblemIdentifier() instanceof PHPProblemIdentifier)) {
            return;
        }
        PHPProblemIdentifier id = (PHPProblemIdentifier)problem.getProblemIdentifier();
        switch (id) {
            case DuplicateImport: 
            case UnusedImport: 
            case UnnecessaryImport: {
                ReorgCorrectionsSubProcessor.removeImportStatementProposals(context, problem, proposals);
                break;
            }
            case ImportNotFound: {
                ReorgCorrectionsSubProcessor.removeImportStatementProposals(context, problem, proposals);
                break;
            }
            case ClassExtendFinalClass: {
                ModifierCorrectionSubProcessor.addNonAccessibleReferenceProposal(context, problem, proposals, 5, 9);
                break;
            }
            case AbstractMethodInAbstractClass: 
            case BodyForAbstractMethod: {
                ModifierCorrectionSubProcessor.addAbstractMethodProposals(context, problem, proposals);
                break;
            }
            case AbstractMethodsInConcreteClass: {
                ModifierCorrectionSubProcessor.addAbstractTypeProposals(context, problem, proposals);
                break;
            }
            case MethodRequiresBody: {
                ModifierCorrectionSubProcessor.addMethodRequiresBodyProposals(context, problem, proposals);
                break;
            }
            case UndefinedType: {
                UnresolvedElementsSubProcessor.getTypeProposals(context, problem, proposals);
                break;
            }
            case AbstractMethodMustBeImplemented: {
                LocalCorrectionsSubProcessor.addUnimplementedMethodsProposals(context, problem, proposals);
                break;
            }
            case SuperclassMustBeAClass: {
                LocalCorrectionsSubProcessor.getInterfaceExtendsClassProposals(context, problem, proposals);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    public boolean hasCorrections(ISourceModule unit, IProblemIdentifier identifier) {
        if (!(identifier instanceof PHPProblemIdentifier)) {
            return false;
        }
        PHPProblemIdentifier problem = (PHPProblemIdentifier)identifier;
        switch (problem) {
            case AbstractMethodInAbstractClass: 
            case BodyForAbstractMethod: 
            case MethodRequiresBody: 
            case AbstractMethodsInConcreteClass: 
            case UndefinedType: 
            case ClassExtendFinalClass: 
            case ImportNotFound: 
            case DuplicateImport: 
            case UnusedImport: 
            case UnnecessaryImport: 
            case AbstractMethodMustBeImplemented: 
            case SuperclassMustBeAClass: {
                return true;
            }
        }
        return false;
    }
}

