/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.phar.wizard;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.internal.core.ZipArchiveFile;
import org.eclipse.dltk.internal.core.util.Util;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BPListElement;
import org.eclipse.dltk.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.internal.core.phar.PharArchiveFile;
import org.eclipse.php.internal.core.tar.TarArchiveFile;
import org.eclipse.php.internal.ui.phar.wizard.PharPackagerMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PharUIUtil {
    public static boolean askForOverwritePermission(Shell parent, IPath filePath, boolean isOSPath) {
        if (parent == null) {
            return false;
        }
        return PharUIUtil.queryDialog(parent, PharPackagerMessages.JarPackage_confirmReplace_title, Messages.format((String)PharPackagerMessages.JarPackage_confirmReplace_message, (Object)BasicElementLabels.getPathLabel((IPath)filePath, (boolean)isOSPath)));
    }

    private static boolean queryDialog(final Shell parent, final String title, final String message) {
        Display display = parent.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        final boolean[] returnValue = new boolean[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                returnValue[0] = MessageDialog.openQuestion((Shell)parent, (String)title, (String)message);
            }
        };
        display.syncExec(runnable);
        return returnValue[0];
    }

    public static boolean askToCreateDirectory(Shell parent, File directory) {
        if (parent == null) {
            return false;
        }
        return PharUIUtil.queryDialog(parent, PharPackagerMessages.JarPackage_confirmCreate_title, Messages.format((String)PharPackagerMessages.JarPackage_confirmCreate_message, (Object)BasicElementLabels.getPathLabel((File)directory)));
    }

    public static CoreException createCoreException(String message, Exception ex) {
        if (message == null) {
            message = "";
        }
        return new CoreException((IStatus)new Status(4, "org.eclipse.php.ui", 10001, message, (Throwable)ex));
    }

    public static boolean isInvalidPharBuildEntry(BPListElement cpentry) {
        IBuildpathEntry entry = cpentry.getBuildpathEntry();
        return PharUIUtil.isInvalidPharBuildEntry(entry);
    }

    public static boolean isInvalidPharBuildEntry(IBuildpathEntry entry) {
        if (entry.getEntryKind() == 1 && PHPToolkitUtil.isPharFileName((String)entry.getPath().toString())) {
            String extension;
            File pharFile;
            block11: {
                try {
                    pharFile = null;
                    IPath path = entry.getPath();
                    extension = path.getFileExtension();
                    if (EnvironmentPathUtils.isFull((IPath)path)) {
                        path = EnvironmentPathUtils.getLocalPath((IPath)path);
                        pharFile = path.toFile();
                    } else {
                        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                        IResource file = root.findMember(path);
                        pharFile = Util.toLocalFile((URI)file.getLocationURI(), null);
                    }
                    if (pharFile != null && pharFile.exists()) break block11;
                    return true;
                }
                catch (Exception e) {
                    return true;
                }
            }
            if ("phar".equals(extension)) {
                new PharArchiveFile(pharFile);
            } else if ("zip".equals(extension)) {
                new ZipArchiveFile(pharFile);
            } else if ("tar".equals(extension) || "gz".equals(extension) || "bz2".equals(extension)) {
                new TarArchiveFile(pharFile);
            }
        }
        return false;
    }
}

