/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;

public class IgnoreCountData {
    private int value;
    private State state;

    public static IgnoreCountData parseString(String input) {
        State state;
        int value;
        String stateStr;
        String valueStr;
        int separatorPos = input.indexOf(47);
        if (separatorPos == -1) {
            valueStr = input;
            stateStr = null;
        } else {
            valueStr = input.substring(0, separatorPos);
            stateStr = input.substring(separatorPos + 1);
        }
        if (valueStr.isEmpty()) {
            value = -1;
        } else {
            try {
                value = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException e) {
                ChromiumDebugPlugin.log(new Exception("Failed to parse ignore count value: " + input, e));
                value = -1;
            }
        }
        if (stateStr == null) {
            state = value == -1 ? State.DISABLED : State.ENABLED;
        } else {
            try {
                state = State.valueOf(stateStr);
            }
            catch (IllegalArgumentException e) {
                ChromiumDebugPlugin.log(new Exception("Failed to parse ignore count value: " + input, e));
                state = State.ENABLED;
            }
        }
        return new IgnoreCountData(value, state);
    }

    public IgnoreCountData(int value, State state) {
        this.value = value;
        this.state = state;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getEffectiveValue() {
        if (this.state == State.ENABLED) {
            return this.value;
        }
        return -1;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String getStringRepresentation() {
        return String.valueOf(this.value) + "/" + this.state.toString();
    }

    public static enum State {
        ENABLED,
        DISABLED,
        RESET;

    }
}

