/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.commands;

import java.util.Iterator;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.commands.AddTypesCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.AddXSDSchemaCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.WSDLElementCommand;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public final class AddXSDElementDeclarationCommand
extends WSDLElementCommand {
    private Definition definition;
    private String targetNamespace;
    private String elementName;
    private XSDSchema schema;
    private XSDElementDeclaration xsdElement;

    public AddXSDElementDeclarationCommand(Definition definition, String elementName) {
        this.definition = definition;
        this.targetNamespace = definition.getTargetNamespace();
        this.elementName = elementName;
    }

    public AddXSDElementDeclarationCommand(Definition definition, String targetNamespace, String elementName) {
        this.definition = definition;
        this.targetNamespace = targetNamespace;
        this.elementName = elementName;
    }

    public void run() {
        XSDSchema xsdSchema = this.getSchema();
        XSDElementDeclaration elementDecl = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        elementDecl.setName(this.elementName);
        XSDSimpleTypeDefinition simpleTypeDefinition = this.getXSDStringType(xsdSchema);
        elementDecl.setTypeDefinition((XSDTypeDefinition)simpleTypeDefinition);
        xsdSchema.getContents().add((Object)elementDecl);
        this.xsdElement = elementDecl;
    }

    public void run(String newElementName) {
        this.elementName = newElementName;
        this.run();
    }

    public void setSchema(XSDSchema schema) {
        this.schema = schema;
    }

    public XSDSchema getSchema() {
        if (this.schema == null) {
            return this.getXSDSchema(this.targetNamespace);
        }
        return this.schema;
    }

    private XSDSimpleTypeDefinition getXSDStringType(XSDSchema schema) {
        return schema.getSchemaForSchema().resolveSimpleTypeDefinition("string");
    }

    private XSDSchema getXSDSchema(String targetNamespace) {
        Iterator iterator = this.getTypes().getSchemas(targetNamespace).iterator();
        if (iterator.hasNext()) {
            XSDSchema xsdSchema = (XSDSchema)iterator.next();
            return xsdSchema;
        }
        AddXSDSchemaCommand command = new AddXSDSchemaCommand(this.definition, targetNamespace);
        command.run();
        return ((XSDSchemaExtensibilityElement)command.getWSDLElement()).getSchema();
    }

    private Types getTypes() {
        Types types = (Types)this.definition.getTypes();
        if (types != null) {
            return types;
        }
        AddTypesCommand command = new AddTypesCommand(this.definition);
        command.run();
        return (Types)command.getWSDLElement();
    }

    public WSDLElement getWSDLElement() {
        return null;
    }

    public XSDElementDeclaration getXSDElement() {
        return this.xsdElement;
    }
}

