/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.analyzer.config.impl;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSIFileNotFoundException;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AnalyzerConfig;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AnalyzerConfigReader;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AssertionResultType;
import org.eclipse.wst.wsi.internal.core.analyzer.config.WSDLElement;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.AnalyzerConfigImpl;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.AssertionResultsOptionImpl;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.UDDIReferenceImpl;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.WSDLElementImpl;
import org.eclipse.wst.wsi.internal.core.analyzer.config.impl.WSDLReferenceImpl;
import org.eclipse.wst.wsi.internal.core.common.impl.AddStyleSheetImpl;
import org.eclipse.wst.wsi.internal.core.util.MessageList;
import org.eclipse.wst.wsi.internal.core.util.TestUtils;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AnalyzerConfigReaderImpl
implements AnalyzerConfigReader {
    protected MessageList messageList;
    protected String documentURI;

    public void init(MessageList messageList) {
        this.messageList = messageList;
    }

    public AnalyzerConfig readAnalyzerConfig(String analyzerConfigURI) throws WSIException {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(analyzerConfigURI);
        }
        catch (FileNotFoundException fnfe) {
            throw new WSIFileNotFoundException(this.getMessage("config01", analyzerConfigURI, "Could not find analyzer config file: "), fnfe);
        }
        catch (Exception e) {
            throw new WSIException(this.getMessage("config08", analyzerConfigURI, "Could not read analyzer config file: "), e);
        }
        return this.readAnalyzerConfig(fileReader);
    }

    public AnalyzerConfig readAnalyzerConfig(Reader reader) throws WSIException {
        AnalyzerConfigImpl analyzerConfig = new AnalyzerConfigImpl();
        Document doc = XMLUtils.parseXML(reader);
        this.parseConfigElement(analyzerConfig, doc.getDocumentElement());
        return analyzerConfig;
    }

    public String getLocation() {
        return this.documentURI;
    }

    public void setLocation(String documentURI) {
        this.documentURI = documentURI;
    }

    private void parseConfigElement(AnalyzerConfig analyzerConfig, Element element) throws WSIException {
        Element nextElement = XMLUtils.getFirstChild(element);
        while (nextElement != null) {
            if (this.isElement(nextElement, "description")) {
                analyzerConfig.setDescription(XMLUtils.getText(nextElement));
            } else if (this.isElement(nextElement, "verbose")) {
                analyzerConfig.setVerboseOption(XMLUtils.getBooleanValue(nextElement, false));
            } else if (this.isElement(nextElement, "assertionResults")) {
                AssertionResultsOptionImpl assertionResultsOption = new AssertionResultsOptionImpl();
                analyzerConfig.setAssertionResultsOption(assertionResultsOption);
                String resultType = XMLUtils.getAttributeValue(nextElement, "type");
                assertionResultsOption.setAssertionResultType(AssertionResultType.newInstance(resultType));
                assertionResultsOption.setShowMessageEntry(XMLUtils.getBooleanValue(nextElement, "messageEntry", assertionResultsOption.getShowMessageEntry()));
                assertionResultsOption.setShowFailureMessage(XMLUtils.getBooleanValue(nextElement, "failureMessage", assertionResultsOption.getShowFailureMessage()));
                assertionResultsOption.setShowFailureDetail(XMLUtils.getBooleanValue(nextElement, "failureDetail", assertionResultsOption.getShowFailureDetail()));
            } else if (this.isElement(nextElement, "reportFile")) {
                this.parseReportFileElement(analyzerConfig, nextElement);
            } else if (this.isElement(nextElement, "testAssertionsFile")) {
                analyzerConfig.setTestAssertionsDocumentLocation(XMLUtils.getText(nextElement));
            } else if (this.isElement(nextElement, "logFile")) {
                String correlationType = XMLUtils.getAttributeValue(nextElement, "correlationType");
                analyzerConfig.setCorrelationType(correlationType == null ? "operation" : correlationType);
                analyzerConfig.setLogLocation(XMLUtils.getText(nextElement));
            } else if (this.isElement(nextElement, "wsdlReference")) {
                this.parseWsdlReference(analyzerConfig, nextElement);
            } else if (this.isElement(nextElement, "uddiReference")) {
                this.parseUddiReference(analyzerConfig, nextElement);
            } else {
                throw new IllegalArgumentException(this.getMessage("config06", nextElement.getLocalName(), "Invalid analyzer config element:"));
            }
            nextElement = XMLUtils.getNextSibling(nextElement);
        }
    }

    private void parseReportFileElement(AnalyzerConfig analyzerConfig, Element element) throws WSIException {
        analyzerConfig.setReplaceReport(XMLUtils.getBooleanValue(element, "replace", false));
        analyzerConfig.setReportLocation(XMLUtils.getAttributeValue(element, "location", "report.xml"));
        Element nextElement = XMLUtils.getFirstChild(element);
        while (nextElement != null) {
            if (!this.isElement(nextElement, "addStyleSheet")) {
                throw new IllegalArgumentException(this.getMessage("config06", nextElement.getLocalName(), "Invalid analyzer config element:"));
            }
            AddStyleSheetImpl addStyleSheet = new AddStyleSheetImpl();
            TestUtils.parseAddStyleSheet(nextElement, addStyleSheet, "../common/xsl/report.xsl");
            analyzerConfig.setAddStyleSheet(addStyleSheet);
            nextElement = XMLUtils.getNextSibling(nextElement);
        }
    }

    private void parseWsdlReference(AnalyzerConfig analyzerConfig, Element element) throws WSIException {
        WSDLReferenceImpl wsdlReference = new WSDLReferenceImpl();
        analyzerConfig.setWSDLReference(wsdlReference);
        Element nextElement = XMLUtils.getFirstChild(element);
        while (nextElement != null) {
            if (this.isElement(nextElement, "wsdlURI")) {
                wsdlReference.setWSDLLocation(XMLUtils.getText(nextElement));
            } else if (this.isElement(nextElement, "serviceLocation")) {
                wsdlReference.setServiceLocation(XMLUtils.getText(nextElement));
            } else if (this.isElement(nextElement, "wsdlElement")) {
                wsdlReference.setWSDLElement(this.parseWsdlElement(nextElement));
            } else {
                throw new IllegalArgumentException(this.getMessage("config06", nextElement.getLocalName(), "Invalid analyzer config element:"));
            }
            nextElement = XMLUtils.getNextSibling(nextElement);
        }
        if (wsdlReference.getWSDLElement() == null || wsdlReference.getWSDLLocation() == null) {
            throw new IllegalArgumentException(this.getMessage("config07", "Both the <wsdlElement> and <wsdlURI> elements must be specified."));
        }
        if ((wsdlReference.getWSDLElement().getType().equalsIgnoreCase("port") || wsdlReference.getWSDLElement().getType().equalsIgnoreCase("operation")) && wsdlReference.getWSDLElement().getParentElementName() == null) {
            throw new IllegalArgumentException(this.getMessage("config09", "The parentElementName attribute must be specified with a WSDL type of port or operation."));
        }
    }

    private void parseUddiReference(AnalyzerConfig analyzerConfig, Element element) throws WSIException {
        UDDIReferenceImpl uddiReference = new UDDIReferenceImpl();
        analyzerConfig.setUDDIReference(uddiReference);
        Element nextElement = XMLUtils.getFirstChild(element);
        while (nextElement != null) {
            if (this.isElement(nextElement, "inquiryURL")) {
                uddiReference.setInquiryURL(XMLUtils.getText(nextElement));
            } else if (this.isElement(nextElement, "uddiKey")) {
                uddiReference.setKey(XMLUtils.getText(nextElement));
                uddiReference.setKeyType(XMLUtils.getAttributeValue(nextElement, "type"));
            } else if (this.isElement(nextElement, "wsdlElement")) {
                uddiReference.setWSDLElement(this.parseWsdlElement(nextElement));
            } else if (this.isElement(nextElement, "serviceLocation")) {
                uddiReference.setServiceLocation(XMLUtils.getText(nextElement));
            } else {
                throw new IllegalArgumentException(this.getMessage("config06", nextElement.getLocalName(), "Invalid analyzer config element:"));
            }
            nextElement = XMLUtils.getNextSibling(nextElement);
        }
    }

    private WSDLElement parseWsdlElement(Element element) throws WSIException {
        WSDLElementImpl wsdlElement = new WSDLElementImpl();
        wsdlElement.setType(XMLUtils.getAttributeValue(element, "type"));
        wsdlElement.setNamespace(XMLUtils.getAttributeValue(element, "namespace"));
        wsdlElement.setParentElementName(XMLUtils.getAttributeValue(element, "parentElementName"));
        String wsdlElementName = XMLUtils.getText(element);
        if (wsdlElementName.equals("")) {
            throw new IllegalArgumentException(this.getMessage("config19", "The WSDL element name must be specified."));
        }
        wsdlElement.setName(wsdlElementName);
        return wsdlElement;
    }

    private boolean isElement(Element element, String localName) {
        return this.isElement(element, AnalyzerConfigReaderImpl.getValidWSIAnalyzerConfigNamespaces(), localName);
    }

    public static List getValidWSIAnalyzerConfigNamespaces() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("http://www.ws-i.org/testing/2003/03/analyzerConfig/");
        list.add("http://www.ws-i.org/testing/2004/07/analyzerConfig/");
        return list;
    }

    private boolean isElement(Element element, List namespaces, String localName) {
        return XMLUtils.isElement(element, namespaces, localName);
    }

    private String getMessage(String messageID, String defaultMessage) {
        return this.getMessage(messageID, null, defaultMessage);
    }

    private String getMessage(String messageID, String messageData, String defaultMessage) {
        String message = defaultMessage;
        message = this.messageList != null ? this.messageList.getMessage(messageID, messageData, defaultMessage) : String.valueOf(message) + " " + messageData + ".";
        return message;
    }
}

