/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.sourcebuilder.page;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.s.model.ScoutAnnotationSourceBuilderFactory;
import org.eclipse.scout.sdk.core.s.model.ScoutMethodSourceBuilderFactory;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.SortedMemberKeyFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.AbstractEntitySourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.MethodSourceBuilderFactory;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.TypeSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.typeparameter.ITypeParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.typeparameter.TypeParameterSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;

public class PageSourceBuilder
extends AbstractEntitySourceBuilder {
    public static final String INNER_TABLE_NAME = "Table";
    public static final String EXEC_LOAD_DATA_FILTER_ARG_NAME = "filter";
    private boolean m_isPageWithTable;
    private boolean m_isAbstractPage;
    private boolean m_createNlsMethod = true;
    private String m_pageDataSignature;
    private String m_superTypeSignature;
    private String m_pageServiceIfcSignature;
    private String m_classIdValue;
    private String m_tableClassIdValue;
    private String m_dataFetchMethodName;

    public PageSourceBuilder(String elementName, String packageName, IJavaEnvironment env) {
        super(elementName, packageName, env);
    }

    public void setup() {
        this.setComment(CommentSourceBuilderFactory.createDefaultCompilationUnitComment((ICompilationUnitSourceBuilder)this));
        TypeSourceBuilder pageBuilder = new TypeSourceBuilder(this.getEntityName());
        this.addType((ITypeSourceBuilder)pageBuilder);
        pageBuilder.setFlags(1);
        String typeParamName = "T";
        if (this.isAbstractPage()) {
            pageBuilder.setFlags(pageBuilder.getFlags() | 0x400);
            if (this.isPageWithTable()) {
                TypeParameterSourceBuilder tableTypeParamBuilder = new TypeParameterSourceBuilder(typeParamName);
                String typeParamBoundary = String.valueOf(pageBuilder.getFullyQualifiedName()) + '<' + typeParamName + '>' + '.' + INNER_TABLE_NAME;
                tableTypeParamBuilder.addBoundSignature(Signature.createTypeSignature((String)typeParamBoundary));
                pageBuilder.addTypeParameter((ITypeParameterSourceBuilder)tableTypeParamBuilder);
            }
        }
        String superTypeSignature = this.getSuperTypeSignature();
        if (this.isPageWithTable()) {
            ITypeSourceBuilder tableBuilder = this.createTableBuilder();
            pageBuilder.addType(tableBuilder);
            StringBuilder superTypeBuilder = new StringBuilder(SignatureUtils.toFullyQualifiedName((String)this.getSuperTypeSignature()));
            superTypeBuilder.append('<');
            if (this.isAbstractPage()) {
                superTypeBuilder.append(typeParamName);
            } else {
                superTypeBuilder.append(tableBuilder.getFullyQualifiedName());
            }
            superTypeBuilder.append('>');
            superTypeSignature = Signature.createTypeSignature((String)superTypeBuilder.toString());
        }
        pageBuilder.setSuperTypeSignature(superTypeSignature);
        if (StringUtils.isNotBlank((CharSequence)this.getClassIdValue())) {
            pageBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createClassId(this.getClassIdValue()));
        }
        if (this.isPageWithTable() && StringUtils.isNotBlank((CharSequence)this.getPageDataSignature())) {
            pageBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createData(this.getPageDataSignature()));
        }
        if (this.isCreateNlsMethod()) {
            IMethodSourceBuilder getConfiguredTitle = ScoutMethodSourceBuilderFactory.createNlsMethod("getConfiguredTitle", this.getEntityName());
            pageBuilder.addSortedMethod(SortedMemberKeyFactory.createMethodGetConfiguredKey((IMethodSourceBuilder)getConfiguredTitle), getConfiguredTitle);
        }
        if (!this.isAbstractPage()) {
            if (this.isPageWithTable()) {
                IMethodSourceBuilder execLoadData = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)pageBuilder, (String)this.getPackageName(), (IJavaEnvironment)this.getJavaEnvironment(), (String)"execLoadData");
                execLoadData.setBody(new ISourceBuilder(){

                    public void createSource(StringBuilder source, String lineDelimiter, PropertyMap context, IImportValidator validator) {
                        if (PageSourceBuilder.this.getPageServiceIfcSignature() == null) {
                            source.append(CoreUtils.getCommentBlock((String)"implement data load")).append(lineDelimiter);
                            source.append("// e.g.: importPageData(BEANS.get(IMyService.class).getTableData(").append(PageSourceBuilder.EXEC_LOAD_DATA_FILTER_ARG_NAME).append("));");
                        } else {
                            source.append("importPageData(").append(validator.useName("org.eclipse.scout.rt.platform.BEANS")).append(".get(").append(validator.useSignature(PageSourceBuilder.this.getPageServiceIfcSignature())).append(SuffixConstants.SUFFIX_class).append(").").append(PageSourceBuilder.this.getDataFetchMethodName()).append('(').append(PageSourceBuilder.EXEC_LOAD_DATA_FILTER_ARG_NAME).append("));");
                        }
                    }
                });
                execLoadData.removeAnnotation("org.eclipse.scout.rt.platform.Order");
                execLoadData.removeAnnotation("org.eclipse.scout.rt.platform.annotations.ConfigOperation");
                pageBuilder.addSortedMethod(SortedMemberKeyFactory.createMethodExecKey((IMethodSourceBuilder)execLoadData), execLoadData);
            } else {
                IMethodSourceBuilder execCreateChildPages = MethodSourceBuilderFactory.createOverride((ITypeSourceBuilder)pageBuilder, (String)this.getPackageName(), (IJavaEnvironment)this.getJavaEnvironment(), (String)"execCreateChildPages");
                if (execCreateChildPages != null) {
                    execCreateChildPages.removeAnnotation("org.eclipse.scout.rt.platform.Order");
                    execCreateChildPages.removeAnnotation("org.eclipse.scout.rt.platform.annotations.ConfigOperation");
                    pageBuilder.addSortedMethod(SortedMemberKeyFactory.createMethodExecKey((IMethodSourceBuilder)execCreateChildPages), execCreateChildPages);
                }
            }
        }
    }

    protected ITypeSourceBuilder createTableBuilder() {
        TypeSourceBuilder tableBuilder = new TypeSourceBuilder(INNER_TABLE_NAME);
        tableBuilder.setFlags(1);
        tableBuilder.setSuperTypeSignature(Signature.createTypeSignature((String)"org.eclipse.scout.rt.client.ui.basic.table.AbstractTable"));
        if (StringUtils.isNotBlank((CharSequence)this.getTableClassIdValue())) {
            tableBuilder.addAnnotation(ScoutAnnotationSourceBuilderFactory.createClassId(this.getTableClassIdValue()));
        }
        return tableBuilder;
    }

    public boolean isPageWithTable() {
        return this.m_isPageWithTable;
    }

    public void setPageWithTable(boolean isPageWithTable) {
        this.m_isPageWithTable = isPageWithTable;
    }

    public String getPageDataSignature() {
        return this.m_pageDataSignature;
    }

    public void setPageDataSignature(String pageDataSignature) {
        this.m_pageDataSignature = pageDataSignature;
    }

    public String getSuperTypeSignature() {
        return this.m_superTypeSignature;
    }

    public void setSuperTypeSignature(String superTypeSignature) {
        this.m_superTypeSignature = superTypeSignature;
    }

    public String getClassIdValue() {
        return this.m_classIdValue;
    }

    public void setClassIdValue(String classIdValue) {
        this.m_classIdValue = classIdValue;
    }

    public String getTableClassIdValue() {
        return this.m_tableClassIdValue;
    }

    public void setTableClassIdValue(String tableClassIdValue) {
        this.m_tableClassIdValue = tableClassIdValue;
    }

    public String getPageServiceIfcSignature() {
        return this.m_pageServiceIfcSignature;
    }

    public void setPageServiceIfcSignature(String pageServiceIfcSignature) {
        this.m_pageServiceIfcSignature = pageServiceIfcSignature;
    }

    public String getDataFetchMethodName() {
        return this.m_dataFetchMethodName;
    }

    public void setDataFetchMethodName(String dataFetchMethodName) {
        this.m_dataFetchMethodName = dataFetchMethodName;
    }

    public boolean isAbstractPage() {
        return this.m_isAbstractPage;
    }

    public void setAbstractPage(boolean isAbstractPage) {
        this.m_isAbstractPage = isAbstractPage;
    }

    public boolean isCreateNlsMethod() {
        return this.m_createNlsMethod;
    }

    public void setCreateNlsMethod(boolean createNlsMethod) {
        this.m_createNlsMethod = createNlsMethod;
    }
}

