/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.logging.Level;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class SimpleLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;
    private final String m_name;

    static void init() {
    }

    public SimpleLogger(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isTraceEnabled() {
        return SdkLog.isDebugEnabled();
    }

    public void trace(String msg) {
        SimpleLogger.log(Level.FINE, msg, null);
    }

    public void trace(String format, Object param1) {
        SimpleLogger.formatAndLog(Level.FINE, format, param1, null);
    }

    public void trace(String format, Object param1, Object param2) {
        SimpleLogger.formatAndLog(Level.FINE, format, param1, param2);
    }

    public void trace(String format, Object ... argArray) {
        SimpleLogger.formatAndLog(Level.FINE, format, argArray);
    }

    public void trace(String msg, Throwable t) {
        SimpleLogger.log(Level.FINE, msg, t);
    }

    public boolean isDebugEnabled() {
        return SdkLog.isDebugEnabled();
    }

    public void debug(String msg) {
        SimpleLogger.log(Level.FINE, msg, null);
    }

    public void debug(String format, Object param1) {
        SimpleLogger.formatAndLog(Level.FINE, format, param1, null);
    }

    public void debug(String format, Object param1, Object param2) {
        SimpleLogger.formatAndLog(Level.FINE, format, param1, param2);
    }

    public void debug(String format, Object ... argArray) {
        SimpleLogger.formatAndLog(Level.FINE, format, argArray);
    }

    public void debug(String msg, Throwable t) {
        SimpleLogger.log(Level.FINE, msg, t);
    }

    public boolean isInfoEnabled() {
        return SdkLog.isInfoEnabled();
    }

    public void info(String msg) {
        SimpleLogger.log(Level.INFO, msg, null);
    }

    public void info(String format, Object arg) {
        SimpleLogger.formatAndLog(Level.INFO, format, arg, null);
    }

    public void info(String format, Object arg1, Object arg2) {
        SimpleLogger.formatAndLog(Level.INFO, format, arg1, arg2);
    }

    public void info(String format, Object ... argArray) {
        SimpleLogger.formatAndLog(Level.INFO, format, argArray);
    }

    public void info(String msg, Throwable t) {
        SimpleLogger.log(Level.INFO, msg, t);
    }

    public boolean isWarnEnabled() {
        return SdkLog.isWarningEnabled();
    }

    public void warn(String msg) {
        SimpleLogger.log(Level.WARNING, msg, null);
    }

    public void warn(String format, Object arg) {
        SimpleLogger.formatAndLog(Level.WARNING, format, arg, null);
    }

    public void warn(String format, Object arg1, Object arg2) {
        SimpleLogger.formatAndLog(Level.WARNING, format, arg1, arg2);
    }

    public void warn(String format, Object ... argArray) {
        SimpleLogger.formatAndLog(Level.WARNING, format, argArray);
    }

    public void warn(String msg, Throwable t) {
        SimpleLogger.log(Level.WARNING, msg, t);
    }

    public boolean isErrorEnabled() {
        return SdkLog.isErrorEnabled();
    }

    public void error(String msg) {
        SimpleLogger.log(Level.SEVERE, msg, null);
    }

    public void error(String format, Object arg) {
        SimpleLogger.formatAndLog(Level.SEVERE, format, arg, null);
    }

    public void error(String format, Object arg1, Object arg2) {
        SimpleLogger.formatAndLog(Level.SEVERE, format, arg1, arg2);
    }

    public void error(String format, Object ... argArray) {
        SimpleLogger.formatAndLog(Level.SEVERE, format, argArray);
    }

    public void error(String msg, Throwable t) {
        SimpleLogger.log(Level.SEVERE, msg, t);
    }

    private static void log(Level level, String message, Throwable t) {
        SdkLog.log((Level)level, (String)message, (Object[])new Object[]{t});
    }

    private static void formatAndLog(Level level, String format, Object arg1, Object arg2) {
        if (!SdkLog.isLevelEnabled((Level)level)) {
            return;
        }
        FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        SimpleLogger.log(level, tp.getMessage(), tp.getThrowable());
    }

    private static void formatAndLog(Level level, String format, Object ... arguments) {
        if (!SdkLog.isLevelEnabled((Level)level)) {
            return;
        }
        FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        SimpleLogger.log(level, tp.getMessage(), tp.getThrowable());
    }
}

