/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javadocexport;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.ui.JavaUI;

public class JavadocLinkRef {
    private final IJavaProject fProject;
    private final IPath fContainerPath;
    private IClasspathEntry fClasspathEntry;

    public JavadocLinkRef(IPath containerPath, IClasspathEntry classpathEntry, IJavaProject project) {
        this.fContainerPath = containerPath;
        this.fProject = project;
        this.fClasspathEntry = classpathEntry;
    }

    public JavadocLinkRef(IJavaProject project) {
        this(null, null, project);
    }

    public boolean isProjectRef() {
        return this.fClasspathEntry == null;
    }

    public IPath getFullPath() {
        return this.isProjectRef() ? this.fProject.getPath() : this.fClasspathEntry.getPath();
    }

    public URL getURL() {
        if (this.isProjectRef()) {
            return JavaUI.getProjectJavadocLocation(this.fProject);
        }
        return JavaUI.getLibraryJavadocLocation(this.fClasspathEntry);
    }

    public void setURL(URL url, IProgressMonitor monitor) throws CoreException {
        if (this.isProjectRef()) {
            JavaUI.setProjectJavadocLocation(this.fProject, url);
        } else {
            CPListElement element = CPListElement.createFromExisting(this.fClasspathEntry, this.fProject);
            String location = url != null ? url.toExternalForm() : null;
            element.setAttribute("javadoc_location", location);
            String[] changedAttributes = new String[]{"javadoc_location"};
            BuildPathSupport.modifyClasspathEntry(null, element.getClasspathEntry(), changedAttributes, this.fProject, this.fContainerPath, this.fClasspathEntry.getReferencingEntry() != null, monitor);
            this.fClasspathEntry = element.getClasspathEntry();
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            JavadocLinkRef other = (JavadocLinkRef)obj;
            if (!this.fProject.equals(other.fProject) || this.isProjectRef() != other.isProjectRef()) {
                return false;
            }
            if (!this.isProjectRef()) {
                return this.fClasspathEntry.equals(other.fClasspathEntry);
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.isProjectRef()) {
            return this.fProject.hashCode();
        }
        return this.fProject.hashCode() + this.fClasspathEntry.hashCode();
    }
}

