/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.viewsupport.LinkedProposalModelPresenter;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class LinkedCorrectionProposal
extends ASTRewriteCorrectionProposal {
    private LinkedProposalModel fLinkedProposalModel = null;

    public LinkedCorrectionProposal(String name, ICompilationUnit cu, ASTRewrite rewrite, int relevance, Image image) {
        super(name, cu, rewrite, relevance, image);
    }

    protected LinkedProposalModel getLinkedProposalModel() {
        if (this.fLinkedProposalModel == null) {
            this.fLinkedProposalModel = new LinkedProposalModel();
        }
        return this.fLinkedProposalModel;
    }

    public void setLinkedProposalModel(LinkedProposalModel model) {
        this.fLinkedProposalModel = model;
    }

    public void addLinkedPosition(ITrackedNodePosition position, boolean isFirst, String groupID) {
        this.getLinkedProposalModel().getPositionGroup(groupID, true).addPosition(position, isFirst);
    }

    public void addLinkedPosition(ITrackedNodePosition position, int sequenceRank, String groupID) {
        this.getLinkedProposalModel().getPositionGroup(groupID, true).addPosition(position, sequenceRank);
    }

    public void setEndPosition(ITrackedNodePosition position) {
        this.getLinkedProposalModel().setEndPosition(position);
    }

    public void addLinkedPositionProposal(String groupID, String proposal, Image image) {
        this.getLinkedProposalModel().getPositionGroup(groupID, true).addProposal(proposal, image, 10);
    }

    @Deprecated
    public void addLinkedPositionProposal(String groupID, String displayString, String proposal, Image image) {
        this.addLinkedPositionProposal(groupID, proposal, image);
    }

    public void addLinkedPositionProposal(String groupID, ITypeBinding type) {
        this.getLinkedProposalModel().getPositionGroup(groupID, true).addProposal(type, this.getCompilationUnit(), 10);
    }

    @Override
    protected void performChange(IEditorPart part, IDocument document) throws CoreException {
        try {
            super.performChange(part, document);
            if (part == null) {
                return;
            }
            if (this.fLinkedProposalModel != null) {
                LinkedProposalPositionGroup.PositionInformation endPosition;
                if (this.fLinkedProposalModel.hasLinkedPositions() && part instanceof JavaEditor) {
                    ISourceViewer viewer = ((JavaEditor)part).getViewer();
                    new LinkedProposalModelPresenter().enterLinkedMode((ITextViewer)viewer, part, this.didOpenEditor(), this.fLinkedProposalModel);
                } else if (part instanceof ITextEditor && (endPosition = this.fLinkedProposalModel.getEndPosition()) != null) {
                    int pos = endPosition.getOffset() + endPosition.getLength();
                    ((ITextEditor)part).selectAndReveal(pos, 0);
                }
            }
        }
        catch (BadLocationException e) {
            throw new CoreException(JavaUIStatus.createError(4, e));
        }
    }
}

