/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.wst.ws.internal.explorer.platform.actions.LinkAction;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.perspective.FavoritesPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLPerspective;

public class WSDLAddToFavoritesAction
extends LinkAction {
    public WSDLAddToFavoritesAction(Controller controller) {
        super(controller);
    }

    protected boolean processLinkParameters(HttpServletRequest request) {
        String nodeID = request.getParameter("nodeId");
        try {
            Integer.parseInt(nodeID);
            this.propertyTable_.put("nodeId", nodeID);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static String getActionLink(int nodeID) {
        StringBuffer actionLink = new StringBuffer("wsdl/actions/WSDLCheckFavoriteExistsActionJSP.jsp?");
        actionLink.append("nodeId");
        actionLink.append('=');
        actionLink.append(nodeID);
        return actionLink.toString();
    }

    public boolean favoriteExists() {
        String wsdlUrl = this.getWsdlUrl();
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("wsdlURL", wsdlUrl);
        FavoritesFolderElement favFolderElement = this.getFavWSDLFolderElement();
        return favFolderElement.favoriteExists(table);
    }

    public boolean run() {
        WSDLPerspective wsdlPerspective = this.controller_.getWSDLPerspective();
        String wsdlUrl = this.getWsdlUrl();
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("wsdlURL", wsdlUrl);
        FavoritesFolderElement favFolderElement = this.getFavWSDLFolderElement();
        if (favFolderElement.addFavorite(table)) {
            wsdlPerspective.getMessageQueue().addMessage(wsdlPerspective.getMessage("MSG_INFO_ADD_TO_FAVORITES_SUCCESSFUL", wsdlUrl));
            return true;
        }
        wsdlPerspective.getMessageQueue().addMessage(wsdlPerspective.getMessage("MSG_ERROR_ADD_TO_FAVORITES", wsdlUrl));
        return false;
    }

    private String getWsdlUrl() {
        String nodeID = (String)this.propertyTable_.get("nodeId");
        WSDLPerspective wsdlPerspective = this.controller_.getWSDLPerspective();
        NodeManager wsdlNodeManager = wsdlPerspective.getNodeManager();
        WSDLElement selectedElement = (WSDLElement)wsdlNodeManager.getNode(Integer.parseInt(nodeID)).getTreeElement();
        return selectedElement.getWsdlUrl();
    }

    private FavoritesFolderElement getFavWSDLFolderElement() {
        FavoritesPerspective favPerspective = this.controller_.getFavoritesPerspective();
        NodeManager favNodeManager = favPerspective.getNodeManager();
        TreeElement favRootElement = favNodeManager.getRootNode().getTreeElement();
        Enumeration e = favRootElement.getElements("relWSDLServiceFolderNode");
        return (FavoritesFolderElement)((Object)e.nextElement());
    }
}

