/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.IType;
import org.eclipse.scout.sdk.core.model.api.internal.TypeImplementor;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.FieldSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.model.spi.PackageSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingAnnotationWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingTypeWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;

public class BindingArrayTypeWithJdt
extends AbstractTypeWithJdt {
    private static final FieldBinding LENGTH_FIELD = new FieldBinding("length".toCharArray(), (TypeBinding)TypeBinding.INT, 17, null, null);
    private final ArrayBinding m_binding;
    private final boolean m_isWildcard;
    private final int m_arrayDimension;
    private final TypeSpi m_leafComponentType;
    private final String m_name;
    private PackageSpi m_package;
    private String m_elementName;
    private List<BindingAnnotationWithJdt> m_annotations;
    private List<FieldSpi> m_fields;

    BindingArrayTypeWithJdt(JavaEnvironmentWithJdt env, ArrayBinding binding, boolean isWildcard) {
        super(env);
        this.m_binding = (ArrayBinding)Validate.notNull((Object)binding);
        this.m_isWildcard = isWildcard;
        this.m_arrayDimension = binding.dimensions;
        this.m_leafComponentType = SpiWithJdtUtils.bindingToType(env, binding.leafComponentType);
        this.m_name = String.valueOf(this.m_leafComponentType.getName()) + StringUtils.leftPad((String)"", (int)(this.m_arrayDimension * 2), (String)"[]");
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        return newEnv.findType(this.getName());
    }

    @Override
    protected IType internalCreateApi() {
        return new TypeImplementor(this);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public int getArrayDimension() {
        return this.m_arrayDimension;
    }

    @Override
    public TypeSpi getLeafComponentType() {
        return this.m_leafComponentType;
    }

    public ArrayBinding getInternalBinding() {
        return this.m_binding;
    }

    @Override
    public CompilationUnitSpi getCompilationUnit() {
        return null;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public PackageSpi getPackage() {
        if (this.m_package == null) {
            char[] qualifiedPackageName = this.m_binding.qualifiedPackageName();
            this.m_package = qualifiedPackageName == null || qualifiedPackageName.length < 1 ? this.m_env.createDefaultPackage() : this.m_env.createPackage(new String(qualifiedPackageName));
        }
        return this.m_package;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getElementName() {
        if (this.m_elementName == null) {
            this.m_elementName = new String(this.m_binding.sourceName());
        }
        return this.m_elementName;
    }

    @Override
    public List<FieldSpi> getFields() {
        if (this.m_fields == null) {
            this.m_fields = Collections.singletonList(this.m_env.createBindingField(this, LENGTH_FIELD));
        }
        return this.m_fields;
    }

    @Override
    public List<MethodSpi> getMethods() {
        return Collections.emptyList();
    }

    @Override
    public List<TypeSpi> getTypes() {
        return Collections.emptyList();
    }

    @Override
    public BindingTypeWithJdt getDeclaringType() {
        return null;
    }

    @Override
    public TypeSpi getSuperClass() {
        return null;
    }

    @Override
    public List<TypeSpi> getSuperInterfaces() {
        return Collections.emptyList();
    }

    @Override
    public boolean isWildcardType() {
        return this.m_isWildcard;
    }

    @Override
    public List<TypeSpi> getTypeArguments() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasTypeParameters() {
        return false;
    }

    @Override
    public List<TypeParameterSpi> getTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public TypeSpi getOriginalType() {
        return this;
    }

    public List<BindingAnnotationWithJdt> getAnnotations() {
        if (this.m_annotations == null) {
            this.m_annotations = SpiWithJdtUtils.createBindingAnnotations(this.m_env, this, this.m_binding.getAnnotations());
        }
        return this.m_annotations;
    }

    @Override
    public int getFlags() {
        return 0;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public ISourceRange getSource() {
        return ISourceRange.NO_SOURCE;
    }

    @Override
    public ISourceRange getSourceOfStaticInitializer() {
        return ISourceRange.NO_SOURCE;
    }

    @Override
    public ISourceRange getJavaDoc() {
        return ISourceRange.NO_SOURCE;
    }
}

