/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.model.spi.internal;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.model.api.ISourceRange;
import org.eclipse.scout.sdk.core.model.api.internal.MethodParameterImplementor;
import org.eclipse.scout.sdk.core.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.model.spi.JavaElementSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodParameterSpi;
import org.eclipse.scout.sdk.core.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.model.spi.internal.AbstractJavaElementWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingAnnotationWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.BindingMethodWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.core.model.spi.internal.SpiWithJdtUtils;

public class BindingMethodParameterWithJdt
extends AbstractJavaElementWithJdt<IMethodParameter>
implements MethodParameterSpi {
    private final BindingMethodWithJdt m_declaringMethod;
    private final TypeBinding m_binding;
    private final int m_index;
    private final char[] m_name;
    private TypeSpi m_dataType;
    private ISourceRange m_source;
    private String m_nameS;
    private List<BindingAnnotationWithJdt> m_annotations;

    BindingMethodParameterWithJdt(JavaEnvironmentWithJdt env, BindingMethodWithJdt declaringMethod, TypeBinding binding, char[] name, int index) {
        super(env);
        this.m_index = index;
        this.m_name = (char[])Validate.notNull((Object)name);
        this.m_binding = (TypeBinding)Validate.notNull((Object)binding);
        this.m_declaringMethod = (BindingMethodWithJdt)Validate.notNull((Object)declaringMethod);
    }

    @Override
    protected JavaElementSpi internalFindNewElement(JavaEnvironmentWithJdt newEnv) {
        MethodSpi newMethod = (MethodSpi)this.getDeclaringMethod().internalFindNewElement(newEnv);
        if (newMethod != null && newMethod.getParameters().size() > this.m_index) {
            return newMethod.getParameters().get(this.m_index);
        }
        return null;
    }

    @Override
    protected IMethodParameter internalCreateApi() {
        return new MethodParameterImplementor(this);
    }

    public TypeBinding getInternalBinding() {
        return this.m_binding;
    }

    @Override
    public String getElementName() {
        if (this.m_nameS == null && this.m_name != null) {
            this.m_nameS = new String(this.m_name);
        }
        return this.m_nameS;
    }

    @Override
    public TypeSpi getDataType() {
        if (this.m_dataType == null) {
            this.m_dataType = SpiWithJdtUtils.bindingToType(this.m_env, this.m_binding);
        }
        return this.m_dataType;
    }

    @Override
    public int getFlags() {
        return 0;
    }

    @Override
    public BindingMethodWithJdt getDeclaringMethod() {
        return this.m_declaringMethod;
    }

    public List<BindingAnnotationWithJdt> getAnnotations() {
        if (this.m_annotations != null) {
            return this.m_annotations;
        }
        AnnotationBinding[][] a = this.m_declaringMethod.getInternalBinding().getParameterAnnotations();
        this.m_annotations = a == null || this.m_index >= a.length ? Collections.emptyList() : SpiWithJdtUtils.createBindingAnnotations(this.m_env, this, a[this.m_index]);
        return this.m_annotations;
    }

    @Override
    public ISourceRange getSource() {
        if (this.m_source == null) {
            AbstractMethodDeclaration declMethod = this.m_declaringMethod.getInternalBinding().sourceMethod();
            if (declMethod != null) {
                CompilationUnitSpi cu = this.m_declaringMethod.getDeclaringType().getCompilationUnit();
                Argument decl = declMethod.arguments[this.m_index];
                this.m_source = this.m_env.getSource(cu, decl.declarationSourceStart, decl.declarationSourceEnd);
            } else {
                this.m_source = ISourceRange.NO_SOURCE;
            }
        }
        return this.m_source;
    }
}

